/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;

public class MultipartMimeUtils {
    public static MimeMultipart parseMultipartRequest(HttpServletRequest req) throws IOException, MessagingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)req.getInputStream(), (OutputStream)baos);
        return new MimeMultipart(MultipartMimeUtils.createDataSource(req.getContentType(), baos.toByteArray()));
    }

    public static DataSource createDataSource(String contentType, byte[] data) {
        return new StaticDataSource(contentType, data);
    }

    public static String getFieldName(BodyPart part) throws MessagingException {
        String[] values = part.getHeader("Content-Disposition");
        String name = null;
        if (values != null && values.length > 0) {
            name = new ContentDisposition(values[0]).getParameter("name");
        }
        return name != null ? name : "unknown";
    }

    public static String getTextContent(BodyPart part) throws MessagingException, IOException {
        ContentType contentType = new ContentType(part.getContentType());
        String charset = contentType.getParameter("charset");
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteStreams.copy((InputStream)part.getInputStream(), (OutputStream)baos);
        try {
            return new String(baos.toByteArray(), charset);
        }
        catch (UnsupportedEncodingException ex) {
            return new String(baos.toByteArray());
        }
    }

    private static class StaticDataSource
    implements DataSource {
        private final String contentType;
        private final byte[] bytes;

        public StaticDataSource(String contentType, byte[] bytes) {
            this.contentType = contentType;
            this.bytes = bytes;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "request";
        }
    }
}

