/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Stopwatch;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

class VmAppLogsWriter {
    private static final Logger logger = Logger.getLogger(VmAppLogsWriter.class.getName());
    static final String LOG_CONTINUATION_SUFFIX = "\n<continued in next message>";
    static final int LOG_CONTINUATION_SUFFIX_LENGTH = "\n<continued in next message>".length();
    static final String LOG_CONTINUATION_PREFIX = "<continued from previous message>\n";
    static final int LOG_CONTINUATION_PREFIX_LENGTH = "<continued from previous message>\n".length();
    static final int MIN_MAX_LOG_MESSAGE_LENGTH = 1024;
    static final int LOG_FLUSH_TIMEOUT_MS = 2000;
    private final int maxLogMessageLength;
    private final int logCutLength;
    private final int logCutLengthDiv10;
    private final List<LogServicePb.UserAppLogLine> buffer;
    private final long maxBytesToFlush;
    private long currentByteCount;
    private final int maxSecondsBetweenFlush;
    private int flushCount = 0;
    private Future<byte[]> currentFlush;
    private Stopwatch stopwatch;

    public VmAppLogsWriter(List<LogServicePb.UserAppLogLine> buffer, long maxBytesToFlush, int maxLogMessageLength, int maxFlushSeconds) {
        String message;
        this.buffer = buffer;
        this.maxSecondsBetweenFlush = maxFlushSeconds;
        if (maxLogMessageLength < 1024) {
            message = String.format("maxLogMessageLength silly small (%s); setting maxLogMessageLength to %s", maxLogMessageLength, 1024);
            logger.warning(message);
            this.maxLogMessageLength = 1024;
        } else {
            this.maxLogMessageLength = maxLogMessageLength;
        }
        this.logCutLength = maxLogMessageLength - LOG_CONTINUATION_SUFFIX_LENGTH;
        this.logCutLengthDiv10 = this.logCutLength / 10;
        if (maxBytesToFlush < (long)this.maxLogMessageLength) {
            message = String.format("maxBytesToFlush (%s) smaller than  maxLogMessageLength (%s)", maxBytesToFlush, this.maxLogMessageLength);
            logger.warning(message);
            this.maxBytesToFlush = this.maxLogMessageLength;
        } else {
            this.maxBytesToFlush = maxBytesToFlush;
        }
        this.stopwatch = Stopwatch.createUnstarted();
    }

    synchronized void addLogRecordAndMaybeFlush(ApiProxy.LogRecord fullRecord) {
        for (ApiProxy.LogRecord record : this.split(fullRecord)) {
            LogServicePb.UserAppLogLine logLine = new LogServicePb.UserAppLogLine();
            logLine.setLevel((long)record.getLevel().ordinal());
            logLine.setTimestampUsec(record.getTimestamp());
            logLine.setMessage(record.getMessage());
            int maxEncodingSize = logLine.maxEncodingSize();
            if (this.maxBytesToFlush > 0L && this.currentByteCount + (long)maxEncodingSize > this.maxBytesToFlush) {
                long l = this.currentByteCount;
                logger.info(new StringBuilder(65).append(l).append(" bytes of app logs pending, starting flush...").toString());
                this.waitForCurrentFlushAndStartNewFlush();
            }
            if (this.buffer.size() == 0) {
                this.stopwatch.start();
            }
            this.buffer.add(logLine);
            this.currentByteCount += (long)maxEncodingSize;
        }
        if (this.maxSecondsBetweenFlush > 0 && this.stopwatch.elapsed(TimeUnit.SECONDS) >= (long)this.maxSecondsBetweenFlush) {
            this.waitForCurrentFlushAndStartNewFlush();
        }
    }

    synchronized int waitForCurrentFlushAndStartNewFlush() {
        this.waitForCurrentFlush();
        if (this.buffer.size() > 0) {
            this.currentFlush = this.doFlush();
        }
        return this.flushCount;
    }

    synchronized int flushAndWait() {
        this.waitForCurrentFlush();
        if (this.buffer.size() > 0) {
            this.currentFlush = this.doFlush();
            this.waitForCurrentFlush();
        }
        return this.flushCount;
    }

    private void waitForCurrentFlush() {
        if (this.currentFlush != null) {
            logger.info("End of request or previous flush has not yet completed, blocking.");
            try {
                this.currentFlush.get(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                logger.warning("Interruped while blocking on a log flush, setting interrupt bit and continuing.  Some logs may be lost or occur out of order!");
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                logger.log(Level.WARNING, "Timeout waiting for log flush to complete. Log messages may have been lost/reordered!", e);
            }
            catch (ExecutionException ex) {
                logger.log(Level.WARNING, "A log flush request failed.  Log messages may have been lost!", ex);
            }
            this.currentFlush = null;
        }
    }

    private Future<byte[]> doFlush() {
        LogServicePb.UserAppLogGroup group = new LogServicePb.UserAppLogGroup();
        for (LogServicePb.UserAppLogLine logLine : this.buffer) {
            group.addLogLine(logLine);
        }
        this.buffer.clear();
        this.currentByteCount = 0L;
        ++this.flushCount;
        this.stopwatch.reset();
        LogServicePb.FlushRequest request = new LogServicePb.FlushRequest();
        request.setLogsAsBytes(group.toByteArray());
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(2.0));
        return ApiProxy.makeAsyncCall((String)"logservice", (String)"Flush", (byte[])request.toByteArray(), (ApiProxy.ApiConfig)apiConfig);
    }

    @VisibleForTesting
    List<ApiProxy.LogRecord> split(ApiProxy.LogRecord aRecord) {
        LinkedList<ApiProxy.LogRecord> theList = new LinkedList<ApiProxy.LogRecord>();
        String message = aRecord.getMessage();
        if (null == message || message.length() <= this.maxLogMessageLength) {
            theList.add(aRecord);
            return theList;
        }
        String remaining = message;
        while (remaining.length() > 0) {
            String nextMessage;
            if (remaining.length() <= this.maxLogMessageLength) {
                nextMessage = remaining;
                remaining = "";
            } else {
                int cutLength = this.logCutLength;
                boolean cutAtNewline = false;
                int friendlyCutLength = remaining.lastIndexOf(10, this.logCutLength);
                if (friendlyCutLength > this.logCutLengthDiv10) {
                    cutLength = friendlyCutLength;
                    cutAtNewline = true;
                }
                String string = String.valueOf(remaining.substring(0, cutLength));
                String string2 = String.valueOf(LOG_CONTINUATION_SUFFIX);
                nextMessage = string2.length() != 0 ? string.concat(string2) : new String(string);
                if ((remaining = remaining.substring(cutLength + (cutAtNewline ? 1 : 0))).length() > this.maxLogMessageLength || remaining.length() + LOG_CONTINUATION_PREFIX_LENGTH <= this.maxLogMessageLength) {
                    String string3 = String.valueOf(LOG_CONTINUATION_PREFIX);
                    String string4 = String.valueOf(remaining);
                    remaining = string4.length() != 0 ? string3.concat(string4) : new String(string3);
                }
            }
            theList.add(new ApiProxy.LogRecord(aRecord, nextMessage));
        }
        return theList;
    }

    @VisibleForTesting
    void setStopwatch(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    @VisibleForTesting
    int getMaxLogMessageLength() {
        return this.maxLogMessageLength;
    }

    @VisibleForTesting
    long getByteCountBeforeFlushing() {
        return this.maxBytesToFlush;
    }
}

