/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.vmruntime.VmApiProxyEnvironment;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class VmRuntimeFileLogHandler
extends FileHandler {
    private static final String LOG_PATTERN_CONFIG_PROPERTY = "com.google.apphosting.vmruntime.VmRuntimeFileLogHandler.pattern";
    private static final String DEFAULT_LOG_PATTERN = "/var/log/app_engine/app.%g.log.json";
    private static final String APP_ENGINE_LOG_CONFIG_PATTERN_ENV = "APP_ENGINE_LOG_CONFIG_PATTERN";
    private static final int LOG_MAX_SIZE = 0x6400000;
    private static final int LOG_MAX_FILES = 3;

    private VmRuntimeFileLogHandler() throws IOException {
        super(VmRuntimeFileLogHandler.fileLogPattern(), 0x6400000, 3, true);
        this.setLevel(Level.FINEST);
        this.setFormatter(new CustomFormatter());
    }

    private static String fileLogPattern() {
        String pattern = System.getenv(APP_ENGINE_LOG_CONFIG_PATTERN_ENV);
        if (pattern != null) {
            return pattern;
        }
        pattern = System.getProperty(LOG_PATTERN_CONFIG_PROPERTY);
        if (pattern != null) {
            return pattern;
        }
        return DEFAULT_LOG_PATTERN;
    }

    public static void init() throws IOException {
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof VmRuntimeFileLogHandler)) continue;
            return;
        }
        rootLogger.addHandler(new VmRuntimeFileLogHandler());
    }

    private static String convertLogLevel(Level level) {
        long intLevel = level.intValue();
        if (intLevel >= (long)Level.SEVERE.intValue()) {
            return "ERROR";
        }
        if (intLevel >= (long)Level.WARNING.intValue()) {
            return "WARNING";
        }
        if (intLevel >= (long)Level.INFO.intValue()) {
            return "INFO";
        }
        return "DEBUG";
    }

    private static final class CustomFormatter
    extends Formatter {
        private CustomFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            if (record.getSourceClassName() != null) {
                sb.append(record.getSourceClassName());
            } else {
                sb.append(record.getLoggerName());
            }
            if (record.getSourceMethodName() != null) {
                sb.append(" ");
                sb.append(record.getSourceMethodName());
            }
            sb.append(": ");
            String message = this.formatMessage(record);
            sb.append(message);
            if (record.getThrown() != null) {
                try {
                    sb.append("\n");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception sw) {
                    // empty catch block
                }
            }
            Gson gson = new Gson();
            message = sb.toString();
            long seconds = record.getMillis() / 1000L;
            long nanos = record.getMillis() % 1000L * 1000000L;
            String thread = Integer.toString(record.getThreadID());
            String severity = VmRuntimeFileLogHandler.convertLogLevel(record.getLevel());
            String traceId = CustomFormatter.getCurrentTraceId();
            return String.valueOf(gson.toJson((Object)new LogData(message, seconds, nanos, thread, severity, traceId))).concat("\n");
        }

        private static String getCurrentTraceId() {
            ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
            if (environment == null) {
                return null;
            }
            Object value = environment.getAttributes().get(VmApiProxyEnvironment.AttributeMapping.CLOUD_TRACE_CONTEXT.attributeKey);
            if (!(value instanceof String)) {
                return null;
            }
            String fullTraceId = (String)value;
            if (fullTraceId.isEmpty() || Character.digit(fullTraceId.charAt(0), 16) < 0) {
                return null;
            }
            for (int index = 1; index < fullTraceId.length(); ++index) {
                char ch = fullTraceId.charAt(index);
                if (Character.digit(ch, 16) >= 0) continue;
                return fullTraceId.substring(0, index);
            }
            return null;
        }
    }

    @VisibleForTesting
    public static final class LogData {
        private String message;
        private LogTimestamp timestamp;
        private String thread;
        private String severity;
        private String traceId;

        LogData(String message, long seconds, long nanos, String thread, String severity, String traceId) {
            this.message = message;
            this.timestamp = new LogTimestamp(seconds, nanos);
            this.thread = thread;
            this.severity = severity;
            this.traceId = traceId;
        }

        public String getMessage() {
            return this.message;
        }

        public LogTimestamp getTimestamp() {
            return this.timestamp;
        }

        public String getThread() {
            return this.thread;
        }

        public String getSeverity() {
            return this.severity;
        }

        public String getTraceId() {
            return this.traceId;
        }
    }

    @VisibleForTesting
    public static final class LogTimestamp {
        private long seconds;
        private long nanos;

        LogTimestamp(long seconds, long nanos) {
            this.seconds = seconds;
            this.nanos = nanos;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public long getNanos() {
            return this.nanos;
        }
    }
}

