/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime.jetty9;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.DatastoreSessionStore;
import com.google.apphosting.runtime.DeferredDatastoreSessionStore;
import com.google.apphosting.runtime.MemcacheSessionStore;
import com.google.apphosting.runtime.SessionStore;
import com.google.apphosting.runtime.jetty9.SessionManager;
import com.google.apphosting.runtime.timer.Timer;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.servlet.HttpServletRequestAdapter;
import com.google.apphosting.utils.servlet.HttpServletResponseAdapter;
import com.google.apphosting.vmruntime.CommitDelayingResponse;
import com.google.apphosting.vmruntime.VmApiProxyDelegate;
import com.google.apphosting.vmruntime.VmApiProxyEnvironment;
import com.google.apphosting.vmruntime.VmEnvironmentFactory;
import com.google.apphosting.vmruntime.VmMetadataCache;
import com.google.apphosting.vmruntime.VmRequestUtils;
import com.google.apphosting.vmruntime.VmRuntimeFileLogHandler;
import com.google.apphosting.vmruntime.VmRuntimeLogHandler;
import com.google.apphosting.vmruntime.VmRuntimeUtils;
import com.google.apphosting.vmruntime.VmTimer;
import com.google.apphosting.vmruntime.jetty9.AppEngineAuthentication;
import com.google.apphosting.vmruntime.jetty9.StubSessionManager;
import com.google.apphosting.vmruntime.jetty9.VmRuntimeTrustedAddressChecker;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.quickstart.QuickStartConfiguration;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;

public class VmRuntimeWebAppContext
extends WebAppContext
implements VmRuntimeTrustedAddressChecker {
    private static final Logger logger = Logger.getLogger(VmRuntimeWebAppContext.class.getName());
    private static final String[] SYSTEM_CLASSES = new String[]{"com.google.appengine.api.", "com.google.appengine.tools.", "com.google.apphosting.", "com.google.cloud.sql.jdbc.", "com.google.protos.cloud.sql.", "com.google.storage.onestore."};
    protected static final int MAX_RESPONSE_SIZE = 0x2000000;
    private final String serverInfo = VmRuntimeUtils.getServerInfo();
    private final VmMetadataCache metadataCache;
    private final Timer wallclockTimer;
    private VmApiProxyEnvironment defaultEnvironment;
    @VisibleForTesting
    boolean isDevMode;
    private static final String[] quickstartConfigurationClasses;
    private static final String[] preconfigurationClasses;

    protected void doStart() throws Exception {
        Resource base = this.getBaseResource();
        if (base == null) {
            base = Resource.newResource((String)this.getWar());
        }
        if (!base.isDirectory()) {
            throw new IllegalArgumentException();
        }
        Resource dir = base;
        Resource qswebxml = dir.addPath("/WEB-INF/quickstart-web.xml");
        if (qswebxml.exists()) {
            this.setConfigurationClasses(quickstartConfigurationClasses);
        }
        super.doStart();
    }

    private static List<SessionStore> createSessionStores(AppEngineWebXml appEngineWebXml) {
        DatastoreSessionStore datastoreSessionStore = appEngineWebXml.getAsyncSessionPersistence() ? new DeferredDatastoreSessionStore(appEngineWebXml.getAsyncSessionPersistenceQueueName()) : new DatastoreSessionStore();
        return Arrays.asList(datastoreSessionStore, new MemcacheSessionStore());
    }

    private void setSchemeAndPort(Request request) {
        String https = request.getHeader("X-AppEngine-Https");
        if ("on".equals(https)) {
            request.setSecure(true);
            request.setScheme(HttpScheme.HTTPS.toString());
            request.setServerPort(443);
        } else {
            request.setSecure(false);
            request.setScheme(HttpScheme.HTTP.toString());
            request.setServerPort(this.defaultEnvironment.getServerPort());
        }
    }

    public VmRuntimeWebAppContext() {
        this._scontext = new VmRuntimeServletContext();
        AppEngineAuthentication.configureSecurityHandler((ConstraintSecurityHandler)this.getSecurityHandler(), this);
        this.setMaxFormContentSize(0x2000000);
        this.setConfigurationClasses(preconfigurationClasses);
        this.setAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", ".*\\.jar");
        this.metadataCache = new VmMetadataCache();
        this.wallclockTimer = new VmTimer();
        ApiProxy.setDelegate((ApiProxy.Delegate)new VmApiProxyDelegate());
    }

    public void init(String appDir, String appengineWebXmlFile) throws AppEngineConfigException, IOException {
        this.setContextPath("/");
        this.setWar(appDir);
        this.setResourceBase(appDir);
        this.defaultEnvironment = VmApiProxyEnvironment.createDefaultContext(System.getenv(), this.metadataCache, VmRuntimeUtils.getApiServerAddress(), this.wallclockTimer, 86400000L, new File(appDir).getCanonicalPath());
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.defaultEnvironment);
        if (ApiProxy.getEnvironmentFactory() == null) {
            ApiProxy.setEnvironmentFactory((ApiProxy.EnvironmentFactory)new VmEnvironmentFactory(this.defaultEnvironment));
        }
        this.isDevMode = this.defaultEnvironment.getPartition().equals("dev");
        AppEngineWebXmlReader appEngineWebXmlReader = new AppEngineWebXmlReader(appDir, appengineWebXmlFile);
        AppEngineWebXml appEngineWebXml = appEngineWebXmlReader.readAppEngineWebXml();
        VmRuntimeUtils.installSystemProperties(this.defaultEnvironment, appEngineWebXml);
        VmRuntimeLogHandler.init();
        VmRuntimeFileLogHandler.init();
        for (String systemClass : SYSTEM_CLASSES) {
            this.addSystemClass(systemClass);
        }
        AbstractSessionManager sessionManager = appEngineWebXml.getSessionsEnabled() ? new SessionManager(VmRuntimeWebAppContext.createSessionStores(appEngineWebXml)) : new StubSessionManager();
        this.setSessionHandler(new SessionHandler((org.eclipse.jetty.server.SessionManager)sessionManager));
    }

    @Override
    public boolean isTrustedRemoteAddr(String remoteAddr) {
        return VmRequestUtils.isTrustedRemoteAddr(this.isDevMode, remoteAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doScope(String target, Request baseRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        HttpServletRequestAdapter request = new HttpServletRequestAdapter(httpServletRequest);
        HttpServletResponseAdapter response = new HttpServletResponseAdapter(httpServletResponse);
        if (DispatcherType.INCLUDE.equals((Object)httpServletRequest.getDispatcherType()) || DispatcherType.FORWARD.equals((Object)httpServletRequest.getDispatcherType())) {
            super.doScope(target, baseRequest, httpServletRequest, httpServletResponse);
            return;
        }
        VmApiProxyEnvironment requestSpecificEnvironment = VmApiProxyEnvironment.createFromHeaders(System.getenv(), this.metadataCache, request, VmRuntimeUtils.getApiServerAddress(), this.wallclockTimer, 86400000L, this.defaultEnvironment);
        CommitDelayingResponse wrappedResponse = httpServletResponse instanceof CommitDelayingResponse ? (CommitDelayingResponse)httpServletResponse : new CommitDelayingResponse(httpServletResponse);
        if (httpServletResponse instanceof Response) {
            ((Response)httpServletResponse).getHttpOutput().setBufferSize(wrappedResponse.getBufferSize());
        }
        try {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)requestSpecificEnvironment);
            VmRuntimeUtils.handleSkipAdminCheck(request);
            this.setSchemeAndPort(baseRequest);
            super.doScope(target, baseRequest, httpServletRequest, (HttpServletResponse)wrappedResponse);
        }
        finally {
            block22: {
                try {
                    VmRuntimeUtils.interruptRequestThreads(requestSpecificEnvironment, 10L);
                    if (!VmRuntimeUtils.waitForAsyncApiCalls(requestSpecificEnvironment, new HttpServletResponseAdapter((HttpServletResponse)wrappedResponse))) {
                        logger.warning("Timed out or interrupted while waiting for async API calls to complete.");
                    }
                    if (!response.isCommitted()) {
                        VmRuntimeUtils.flushLogsAndAddHeader(response, requestSpecificEnvironment);
                        break block22;
                    }
                    int n = httpServletResponse.getStatus();
                    throw new ServletException(new StringBuilder(108 + String.valueOf(target).length()).append("Response for request to '").append(target).append("' was already commited (code=").append(n).append("). This might result in lost log messages.'").toString());
                }
                finally {
                    try {
                        wrappedResponse.commit();
                    }
                    finally {
                        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.defaultEnvironment);
                    }
                }
            }
        }
    }

    static {
        System.setProperty("appengine.spi.useThreadContextClassLoader", Boolean.TRUE.toString());
        System.setProperty("appengine.api.memcache.useThreadContextClassLoader", Boolean.TRUE.toString());
        quickstartConfigurationClasses = new String[]{QuickStartConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), JettyWebXmlConfiguration.class.getCanonicalName()};
        preconfigurationClasses = new String[]{WebInfConfiguration.class.getCanonicalName(), WebXmlConfiguration.class.getCanonicalName(), MetaInfConfiguration.class.getCanonicalName(), FragmentConfiguration.class.getCanonicalName(), EnvConfiguration.class.getCanonicalName(), PlusConfiguration.class.getCanonicalName(), AnnotationConfiguration.class.getCanonicalName()};
    }

    public class VmRuntimeServletContext
    extends WebAppContext.Context {
        public VmRuntimeServletContext() {
            super((WebAppContext)VmRuntimeWebAppContext.this);
        }

        public ClassLoader getClassLoader() {
            return VmRuntimeWebAppContext.this.getClassLoader();
        }

        public String getServerInfo() {
            return VmRuntimeWebAppContext.this.serverInfo;
        }

        public void log(String message) {
            this.log(message, null);
        }

        public void log(String message, Throwable throwable) {
            StringWriter writer = new StringWriter();
            writer.append("javax.servlet.ServletContext log: ");
            writer.append(message);
            if (throwable != null) {
                writer.append("\n");
                throwable.printStackTrace(new PrintWriter(writer));
            }
            ApiProxy.LogRecord.Level logLevel = throwable == null ? ApiProxy.LogRecord.Level.info : ApiProxy.LogRecord.Level.error;
            ApiProxy.log((ApiProxy.LogRecord)new ApiProxy.LogRecord(logLevel, System.currentTimeMillis() * 1000L, writer.toString()));
        }

        public void log(Exception exception, String msg) {
            this.log(msg, exception);
        }
    }
}

