/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigLoader;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.ApiKey;
import com.google.api.server.spi.config.annotationreader.ApiConfigAnnotationReader;
import com.google.api.server.spi.config.jsonwriter.JsonConfigWriter;
import com.google.api.server.spi.tools.ApiConfigGenerator;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class AnnotationApiConfigGenerator
implements ApiConfigGenerator {
    private final ApiConfigWriter configWriter;
    private final ApiConfigLoader configLoader;

    public AnnotationApiConfigGenerator() throws ClassNotFoundException {
        this((ApiConfigWriter)new JsonConfigWriter(), AnnotationApiConfigGenerator.class.getClassLoader(), new ApiConfig.Factory());
    }

    public AnnotationApiConfigGenerator(ApiConfigWriter apiConfigWriter, ClassLoader classLoader, ApiConfig.Factory configFactory) throws ClassNotFoundException {
        this.configWriter = apiConfigWriter;
        this.configLoader = AnnotationApiConfigGenerator.createConfigLoader(configFactory, new TypeLoader(classLoader));
    }

    private static ApiConfigLoader createConfigLoader(ApiConfig.Factory configFactory, TypeLoader typeLoader) {
        return new ApiConfigLoader(configFactory, typeLoader, new ApiConfigAnnotationReader(typeLoader.getAnnotationTypes()), new ApiConfigSource[0]);
    }

    @Override
    public Map<String, String> generateConfig(Class<?> ... serviceClasses) throws ApiConfigException {
        return this.generateConfig(ServiceContext.create(), serviceClasses);
    }

    @Override
    public Map<String, String> generateConfig(ServiceContext serviceContext, Class<?> ... serviceClasses) throws ApiConfigException {
        ArrayList apiConfigs = Lists.newArrayListWithCapacity((int)serviceClasses.length);
        for (Class<?> serviceClass : serviceClasses) {
            apiConfigs.add(this.configLoader.loadConfiguration(serviceContext, serviceClass));
        }
        Map configByApiKey = this.configWriter.writeConfig((Iterable)apiConfigs);
        LinkedHashMap configByFileName = Maps.newLinkedHashMap();
        for (Map.Entry entry : configByApiKey.entrySet()) {
            String string = String.valueOf(((ApiKey)entry.getKey()).getApiString());
            String string2 = String.valueOf(this.configWriter.getFileExtension());
            configByFileName.put(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString(), entry.getValue());
        }
        return configByFileName;
    }
}

