/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.tools;

import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.tools.EndpointsTool;
import com.google.api.server.spi.tools.EndpointsToolAction;
import com.google.api.server.spi.tools.GenApiConfigAction;
import com.google.api.server.spi.tools.GenClientLibAction;
import com.google.api.server.spi.tools.GenDiscoveryDocAction;
import com.google.api.server.spi.tools.GetClientLibAction;
import com.google.api.server.spi.tools.GetDiscoveryDocAction;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import java.io.IOException;
import java.util.List;

public class HelpAction
extends EndpointsToolAction {
    public static final String NAME = "help";

    public HelpAction() {
        super(NAME);
        this.setOptions((List)ImmutableList.of());
        this.setShortDescription("Print out detailed usage for a command.");
        this.setHelpDisplayNeeded(true);
    }

    @Override
    public boolean execute() throws JsonGenerationException, JsonMappingException, ClassNotFoundException, IOException, ApiConfigException {
        String commandName;
        if (this.getArgs().isEmpty()) {
            EndpointsTool tool = new EndpointsTool();
            tool.printUsage();
            return true;
        }
        if (this.getArgs().size() > 1) {
            return false;
        }
        switch (commandName = (String)this.getArgs().get(0)) {
            case "get-client-lib": {
                this.printUsage(new GetClientLibAction());
                return true;
            }
            case "get-discovery-doc": {
                this.printUsage(new GetDiscoveryDocAction());
                return true;
            }
            case "gen-api-config": {
                this.printUsage(new GenApiConfigAction());
                return true;
            }
            case "gen-discovery-doc": {
                this.printUsage(new GenDiscoveryDocAction());
                return true;
            }
            case "gen-client-lib": {
                this.printUsage(new GenClientLibAction());
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    void printUsage(EndpointsToolAction action) {
        System.out.println(Joiner.on((char)'\n').join(action.getHelpLines()));
    }

    @Override
    public String getUsageString() {
        return "help <command name>";
    }
}

