/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.tools.development.ModulesController;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ModulesServlet
extends HttpServlet {
    private static final String AH_ADMIN_MODULES_PATH = "/_ah/admin/modules";
    private static final Logger logger = Logger.getLogger(ModulesServlet.class.getName());
    private static final String DEFAULT_MODULE_NAME = "defaultModuleName";
    private static final String APPLICATION_NAME = "applicationName";
    private static final String MODULES_STATE_INFO = "modulesStateInfo";
    private static final String ACTION_MODULE = "action:module";
    private final ModulesController modulesController = (ModulesController)ApiProxy.getCurrentEnvironment().getAttributes().get("com.google.appengine.dev.modules_controller");

    private ImmutableList<String> getAllInstanceHostnames(String moduleName, String version) {
        ImmutableList.Builder hostnameListBuilder = ImmutableList.builder();
        for (int i = 0; i < this.modulesController.getNumInstances(moduleName, version); ++i) {
            hostnameListBuilder.add((Object)this.modulesController.getHostname(moduleName, version, i));
        }
        return hostnameListBuilder.build();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
        req.setAttribute(DEFAULT_MODULE_NAME, Iterables.getFirst((Iterable)this.modulesController.getModuleNames(), (Object)""));
        Iterable modulesMap = Iterables.transform((Iterable)this.modulesController.getModuleNames(), (Function)new Function<String, Map<String, String>>(){

            public Map<String, String> apply(String moduleName) {
                String version = ModulesServlet.this.modulesController.getDefaultVersion(moduleName);
                ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"name", (Object)moduleName).put((Object)"state", (Object)ModulesServlet.this.modulesController.getModuleState(moduleName).toString()).put((Object)"version", (Object)version).put((Object)"hostname", (Object)ModulesServlet.this.modulesController.getHostname(moduleName, version, -1)).put((Object)"type", (Object)ModulesServlet.this.modulesController.getScalingType(moduleName));
                if (ModulesServlet.this.modulesController.getScalingType(moduleName).startsWith("Manual")) {
                    mapBuilder.put((Object)"instances", (Object)ModulesServlet.this.getAllInstanceHostnames(moduleName, version));
                }
                return mapBuilder.build();
            }
        });
        req.setAttribute(MODULES_STATE_INFO, (Object)ImmutableList.copyOf((Iterable)modulesMap));
        try {
            this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=modules").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        final String moduleName = req.getParameter("moduleName");
        final String moduleVersion = req.getParameter("moduleVersion");
        final String action = req.getParameter(ACTION_MODULE);
        if (action != null && moduleName != null && moduleVersion != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        if (action.equals("Stop")) {
                            ModulesServlet.this.modulesController.stopModule(moduleName, moduleVersion);
                        } else if (action.equals("Start")) {
                            ModulesServlet.this.modulesController.startModule(moduleName, moduleVersion);
                        }
                    }
                    catch (Exception e) {
                        String string = action;
                        String string2 = moduleName;
                        logger.severe(new StringBuilder(41 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Got error when performing a ").append(string).append(" of module : ").append(string2).toString());
                    }
                    return null;
                }
            });
        } else {
            String string = String.valueOf("The post method against the modules servlet was called without all of the expected post parameters, we got [moduleName = ");
            logger.severe(new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(moduleName).length() + String.valueOf(moduleVersion).length() + String.valueOf(action).length()).append(string).append(moduleName).append(", moduleVersion = ").append(moduleVersion).append(", and action = ").append(action).append("]").toString());
        }
        resp.sendRedirect(AH_ADMIN_MODULES_PATH);
    }
}

