/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.agent.runtime;

import com.google.appengine.tools.development.agent.AppEngineDevAgent;
import com.google.appengine.tools.development.agent.runtime.RuntimeHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import sun.reflect.Reflection;

public class Runtime {
    private static final Object agent = AppEngineDevAgent.getAgent();
    private static final Set<String> blackList = (Set)Runtime.invokeMethod(agent, "getBlackList", new Class[0], new Object[0]);

    public static ClassLoader checkParentClassLoader(ClassLoader loader) {
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        return loader != null && loader != systemLoader ? loader : Runtime.class.getClassLoader();
    }

    public static void recordClassLoader(ClassLoader loader) {
        Runtime.invokeMethod(agent, "recordAppClassLoader", new Class[]{ClassLoader.class}, new Object[]{loader});
    }

    public static void reject(String className) {
        throw new NoClassDefFoundError(new StringBuilder(93 + String.valueOf(className).length()).append(className).append(" is a restricted class. Please see the Google ").append(" App Engine developer's guide for more details.").toString());
    }

    public static void checkRestricted(boolean violationIsError, String classStr, String callingClassStr, String callingClassCodeSource) {
        if (System.getProperty("appengine.disableRestrictedCheck") == null) {
            RuntimeHelper.checkRestricted(violationIsError, classStr, callingClassStr, callingClassCodeSource);
        }
    }

    private static Object invokeMethod(Object instance, String methodName, Class<?>[] argTypes, Object[] args) {
        try {
            Method method = instance.getClass().getMethod(methodName, argTypes);
            return method.invoke(instance, args);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static boolean isBlackListed(Class<?> klass) {
        String className = klass.getName().replace('.', '/');
        return blackList.contains(className);
    }

    private static Class<?> verifyWhiteListed(Member m) throws IllegalAccessException {
        Class<?> klass = m.getDeclaringClass();
        if (!Runtime.isWhiteListed(klass, m)) {
            String string = String.valueOf(m);
            throw new IllegalAccessException(new StringBuilder(29 + String.valueOf(string).length()).append("Reflection is not allowed on ").append(string).toString());
        }
        return klass;
    }

    private static void verifyReadable(Class<?> caller, Field f, Object target) throws IllegalAccessException {
        Runtime.checkAccess(f, target, caller);
        Runtime.verifyWhiteListed(f);
    }

    private static void verifyWritable(Class<?> caller, Field f, Object target) throws IllegalAccessException {
        Runtime.checkAccess(f, target, caller);
        Class<?> klass = Runtime.verifyWhiteListed(f);
        if (Runtime.getClassLoaderPrivileged(klass) == null && !Modifier.isPublic(f.getModifiers())) {
            throw new IllegalAccessException("Private fields can not be set on JRE classes.");
        }
    }

    private static ClassLoader getClassLoaderPrivileged(final Class<?> klass) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return klass.getClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Method method, Object target, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Runtime.checkAccess(method, target, Runtime.getImmediateCallerClassPrivileged());
        Runtime.verifyWhiteListed(method);
        AccessibilityModifier am = new AccessibilityModifier(method);
        try {
            Object object = method.invoke(target, args);
            return object;
        }
        finally {
            am.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object newInstance_(Class<?> callerClass, Constructor<?> cons, Object[] args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Runtime.checkAccess(cons, null, callerClass);
        Runtime.verifyWhiteListed(cons);
        AccessibilityModifier am = new AccessibilityModifier(cons);
        try {
            Object obj = cons.newInstance(args);
            return obj;
        }
        finally {
            am.restore();
        }
    }

    public static Object newInstance(Constructor<?> cons, Object[] args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        return Runtime.newInstance_(Runtime.getImmediateCallerClassPrivileged(), cons, args);
    }

    public static Object newInstance(final Class<?> klass) throws InstantiationException, IllegalAccessException {
        try {
            Constructor cons = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws NoSuchMethodException {
                    return klass.getDeclaredConstructor(new Class[0]);
                }
            });
            return Runtime.newInstance_(Runtime.getImmediateCallerClassPrivileged(), cons, new Object[0]);
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof NoSuchMethodException) {
                throw new InstantiationException(t.getMessage());
            }
            throw new RuntimeException(t);
        }
        catch (InvocationTargetException e) {
            Runtime.throwAsUnchecked(e.getCause());
            throw new InstantiationException(e.getCause().getMessage());
        }
    }

    public static Object get(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                return f.get(target);
            }
        });
    }

    public static boolean getBoolean(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Boolean>(){

            @Override
            public Boolean run(Field f, Object target) throws IllegalAccessException {
                return f.getBoolean(target);
            }
        });
    }

    public static byte getByte(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Byte>(){

            @Override
            public Byte run(Field f, Object target) throws IllegalAccessException {
                return f.getByte(target);
            }
        });
    }

    public static char getChar(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Character>(){

            @Override
            public Character run(Field f, Object target) throws IllegalAccessException {
                return Character.valueOf(f.getChar(target));
            }
        }).charValue();
    }

    public static double getDouble(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Double>(){

            @Override
            public Double run(Field f, Object target) throws IllegalAccessException {
                return f.getDouble(target);
            }
        });
    }

    public static float getFloat(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Float>(){

            @Override
            public Float run(Field f, Object target) throws IllegalAccessException {
                return Float.valueOf(f.getFloat(target));
            }
        }).floatValue();
    }

    public static int getInt(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Integer>(){

            @Override
            public Integer run(Field f, Object target) throws IllegalAccessException {
                return f.getInt(target);
            }
        });
    }

    public static long getLong(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Long>(){

            @Override
            public Long run(Field f, Object target) throws IllegalAccessException {
                return f.getLong(target);
            }
        });
    }

    public static short getShort(Field f, Object obj) throws IllegalAccessException, IllegalArgumentException {
        return Runtime.verifyAndRun(f, obj, Op.Get, new Action<Short>(){

            @Override
            public Short run(Field f, Object target) throws IllegalAccessException {
                return f.getShort(target);
            }
        });
    }

    public static void set(Field f, Object obj, final Object value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.set(target, value);
                return null;
            }
        });
    }

    public static void setBoolean(Field f, Object obj, final boolean value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setBoolean(target, value);
                return null;
            }
        });
    }

    public static void setByte(Field f, Object obj, final byte value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setByte(target, value);
                return null;
            }
        });
    }

    public static void setChar(Field f, Object obj, final char value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setChar(target, value);
                return null;
            }
        });
    }

    public static void setDouble(Field f, Object obj, final double value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setDouble(target, value);
                return null;
            }
        });
    }

    public static void setFloat(Field f, Object obj, final float value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setFloat(target, value);
                return null;
            }
        });
    }

    public static void setInt(Field f, Object obj, final int value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setInt(target, value);
                return null;
            }
        });
    }

    public static void setLong(Field f, Object obj, final long value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setLong(target, value);
                return null;
            }
        });
    }

    public static void setShort(Field f, Object obj, final short value) throws IllegalAccessException, IllegalArgumentException {
        Runtime.verifyAndRun(f, obj, Op.Set, new Action<Object>(){

            @Override
            public Object run(Field f, Object target) throws IllegalAccessException {
                f.setShort(target, value);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T verifyAndRun(Field f, Object target, Op op, Action<T> action) throws IllegalAccessException {
        Class<?> userCaller = Runtime.getCallerClassPrivileged(3);
        if (op == Op.Get) {
            Runtime.verifyReadable(userCaller, f, target);
        } else {
            Runtime.verifyWritable(userCaller, f, target);
        }
        AccessibilityModifier am = new AccessibilityModifier(f);
        try {
            T t = action.run(f, target);
            return t;
        }
        finally {
            am.restore();
        }
    }

    private static boolean isWhiteListed(Class<?> klass, Member member) {
        Class<?>[] interfaces;
        if (klass == null) {
            return false;
        }
        if (Runtime.isWhiteListed_(klass, member)) {
            return true;
        }
        if (member instanceof Constructor) {
            return false;
        }
        for (Class<?> i : interfaces = klass.getInterfaces()) {
            if (!Runtime.isWhiteListed(i, member)) continue;
            return true;
        }
        Class<?> parentClass = klass.getSuperclass();
        return Runtime.isWhiteListed(parentClass, member);
    }

    private static boolean isWhiteListed_(Class<?> klass, Member member) {
        if (Runtime.isBlackListed(klass)) {
            return false;
        }
        if (klass == member.getDeclaringClass()) {
            return true;
        }
        return Runtime.hasMember(klass, member);
    }

    private static boolean hasMember(Class<?> klass, Member member) {
        if (member instanceof Method) {
            Method m = (Method)member;
            try {
                klass.getDeclaredMethod(m.getName(), m.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        if (member instanceof Constructor) {
            Constructor constructor = (Constructor)member;
            try {
                klass.getDeclaredConstructor(constructor.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        Field field = (Field)member;
        try {
            klass.getDeclaredField(field.getName());
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private static Class<?> getImmediateCallerClassPrivileged() {
        return Runtime.getCallerClassPrivileged(3);
    }

    private static Class<?> getCallerClassPrivileged(final int depth) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                return Reflection.getCallerClass((int)(depth + 4));
            }
        });
    }

    private static <T extends AccessibleObject> void checkAccess(T m, Object target, Class<?> caller) throws IllegalAccessException {
        if (m.isAccessible()) {
            return;
        }
        Runtime.checkAccess(caller, ((Member)((Object)m)).getDeclaringClass(), target, ((Member)((Object)m)).getModifiers());
    }

    private static void checkAccess(final Class<?> caller, final Class<?> member, final Object target, final int modifiers) throws IllegalAccessException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalAccessException {
                    Reflection.ensureMemberAccess((Class)caller, (Class)member, (Object)target, (int)modifiers);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IllegalAccessException) {
                throw (IllegalAccessException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static void throwAsUnchecked(Throwable t) {
        Runtime.throwException_(t);
    }

    private static <T extends Throwable> void throwException_(Throwable t) throws T {
        throw t;
    }

    static class AccessibilityModifier {
        private final AccessibleObject obj;
        private final boolean originalAccessibility;

        AccessibilityModifier(AccessibleObject obj) {
            this.obj = obj;
            this.originalAccessibility = obj.isAccessible();
            this.setAccessible_(true);
        }

        public void restore() {
            this.setAccessible_(this.originalAccessibility);
        }

        private void setAccessible_(final boolean flag) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AccessibilityModifier.this.obj.setAccessible(flag);
                    return null;
                }
            });
        }
    }

    private static interface Action<T> {
        public T run(Field var1, Object var2) throws IllegalAccessException;
    }

    static enum Op {
        Get,
        Set;

    }
}

