/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.BackendProperties;
import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.Named;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.server.spi.response.ServiceUnavailableException;
import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BackendService {
    private static final Logger logger = Logger.getLogger(BackendService.class.getName());
    private static final Logger frameworkLogger = Logger.getLogger("com.google.api.server.spi");
    @VisibleForTesting
    static final String CONFIG_RELOAD_SCOPE = "https://www.googleapis.com/auth/endpoints.config.reload";
    private final String minorVersion;
    private final SystemService systemService;
    private final BackendProperties backendProperties;
    private static final Map<String, Level> levelMap = new HashMap<String, Level>(){
        {
            this.put("info", Level.INFO);
            this.put("warning", Level.WARNING);
            this.put("error", Level.SEVERE);
        }
    };
    private static final Map<Level, ApiProxy.LogRecord.Level> internalLevels = new HashMap<Level, ApiProxy.LogRecord.Level>(){
        {
            this.put(Level.INFO, ApiProxy.LogRecord.Level.info);
            this.put(Level.WARNING, ApiProxy.LogRecord.Level.warn);
            this.put(Level.SEVERE, ApiProxy.LogRecord.Level.error);
        }
    };

    public BackendService(SystemService systemService) {
        this(BackendService.getMinorVersion(), systemService, new BackendProperties());
    }

    public BackendService(String minorVersion, SystemService systemService, BackendProperties backendProperties) {
        this.minorVersion = minorVersion;
        this.systemService = systemService;
        this.backendProperties = backendProperties;
    }

    private static String getMajorVersion() {
        if (!EnvUtil.isRunningOnAppEngine()) {
            return null;
        }
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        return env == null ? null : env.getVersionId().split("\\.")[0];
    }

    private static String getMinorVersion() {
        if (!EnvUtil.isRunningOnAppEngine()) {
            return null;
        }
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        return env == null ? null : env.getVersionId().split("\\.")[1];
    }

    public Collection<String> getApiConfigs(@Named(value="appRevision") String expectedAppRevision) throws InternalServerErrorException, BadRequestException {
        if (this.minorVersion != null && expectedAppRevision != null && !this.minorVersion.equals(expectedAppRevision)) {
            String string = this.minorVersion;
            throw new BadRequestException(new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(expectedAppRevision).length()).append("API backend's app revision '").append(string).append("' not the same as expected '").append(expectedAppRevision).append("'").toString());
        }
        try {
            return this.systemService.getApiConfigs().values();
        }
        catch (ApiConfigException e) {
            logger.log(Level.SEVERE, "Could not generate configuration.", e);
            throw new InternalServerErrorException(e);
        }
    }

    public static void reloadApiConfigs() throws ServiceUnavailableException, NotFoundException {
        if (!EnvUtil.isRunningOnAppEngine()) {
            throw new NotFoundException("reload only available on App Engine");
        }
        BackendService.reloadApiConfigs(BackendService.getHostnameWithMajorVersion(BackendService.getMajorVersion()), BackendService.getMinorVersion(), URLFetchServiceFactory.getURLFetchService());
    }

    @VisibleForTesting
    static void reloadApiConfigs(String hostname, String minorVersion, URLFetchService fetcher) throws ServiceUnavailableException {
        if (hostname == null) {
            throw new ServiceUnavailableException("invalid hostname");
        }
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(CONFIG_RELOAD_SCOPE);
        AppIdentityService appIdentity = AppIdentityServiceFactory.getAppIdentityService();
        AppIdentityService.GetAccessTokenResult accessToken = appIdentity.getAccessToken(scopes);
        try {
            String string = BackendService.makeReloadQueryParameters(minorVersion);
            String reloadUrl = new StringBuilder(41 + String.valueOf(hostname).length() + String.valueOf(string).length()).append("https://").append(hostname).append("/_ah/api/discovery/v1/apis/reload").append(string).toString();
            URL url = new URL(reloadUrl);
            HTTPRequest reloadRequest = new HTTPRequest(url, HTTPMethod.POST);
            reloadRequest.addHeader(new HTTPHeader("Content-Type", "application/json"));
            String string2 = String.valueOf(accessToken.getAccessToken());
            reloadRequest.addHeader(new HTTPHeader("Authorization", string2.length() != 0 ? "OAuth ".concat(string2) : new String("OAuth ")));
            HTTPResponse reloadResponse = fetcher.fetch(reloadRequest);
            if (reloadResponse.getResponseCode() != 200) {
                int n = reloadResponse.getResponseCode();
                throw new ServiceUnavailableException(new StringBuilder(33).append("Request returned HTTP ").append(n).toString());
            }
        }
        catch (IOException e) {
            throw new ServiceUnavailableException(e);
        }
    }

    private static String getHostnameWithMajorVersion(String majorVersion) {
        return BackendService.getHostnameWithMajorVersion(BackendService.getDefaultHostname(), majorVersion);
    }

    static String getHostnameWithMajorVersion(String defaultHostname, String majorVersion) {
        String hostnamePrefix = majorVersion != null ? String.valueOf(majorVersion).concat("-dot-") : "";
        String string = String.valueOf(hostnamePrefix);
        String string2 = String.valueOf(defaultHostname);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private static String getDefaultHostname() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        return env != null ? (String)env.getAttributes().get("com.google.appengine.runtime.default_version_hostname") : null;
    }

    private static String makeReloadQueryParameters(String minorVersion) {
        if (minorVersion != null) {
            String string = String.valueOf(minorVersion);
            return string.length() != 0 ? "?appMinorVersion=".concat(string) : new String("?appMinorVersion=");
        }
        return "";
    }

    public void logMessages(@Named(value="messages") MessageEntry[] messages) {
        for (MessageEntry entry : messages) {
            Level level = levelMap.get(entry.getLevel());
            this.log(level == null ? Level.INFO : level, entry.getMessage());
        }
    }

    public Properties getProperties() {
        return new Properties(this.backendProperties.getProjectNumber(), this.backendProperties.getProjectId());
    }

    @VisibleForTesting
    void log(Level level, String message) {
        if (EnvUtil.isRunningOnAppEngine()) {
            this.logWithAppEngine(level, message);
        } else {
            this.logLocal(level, message);
        }
    }

    private void logWithAppEngine(Level level, String message) {
        ApiProxy.LogRecord.Level internalLevel = internalLevels.get(level);
        ApiProxy.LogRecord record = new ApiProxy.LogRecord(internalLevel == null ? ApiProxy.LogRecord.Level.info : internalLevel, System.currentTimeMillis() * 1000L, message);
        ApiProxy.log((ApiProxy.LogRecord)record);
    }

    private void logLocal(Level level, String message) {
        frameworkLogger.logp(level, null, null, message);
    }

    public static class Properties {
        private long projectNumber;
        private String projectId;

        public Properties(long projectNumber, String projectId) {
            this.projectNumber = projectNumber;
            this.projectId = projectId;
        }

        public long getProjectNumber() {
            return this.projectNumber;
        }

        public String getProjectId() {
            return this.projectId;
        }
    }

    @VisibleForTesting
    static class MessageEntry {
        private String level;
        private String message;

        MessageEntry() {
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

