/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalConnection;
import com.google.appengine.api.rdbms.dev.ResultSets;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalMetadata {
    private static final Logger logger = Logger.getLogger(LocalMetadata.class.getCanonicalName());
    static final Map<Client.MetadataType, Method> METADATA_TYPE_METHOD_MAP = LocalMetadata.createMetadataTypeMethodMap();
    private static final Map<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime> ROW_ID_LIFETIME_MAP = LocalMetadata.createRowIdLifetimeMap();
    private static final Set<Client.MetadataType> UNIMPLEMENTED_METADATA_TYPES = com.google.cloud.sql.jdbc.internal.Util.newHashSet((Comparable[])new Client.MetadataType[]{Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_BEST_ROW_IDENTIFIER, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMN_PRIVILEGES, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLE_PRIVILEGES});

    private static Map<Client.MetadataType, Method> createMetadataTypeMethodMap() {
        HashMap<Client.MetadataType, Method> map = new HashMap<Client.MetadataType, Method>();
        try {
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_ATTRIBUTES, DatabaseMetaData.class.getMethod("getAttributes", String.class, String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_BEST_ROW_IDENTIFIER, DatabaseMetaData.class.getMethod("getBestRowIdentifier", String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMN_PRIVILEGES, DatabaseMetaData.class.getMethod("getColumnPrivileges", String.class, String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMNS, DatabaseMetaData.class.getMethod("getColumns", String.class, String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_CROSS_REFERENCE, DatabaseMetaData.class.getMethod("getCrossReference", String.class, String.class, String.class, String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_EXPORTED_KEYS, DatabaseMetaData.class.getMethod("getExportedKeys", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTION_COLUMNS, DatabaseMetaData.class.getMethod("getFunctionColumns", String.class, String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTIONS, DatabaseMetaData.class.getMethod("getFunctions", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_IMPORTED_KEYS, DatabaseMetaData.class.getMethod("getImportedKeys", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_INDEX_INFO, DatabaseMetaData.class.getMethod("getIndexInfo", String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PRIMARY_KEYS, DatabaseMetaData.class.getMethod("getPrimaryKeys", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURE_COLUMNS, DatabaseMetaData.class.getMethod("getProcedureColumns", String.class, String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURES, DatabaseMetaData.class.getMethod("getProcedures", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TABLES, DatabaseMetaData.class.getMethod("getSuperTables", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TYPES, DatabaseMetaData.class.getMethod("getSuperTypes", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLE_PRIVILEGES, DatabaseMetaData.class.getMethod("getTablePrivileges", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SCHEMAS, DatabaseMetaData.class.getMethod("getSchemas", new Class[0]));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TYPE_INFO, DatabaseMetaData.class.getMethod("getTypeInfo", new Class[0]));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_VERSION_COLUMNS, DatabaseMetaData.class.getMethod("getVersionColumns", String.class, String.class, String.class));
            map.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_UDTS, DatabaseMetaData.class.getMethod("getUDTs", String.class, String.class, String.class, int[].class));
            return Collections.unmodifiableMap(map);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "Could not initialize method map", e);
            throw new RuntimeException(e);
        }
    }

    private static Map<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime> createRowIdLifetimeMap() {
        HashMap<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime> map = new HashMap<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime>();
        for (Client.JdbcDatabaseMetaDataProto.RowIdLifetime val : Client.JdbcDatabaseMetaDataProto.RowIdLifetime.values()) {
            map.put(com.google.cloud.sql.jdbc.DatabaseMetaData.toRowIdLifetime((Client.JdbcDatabaseMetaDataProto.RowIdLifetime)val), val);
        }
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MetadataResponse getMetadata(LocalRpcService.Status status, MetadataRequest request, LocalConnection conn) {
        MetadataResponse.Builder responseBuilder = MetadataResponse.newBuilder();
        Client.ResultProto.Builder resultProtoBuilder = Client.ResultProto.newBuilder();
        ResultSet rs = null;
        SQLException sqlException = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (UNIMPLEMENTED_METADATA_TYPES.contains(request.getMetadata())) {
                sqlException = Exceptions.newNotYetImplementedException();
            } else if (request.getMetadata() == Client.MetadataType.METADATATYPE_DATABASE_METADATA_BASIC) {
                Client.JdbcDatabaseMetaDataProto metaDataProto = this.databaseMetaDataToMetaDataProto(dmd);
                responseBuilder.setJdbcDatabaseMetadata(metaDataProto);
            } else if (request.getMetadata() == Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLES) {
                String typesList;
                String catalog = Util.bindVariableToObject(request.getBindVariable(0), String.class);
                String schemaPattern = Util.bindVariableToObject(request.getBindVariable(1), String.class);
                String tablePattern = Util.bindVariableToObject(request.getBindVariable(2), String.class);
                String[] types = null;
                if (request.getBindVariableCount() >= 4 && (typesList = Util.bindVariableToObject(request.getBindVariable(3), String.class)) != null) {
                    types = typesList.split(",");
                }
                rs = dmd.getTables(catalog, schemaPattern, tablePattern, types);
            } else {
                Method m = METADATA_TYPE_METHOD_MAP.get(request.getMetadata());
                if (m == null) {
                    String string = String.valueOf(request.getMetadata());
                    throw new UnsupportedOperationException(new StringBuilder(27 + String.valueOf(string).length()).append("Unknown metadata operation ").append(string).toString());
                }
                rs = LocalMetadata.invoke(dmd, request, m);
            }
            if (rs != null) {
                ResultSets.populateResultFromResultSet(resultProtoBuilder, null, rs, -1);
            }
        }
        catch (SQLException e) {
            sqlException = e;
        }
        finally {
            SQLException closeException = Util.close(rs);
            if (sqlException == null) {
                sqlException = closeException;
            }
        }
        if (sqlException != null) {
            logger.log(Level.SEVERE, "Could not get Metadata", sqlException);
            responseBuilder.setSqlException(Util.toClientSqlException(sqlException));
        }
        if (resultProtoBuilder.hasRows() || resultProtoBuilder.hasSqlException()) {
            responseBuilder.setResult(resultProtoBuilder);
        }
        return responseBuilder.build();
    }

    private Client.JdbcDatabaseMetaDataProto databaseMetaDataToMetaDataProto(DatabaseMetaData dmd) throws SQLException {
        boolean hasJava6MethodImpls = LocalMetadata.hasJava6MethodImpls(dmd);
        Client.JdbcDatabaseMetaDataProto.Builder builder = Client.JdbcDatabaseMetaDataProto.newBuilder();
        builder.setAllProceduresAreCallable(dmd.allProceduresAreCallable());
        builder.setAllTablesAreSelectable(dmd.allTablesAreSelectable());
        if (hasJava6MethodImpls) {
            builder.setAutoCommitFailureClosesAllResultSets(dmd.autoCommitFailureClosesAllResultSets());
        }
        builder.setCatalogAtStart(dmd.isCatalogAtStart());
        builder.addAllCatalogs(LocalMetadata.singleColumnResultSetToStringList(dmd.getCatalogs()));
        builder.setCatalogSeparator(dmd.getCatalogSeparator());
        builder.setCatalogTerm(dmd.getCatalogTerm());
        builder.setDatabaseMajorVersion(dmd.getDatabaseMajorVersion());
        builder.setDatabaseMinorVersion(dmd.getDatabaseMinorVersion());
        String string = String.valueOf(dmd.getDatabaseProductName());
        builder.setDatabaseProductName(string.length() != 0 ? "Google SQL Service/".concat(string) : new String("Google SQL Service/"));
        builder.setDatabaseProductVersion(dmd.getDatabaseProductVersion());
        builder.setDataDefinitionCausesTransactionCommit(dmd.dataDefinitionCausesTransactionCommit());
        builder.setDataDefinitionIgnoredInTransactions(dmd.dataDefinitionIgnoredInTransactions());
        builder.setDefaultTransactionIsolation(Client.TransactionIsolationLevel.valueOf((int)dmd.getDefaultTransactionIsolation()));
        builder.setDoesMaxRowSizeIncludeBlobs(dmd.doesMaxRowSizeIncludeBlobs());
        builder.setExtraNameCharacters(dmd.getExtraNameCharacters());
        builder.setIdentifierQuoteString(dmd.getIdentifierQuoteString());
        builder.setJdbcMajorVersion(dmd.getJDBCMajorVersion());
        builder.setJdbcMinorVersion(dmd.getJDBCMinorVersion());
        builder.setLocatorsUpdateCopy(dmd.locatorsUpdateCopy());
        builder.setMaxBinaryLiteralLength(dmd.getMaxBinaryLiteralLength());
        builder.setMaxCatalogNameLength(dmd.getMaxCatalogNameLength());
        builder.setMaxCharLiteralLength(dmd.getMaxCharLiteralLength());
        builder.setMaxColumnNameLength(dmd.getMaxColumnNameLength());
        builder.setMaxColumnsInGroupBy(dmd.getMaxColumnsInGroupBy());
        builder.setMaxColumnsInIndex(dmd.getMaxColumnsInIndex());
        builder.setMaxColumnsInOrderBy(dmd.getMaxColumnsInOrderBy());
        builder.setMaxColumnsInSelect(dmd.getMaxColumnsInSelect());
        builder.setMaxColumnsInTable(dmd.getMaxColumnsInTable());
        builder.setMaxConnections(dmd.getMaxConnections());
        builder.setMaxCursorNameLength(dmd.getMaxCursorNameLength());
        builder.setMaxIndexLength(dmd.getMaxIndexLength());
        builder.setMaxProcedureNameLength(dmd.getMaxProcedureNameLength());
        builder.setMaxRowSize(dmd.getMaxRowSize());
        builder.setMaxSchemaNameLength(dmd.getMaxSchemaNameLength());
        builder.setMaxStatementLength(dmd.getMaxStatementLength());
        builder.setMaxStatements(dmd.getMaxStatements());
        builder.setMaxTableNameLength(dmd.getMaxTableNameLength());
        builder.setMaxTablesInSelect(dmd.getMaxTablesInSelect());
        builder.setMaxUserNameLength(dmd.getMaxUserNameLength());
        builder.setNullPlusNonNullIsNull(dmd.nullPlusNonNullIsNull());
        builder.setNullsAreSortedAtEnd(dmd.nullsAreSortedAtEnd());
        builder.setNullsAreSortedAtStart(dmd.nullsAreSortedAtStart());
        builder.setNullsAreSortedHigh(dmd.nullsAreSortedHigh());
        builder.setNullsAreSortedLow(dmd.nullsAreSortedLow());
        builder.setNumericFunctions(dmd.getNumericFunctions());
        builder.setProcedureTerm(dmd.getProcedureTerm());
        builder.setReadOnly(dmd.isReadOnly());
        builder.setResultsetHoldability(Client.ResultSetHoldability.valueOf((int)dmd.getResultSetHoldability()));
        if (hasJava6MethodImpls) {
            builder.setRowidLifetime(ROW_ID_LIFETIME_MAP.get((Object)dmd.getRowIdLifetime()));
        }
        builder.setSchemaTerm(dmd.getSchemaTerm());
        builder.setSearchStringEscape(dmd.getSearchStringEscape());
        builder.setSqlKeywords(dmd.getSQLKeywords());
        Client.JdbcDatabaseMetaDataProto.SqlStateType sqlStateType = LocalMetadata.sqlStateTypeToProtoVal(dmd.getSQLStateType());
        builder.setSqlStateType(sqlStateType);
        builder.setStoresLowerCaseIdentifiers(dmd.storesLowerCaseIdentifiers());
        builder.setStoresLowerCaseQuotedIdentifiers(dmd.storesLowerCaseQuotedIdentifiers());
        builder.setStoresMixedCaseIdentifiers(dmd.storesMixedCaseIdentifiers());
        builder.setStoresMixedCaseQuotedIdentifiers(dmd.storesMixedCaseQuotedIdentifiers());
        builder.setStoresUpperCaseIdentifiers(dmd.storesUpperCaseIdentifiers());
        builder.setStoresUpperCaseQuotedIdentifiers(dmd.storesUpperCaseQuotedIdentifiers());
        builder.setStringFunctions(dmd.getStringFunctions());
        builder.setSupportsAlterTableWithAddColumn(dmd.supportsAlterTableWithAddColumn());
        builder.setSupportsAlterTableWithDropColumn(dmd.supportsAlterTableWithDropColumn());
        builder.setSupportsAnsi92EntryLevelSql(dmd.supportsANSI92EntryLevelSQL());
        builder.setSupportsAnsi92FullSql(dmd.supportsANSI92FullSQL());
        builder.setSupportsAnsi92IntermediateSql(dmd.supportsANSI92IntermediateSQL());
        builder.setSupportsBatchUpdates(dmd.supportsBatchUpdates());
        builder.setSupportsCatalogsInDataManipulation(dmd.supportsCatalogsInDataManipulation());
        builder.setSupportsCatalogsInIndexDefinitions(dmd.supportsCatalogsInIndexDefinitions());
        builder.setSupportsCatalogsInPrivilegeDefinitions(dmd.supportsCatalogsInPrivilegeDefinitions());
        builder.setSupportsCatalogsInProcedureCalls(dmd.supportsCatalogsInProcedureCalls());
        builder.setSupportsCatalogsInTableDefinitions(dmd.supportsCatalogsInTableDefinitions());
        builder.setSupportsColumnAliasing(dmd.supportsColumnAliasing());
        builder.setSupportsConvert(dmd.supportsConvert());
        builder.setSupportsCoreSqlGrammar(dmd.supportsCoreSQLGrammar());
        builder.setSupportsCorrelatedSubqueries(dmd.supportsCorrelatedSubqueries());
        builder.setSupportsDataDefinitionAndDataManipulationTransactions(dmd.supportsDataDefinitionAndDataManipulationTransactions());
        builder.setSupportsDataManipulationTransactionsOnly(dmd.supportsDataManipulationTransactionsOnly());
        builder.setSupportsDifferentTableCorrelationNames(dmd.supportsDifferentTableCorrelationNames());
        builder.setSupportsExpressionsInOrderBy(dmd.supportsExpressionsInOrderBy());
        builder.setSupportsExtendedSqlGrammar(dmd.supportsExtendedSQLGrammar());
        builder.setSupportsFullOuterJoins(dmd.supportsFullOuterJoins());
        builder.setSupportsGetGeneratedKeys(dmd.supportsGetGeneratedKeys());
        builder.setSupportsGroupBy(dmd.supportsGroupBy());
        builder.setSupportsGroupByBeyondSelect(dmd.supportsGroupByBeyondSelect());
        builder.setSupportsGroupByUnrelated(dmd.supportsGroupByUnrelated());
        builder.setSupportsIntegrityEnhancementFacility(dmd.supportsIntegrityEnhancementFacility());
        builder.setSupportsLikeEscapeClause(dmd.supportsLikeEscapeClause());
        builder.setSupportsLimitedOuterJoins(dmd.supportsLimitedOuterJoins());
        builder.setSupportsMinimumSqlGrammar(dmd.supportsMinimumSQLGrammar());
        builder.setSupportsMixedCaseIdentifiers(dmd.supportsMixedCaseIdentifiers());
        builder.setSupportsMixedCaseQuotedIdentifiers(dmd.supportsMixedCaseQuotedIdentifiers());
        builder.setSupportsMultipleOpenResults(dmd.supportsMultipleOpenResults());
        builder.setSupportsMultipleResultSets(dmd.supportsMultipleResultSets());
        builder.setSupportsMultipleTransactions(dmd.supportsMultipleTransactions());
        builder.setSupportsNamedParameters(dmd.supportsNamedParameters());
        builder.setSupportsNonNullableColumns(dmd.supportsNonNullableColumns());
        builder.setSupportsOpenCursorsAcrossCommit(dmd.supportsOpenCursorsAcrossCommit());
        builder.setSupportsOpenCursorsAcrossRollback(dmd.supportsOpenCursorsAcrossRollback());
        builder.setSupportsOpenStatementsAcrossCommit(dmd.supportsOpenStatementsAcrossCommit());
        builder.setSupportsOpenStatementsAcrossRollback(dmd.supportsOpenStatementsAcrossRollback());
        builder.setSupportsOrderByUnrelated(dmd.supportsOrderByUnrelated());
        builder.setSupportsOuterJoins(dmd.supportsOuterJoins());
        builder.setSupportsPositionedDelete(dmd.supportsPositionedDelete());
        builder.setSupportsPositionedUpdate(dmd.supportsPositionedUpdate());
        builder.setSupportsSavepoints(dmd.supportsSavepoints());
        builder.setSupportsSchemasInDataManipulation(dmd.supportsSchemasInDataManipulation());
        builder.setSupportsSchemasInIndexDefinitions(dmd.supportsSchemasInIndexDefinitions());
        builder.setSupportsSchemasInPrivilegeDefinitions(dmd.supportsSchemasInPrivilegeDefinitions());
        builder.setSupportsSchemasInProcedureCalls(dmd.supportsSchemasInProcedureCalls());
        builder.setSupportsSchemasInTableDefinitions(dmd.supportsSchemasInTableDefinitions());
        builder.setSupportsSelectForUpdate(dmd.supportsSelectForUpdate());
        builder.setSupportsStatementPooling(dmd.supportsStatementPooling());
        if (hasJava6MethodImpls) {
            builder.setSupportsStoredFunctionsUsingCallSyntax(dmd.supportsStoredFunctionsUsingCallSyntax());
        }
        builder.setSupportsStoredProcedures(dmd.supportsStoredProcedures());
        builder.setSupportsSubqueriesInComparisons(dmd.supportsSubqueriesInComparisons());
        builder.setSupportsSubqueriesInExists(dmd.supportsSubqueriesInExists());
        builder.setSupportsSubqueriesInIns(dmd.supportsSubqueriesInIns());
        builder.setSupportsSubqueriesInQuantifieds(dmd.supportsSubqueriesInQuantifieds());
        builder.setSupportsTableCorrelationNames(dmd.supportsTableCorrelationNames());
        builder.setSupportsTransactions(dmd.supportsTransactions());
        builder.setSupportsUnion(dmd.supportsUnion());
        builder.setSupportsUnionAll(dmd.supportsUnionAll());
        builder.setSystemFunctions(dmd.getSystemFunctions());
        builder.addAllTableTypes(LocalMetadata.singleColumnResultSetToStringList(dmd.getTableTypes()));
        builder.setTimeDateFunctions(dmd.getTimeDateFunctions());
        builder.setUserName(dmd.getUserName());
        builder.setUsesLocalFilePerTable(dmd.usesLocalFilePerTable());
        builder.setUsesLocalFiles(dmd.usesLocalFiles());
        return builder.build();
    }

    private static ResultSet invoke(DatabaseMetaData dmd, MetadataRequest request, Method m) throws SQLException {
        Object[] params = new Object[request.getBindVariableCount()];
        for (int i = 0; i < request.getBindVariableCount(); ++i) {
            params[i] = Util.bindVariableToObject(request.getBindVariable(i), Object.class);
        }
        try {
            return (ResultSet)m.invoke((Object)dmd, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof SQLException) {
                throw (SQLException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException("Unexpected exception type.", targetException);
        }
    }

    private static List<String> singleColumnResultSetToStringList(ResultSet rs) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        return result;
    }

    private static boolean hasJava6MethodImpls(DatabaseMetaData dmd) {
        try {
            Class<?> clazz = dmd.getClass();
            clazz.getDeclaredMethod("autoCommitFailureClosesAllResultSets", new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static Client.JdbcDatabaseMetaDataProto.SqlStateType sqlStateTypeToProtoVal(int sqlStateType) {
        switch (sqlStateType) {
            case 2: {
                return Client.JdbcDatabaseMetaDataProto.SqlStateType.SQLSTATETYPE_SQL_STATE_SQL;
            }
            case 1: {
                return Client.JdbcDatabaseMetaDataProto.SqlStateType.SQLSTATETYPE_SQL_STATE_XOPEN;
            }
        }
        throw new IllegalArgumentException(new StringBuilder(44).append("Unknown sql state type constant: ").append(sqlStateType).toString());
    }
}

