/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp.dev;

import com.google.appengine.api.xmpp.XMPPServicePb;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import java.util.Map;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalXMPPService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "xmpp";

    public void start() {
    }

    public void stop() {
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public String getPackage() {
        return PACKAGE;
    }

    private boolean isAvailable(String jid) {
        return jid.charAt(0) < 'm';
    }

    @LatencyPercentiles(latency50th=50)
    public XMPPServicePb.PresenceResponse getPresence(LocalRpcService.Status status, XMPPServicePb.PresenceRequest request) {
        XMPPServicePb.PresenceResponse response = new XMPPServicePb.PresenceResponse();
        response.setIsAvailable(this.isAvailable(request.getJid()));
        return response;
    }

    @LatencyPercentiles(latency50th=50)
    public XMPPServicePb.BulkPresenceResponse bulkGetPresence(LocalRpcService.Status status, XMPPServicePb.BulkPresenceRequest request) {
        XMPPServicePb.BulkPresenceResponse response = new XMPPServicePb.BulkPresenceResponse();
        for (String jid : request.jids()) {
            XMPPServicePb.PresenceResponse subresponse = response.addPresenceResponse();
            subresponse.setIsAvailable(this.isAvailable(jid));
        }
        return response;
    }

    @LatencyPercentiles(latency50th=40)
    public XMPPServicePb.XmppMessageResponse sendMessage(LocalRpcService.Status status, XMPPServicePb.XmppMessageRequest request) {
        System.out.println("Sending an XMPP Message:");
        System.out.println("    Body:");
        String string = String.valueOf(request.getBody());
        System.out.println(string.length() != 0 ? "        ".concat(string) : new String("        "));
        System.out.println("    Type:");
        String string2 = String.valueOf(request.getType());
        System.out.println(string2.length() != 0 ? "        ".concat(string2) : new String("        "));
        System.out.println("    RawXml:");
        boolean bl = request.isRawXml();
        System.out.println(new StringBuilder(13).append("        ").append(bl).toString());
        if (request.hasFromJid()) {
            System.out.println("    FromJid:");
            String string3 = String.valueOf(request.getFromJid());
            System.out.println(string3.length() != 0 ? "        ".concat(string3) : new String("        "));
        }
        System.out.println("    To JIDs:");
        for (String jid : request.jids()) {
            String string4 = String.valueOf(jid);
            System.out.println(string4.length() != 0 ? "        ".concat(string4) : new String("        "));
        }
        XMPPServicePb.XmppMessageResponse response = new XMPPServicePb.XmppMessageResponse();
        for (String jid : request.jids()) {
            response.addStatus(XMPPServicePb.XmppMessageResponse.XmppMessageStatus.NO_ERROR.getValue());
        }
        return response;
    }

    public XMPPServicePb.XmppInviteResponse sendInvite(LocalRpcService.Status status, XMPPServicePb.XmppInviteRequest request) {
        System.out.println("Sending an XMPP Invitation:");
        System.out.println("    To JID:");
        String string = String.valueOf(request.getJid());
        System.out.println(string.length() != 0 ? "        ".concat(string) : new String("        "));
        XMPPServicePb.XmppInviteResponse response = new XMPPServicePb.XmppInviteResponse();
        return response;
    }

    @LatencyPercentiles(latency50th=4)
    public XMPPServicePb.XmppSendPresenceResponse sendPresence(LocalRpcService.Status status, XMPPServicePb.XmppSendPresenceRequest request) {
        System.out.println("Sending an XMPP Presence:");
        System.out.println("    To JID:");
        String string = String.valueOf(request.getJid());
        System.out.println(string.length() != 0 ? "        ".concat(string) : new String("        "));
        if (request.hasType()) {
            System.out.println("    Type:");
            String string2 = String.valueOf(request.getType());
            System.out.println(string2.length() != 0 ? "        ".concat(string2) : new String("        "));
        }
        if (request.hasShow()) {
            System.out.println("    Show:");
            String string3 = String.valueOf(request.getShow());
            System.out.println(string3.length() != 0 ? "        ".concat(string3) : new String("        "));
        }
        if (request.hasStatus()) {
            System.out.println("    Status:");
            String string4 = String.valueOf(request.getStatus());
            System.out.println(string4.length() != 0 ? "        ".concat(string4) : new String("        "));
        }
        if (request.hasFromJid()) {
            System.out.println("    From JID:");
            String string5 = String.valueOf(request.getFromJid());
            System.out.println(string5.length() != 0 ? "        ".concat(string5) : new String("        "));
        }
        XMPPServicePb.XmppSendPresenceResponse response = new XMPPServicePb.XmppSendPresenceResponse();
        return response;
    }
}

