/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.store;

import com.google.appengine.repackaged.org.apache.lucene.store.IndexInput;
import java.io.IOException;

public abstract class BufferedIndexInput
extends IndexInput {
    public static final int BUFFER_SIZE = 1024;
    private int bufferSize = 1024;
    protected byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public BufferedIndexInput() {
    }

    public BufferedIndexInput(int bufferSize) {
        this.checkBufferSize(bufferSize);
        this.bufferSize = bufferSize;
    }

    public void setBufferSize(int newSize) {
        if (!$assertionsDisabled && this.buffer != null && this.bufferSize != this.buffer.length) {
            throw new AssertionError((Object)("buffer=" + this.buffer + " bufferSize=" + this.bufferSize + " buffer.length=" + (this.buffer != null ? this.buffer.length : 0)));
        }
        if (newSize != this.bufferSize) {
            this.checkBufferSize(newSize);
            this.bufferSize = newSize;
            if (this.buffer != null) {
                byte[] newBuffer = new byte[newSize];
                int leftInBuffer = this.bufferLength - this.bufferPosition;
                int numToCopy = leftInBuffer > newSize ? newSize : leftInBuffer;
                System.arraycopy(this.buffer, this.bufferPosition, newBuffer, 0, numToCopy);
                this.bufferStart += (long)this.bufferPosition;
                this.bufferPosition = 0;
                this.bufferLength = numToCopy;
                this.newBuffer(newBuffer);
            }
        }
    }

    protected void newBuffer(byte[] newBuffer) {
        this.buffer = newBuffer;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void checkBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than 0 (got " + bufferSize + ")");
        }
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.readBytes(b, offset, len, true);
    }

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        if (len <= this.bufferLength - this.bufferPosition) {
            if (len > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
            }
            this.bufferPosition += len;
        } else {
            int available = this.bufferLength - this.bufferPosition;
            if (available > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, available);
                offset += available;
                len -= available;
                this.bufferPosition += available;
            }
            if (useBuffer && len < this.bufferSize) {
                this.refill();
                if (this.bufferLength < len) {
                    System.arraycopy(this.buffer, 0, b, offset, this.bufferLength);
                    throw new IOException("read past EOF");
                }
                System.arraycopy(this.buffer, 0, b, offset, len);
                this.bufferPosition = len;
            } else {
                long after = this.bufferStart + (long)this.bufferPosition + (long)len;
                if (after > this.length()) {
                    throw new IOException("read past EOF");
                }
                this.readInternal(b, offset, len);
                this.bufferStart = after;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    private void refill() throws IOException {
        int newLength;
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        if ((newLength = (int)(end - start)) <= 0) {
            throw new IOException("read past EOF");
        }
        if (this.buffer == null) {
            this.newBuffer(new byte[this.bufferSize]);
            this.seekInternal(this.bufferStart);
        }
        this.readInternal(this.buffer, 0, newLength);
        this.bufferLength = newLength;
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    public long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    public Object clone() {
        BufferedIndexInput clone = (BufferedIndexInput)super.clone();
        clone.buffer = null;
        clone.bufferLength = 0;
        clone.bufferPosition = 0;
        clone.bufferStart = this.getFilePointer();
        return clone;
    }

    static {
        $assertionsDisabled = !BufferedIndexInput.class.desiredAssertionStatus();
    }
}

