/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.datastore.v1.AllocateIdsRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.BeginTransactionRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.CommitRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.KeyOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.LookupRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.Mutation;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RollbackRequestOrBuilder;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.apphosting.datastore.shared.CloudDatastoreV1Validator;
import com.google.apphosting.datastore.shared.DatabaseName;
import com.google.apphosting.datastore.shared.DatabaseNameV1Validator;
import com.google.apphosting.datastore.shared.Paths;
import com.google.apphosting.datastore.shared.ValidationConstraint;
import com.google.apphosting.datastore.shared.ValidationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;

public class CloudDatastoreV1ServiceValidator {
    private final CloudDatastoreV1Validator validatorV1;
    private static final ValidationConstraint LOOKUP_CONSTRAINT = ValidationConstraint.LOOKUP.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint ALLOCATE_ID_CONSTRAINT = ValidationConstraint.ALLOCATE_ID.withContext(ValidationConstraint.Context.PRENORMALIZATION);
    private static final ValidationConstraint QUERY_CONSTRAINT = ValidationConstraint.QUERY.withContext(ValidationConstraint.Context.PRENORMALIZATION);

    public CloudDatastoreV1ServiceValidator(CloudDatastoreV1Validator validatorV1) {
        this.validatorV1 = validatorV1;
    }

    public CloudDatastoreV1Validator getDatastoreV1Validator() {
        return this.validatorV1;
    }

    public void validateCommitRequest(boolean isTrusted, CommitRequestOrBuilder req) throws ValidationException {
        block5: {
            block4: {
                DatabaseName dbName = DatabaseNameV1Validator.INSTANCE.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
                ValidationException.validateAssertion(req.getTransactionSelectorCase() != CommitRequest.TransactionSelectorCase.SINGLE_USE_TRANSACTION || this.validatorV1.getEntityValidator().getConfig().getAllowSingleUseTransaction(), "setting single_use_transaction is not allowed.", new Object[0]);
                boolean hasTransaction = req.getTransactionSelectorCase() != CommitRequest.TransactionSelectorCase.TRANSACTIONSELECTOR_NOT_SET;
                this.validatorV1.validateCommitMode(req.getMode(), hasTransaction);
                for (Mutation mutation : req.getMutationsList()) {
                    ValidationConstraint constraint = CloudDatastoreV1Validator.constraintForMutation(mutation).withContext(isTrusted, ValidationConstraint.Context.PRENORMALIZATION);
                    this.validatorV1.validateMutation(constraint, dbName, mutation);
                }
                if (hasTransaction) break block4;
                HashSet completeKeysSeen = Sets.newHashSetWithExpectedSize((int)req.getMutationsCount());
                for (Mutation mutation : req.getMutationsList()) {
                    Key key = CloudDatastoreV1ServiceValidator.getKey(mutation);
                    if (Paths.hasIncompleteLastElement((KeyOrBuilder)key)) continue;
                    ValidationException.validateAssertion(completeKeysSeen.add(key), "A non-transactional commit may not contain multiple mutations affecting the same entity.", new Object[0]);
                }
                break block5;
            }
            if (!this.validatorV1.getEntityValidator().getConfig().getAllowMutationBaseVersion()) break block5;
            HashMap<Key, Long> seenBaseVersions = new HashMap<Key, Long>();
            for (Mutation mutation : req.getMutationsList()) {
                Long baseVersion;
                Key key = CloudDatastoreV1ServiceValidator.getKey(mutation);
                Long l = baseVersion = mutation.getConflictDetectionStrategyCase() == Mutation.ConflictDetectionStrategyCase.BASE_VERSION ? Long.valueOf(mutation.getBaseVersion()) : null;
                if (seenBaseVersions.containsKey(key)) {
                    ValidationException.validateAssertion(Objects.equals(seenBaseVersions.get(key), baseVersion), "Mutations for the same entity must have the same base version.", new Object[0]);
                    continue;
                }
                seenBaseVersions.put(key, baseVersion);
            }
        }
    }

    private static Key getKey(Mutation mutation) throws ValidationException {
        switch (mutation.getOperationCase()) {
            case INSERT: {
                return mutation.getInsert().getKey();
            }
            case UPDATE: {
                return mutation.getUpdate().getKey();
            }
            case UPSERT: {
                return mutation.getUpsert().getKey();
            }
            case DELETE: {
                return mutation.getDelete();
            }
        }
        throw new ValidationException("Mutation is missing operation.");
    }

    public void validateLookupRequest(LookupRequestOrBuilder req) throws ValidationException {
        DatabaseName databaseName = DatabaseNameV1Validator.INSTANCE.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        this.validatorV1.getEntityValidator().validateKeys(LOOKUP_CONSTRAINT, databaseName, req.getKeysList());
        this.validatorV1.validateReadOptions(req.getReadOptions());
    }

    public void validateAllocateIdsRequest(AllocateIdsRequestOrBuilder req) throws ValidationException {
        DatabaseName databaseName = DatabaseNameV1Validator.INSTANCE.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        this.validatorV1.getEntityValidator().validateKeys(ALLOCATE_ID_CONSTRAINT, databaseName, req.getKeysList());
    }

    public void validateRunQueryRequest(RunQueryRequest req) throws ValidationException {
        DatabaseName databaseName = DatabaseNameV1Validator.INSTANCE.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        DatabaseNameV1Validator.INSTANCE.validateDatabaseNameMatches(databaseName, req.getPartitionId().getProjectIdBytes(), req.getPartitionId().getDatabaseIdBytes());
        Preconditions.checkArgument((req.getQueryTypeCase() != RunQueryRequest.QueryTypeCase.GQL_QUERY ? 1 : 0) != 0, (Object)"RunQueryRequest not normalized");
        this.validatorV1.getEntityValidator().validatePartitionId(QUERY_CONSTRAINT, req.getPartitionIdOrBuilder());
        this.validatorV1.validateReadOptions(req.getReadOptions());
        ValidationException.validateAssertion(req.getQueryTypeCase() == RunQueryRequest.QueryTypeCase.QUERY, "one of fields Query.query and Query.gql_query must be set", new Object[0]);
        this.validatorV1.validateQuery(QUERY_CONSTRAINT, req.getReadOptionsOrBuilder().getReadConsistency() == ReadOptions.ReadConsistency.STRONG, (QueryOrBuilder)req.getQuery());
    }

    public void validateRollbackRequest(RollbackRequestOrBuilder req) throws ValidationException {
        DatabaseNameV1Validator.INSTANCE.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
        ValidationException.validateAssertion(!req.getTransaction().isEmpty(), "transaction required", new Object[0]);
    }

    public void validateBeginTransactionRequest(BeginTransactionRequestOrBuilder req) throws ValidationException {
        DatabaseNameV1Validator.INSTANCE.createAndValidateRequiredDatabaseName(req.getProjectIdBytes(), req.getDatabaseIdBytes());
    }
}

