/*
 * Copyright (C) 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.util.regex;

/**
 * Non-working emulation of {@code Pattern}, allowing other classes to
 * compile under GWT even if they import this class, so long as
 * none of the methods called from GWT code try to use its methods.
 *
 * @author cberry@google.com (Craig Berry)
 */
public final class Pattern {
  
  // All constants are given the (hopefully) meaningless and incorrect
  // value Integer.MIN_VALUE to help ensure that any inadvertant use
  // of this code from GWT fails early and obviously.
  
  public static final int UNIX_LINES = Integer.MIN_VALUE;

  public static final int CASE_INSENSITIVE = Integer.MIN_VALUE;

  public static final int COMMENTS = Integer.MIN_VALUE;

  public static final int MULTILINE = Integer.MIN_VALUE;

  public static final int LITERAL = Integer.MIN_VALUE;

  public static final int DOTALL = Integer.MIN_VALUE;

  public static final int UNICODE_CASE = Integer.MIN_VALUE;

  public static final int CANON_EQ = Integer.MIN_VALUE;

  public static Pattern compile(String regex) {
    throw unsupported();
  }

  public static Pattern compile(String regex, int flags) {
    throw unsupported();
  }

  public String pattern() {
    throw unsupported();
  }

  public String toString() {
    throw unsupported();
  }

  public Matcher matcher(CharSequence input) {
    throw unsupported();
  }

  public int flags() {
    throw unsupported();
  }

  public static boolean matches(String regex, CharSequence input) {
    throw unsupported();
  }

  public String[] split(CharSequence input, int limit) {
    throw unsupported();
  }

  public String[] split(CharSequence input) {
    throw unsupported();
  }

  public static String quote(String s) {
    throw unsupported();
  }

  private static UnsupportedOperationException unsupported() {
    return new UnsupportedOperationException("Not supported in GWT");
  }
}
