/**********************************************************************
Copyright (c) 2007 Erik Bengtson and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 

Contributors:
2007 Andy Jefferson - removed hardcoded dependency on db4o
    ...
**********************************************************************/
package org.datanucleus;

import java.util.HashMap;

/**
 * Registry for connection factories for this ObjectManagerFactory.
 * Will typically have entries for things like "jdbc/nontx", "jdbc/tx", etc
 */
public class ConnectionFactoryRegistry
{
    /** ObjectManagerFactory context. */
    OMFContext ctx;

    /** The registry of factories. */
    HashMap<String, ConnectionFactory> factories = new HashMap<String, ConnectionFactory>();

    /**
     * Constructor.
     * @param ctx OMFContext
     */
    public ConnectionFactoryRegistry(OMFContext ctx)
    {
        this.ctx = ctx;
    }

    /**
     * Method to lookup a connection factory and create it if not yet existing.
     * @param name The lookup name "e.g "jdbc/tx"
     * @return The connection factory
     */
    public ConnectionFactory lookupConnectionFactory(String name)
    {
        return factories.get(name);
    }

    /**
     * Method to register a connection factory
     * @param name The lookup name "e.g "jdbc/tx"
     * @param factory The connection factory
     */
    public void registerConnectionFactory(String name, ConnectionFactory factory)
    {
        factories.put(name, factory);
    }    
}