/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.protobuf.Any;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageFactories;
import com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor.pool.GeneratedDescriptorPool;
import javax.annotation.Nullable;

public final class AnyUtil {
    private static final String INTERNAL_TYPE_URL = "type.googleprod.com/";
    private static final GeneratedDescriptorPool DESCRIPTOR_POOL = GeneratedDescriptorPool.getInstance();

    public static Message unpack(Any any) throws InvalidProtocolBufferException {
        Message prototype = AnyUtil.getMessagePrototype(any);
        if (prototype == null) {
            throw new InvalidProtocolBufferException("No descriptor found for type.");
        }
        return prototype.getParserForType().parseFrom(any.getValue(), (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
    }

    public static <T extends Message> T unpack(Any any, Class<T> clazz) throws InvalidProtocolBufferException {
        return (T)((Message)clazz.cast(AnyUtil.unpack(any)));
    }

    @Nullable
    public static Message getMessagePrototype(Any any) {
        try {
            return AnyUtil.getMessagePrototype(any.getTypeUrl()).orNull();
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static Optional<Message> getMessagePrototype(String typeUrl) {
        String typeName = AnyUtil.getTypeNameFromTypeUrl(typeUrl);
        Descriptors.Descriptor typeDescriptor = DESCRIPTOR_POOL.getDescriptorForTypeName(typeName);
        if (typeDescriptor == null) {
            return Optional.absent();
        }
        Message immutableMessage = MessageFactories.getImmutableMessageFactory().getPrototype(typeDescriptor);
        if (immutableMessage != null) {
            return Optional.of(immutableMessage);
        }
        return Optional.fromNullable(MessageFactories.getMutableMessageFactory().getPrototype(typeDescriptor));
    }

    public static String getTypeNameFromTypeUrl(String typeUrl) {
        int pos = typeUrl.lastIndexOf(47);
        Preconditions.checkArgument(pos != -1, "malformed type URL: %s", (Object)typeUrl);
        return typeUrl.substring(pos + 1);
    }

    public static String getInternalTypeUrlFromDescriptor(Descriptors.Descriptor descriptor) {
        return AnyUtil.getInternalTypeUrlFromTypeName(descriptor.getFullName());
    }

    public static String getInternalTypeUrlFromTypeName(String internalTypeName) {
        String string = String.valueOf(INTERNAL_TYPE_URL);
        String string2 = String.valueOf(internalTypeName);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    private AnyUtil() {
    }
}

