/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.contrib.ProtoFlavor;

public final class JavaQualifiedNames {
    private static final ImmutableMap<String, String> SPECIAL_CASES = ImmutableMap.builder().put("cached_size", "CachedSize_").put("class", "Class_").put("serialized_size", "SerializedSize_").build();

    private JavaQualifiedNames() {
    }

    public static String getPackage(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getPackage(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getOuterClassname(Descriptors.FileDescriptor fileDescriptor) {
        return JavaQualifiedNames.getFileClassName(fileDescriptor, ProtoFlavor.PROTO2);
    }

    public static String getQualifiedName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType).replace('$', '.');
    }

    public static String getClassName(Descriptors.Descriptor msg) {
        return JavaQualifiedNames.getClassName(msg, ProtoFlavor.PROTO2);
    }

    public static String getClassName(Descriptors.EnumDescriptor enumType) {
        return JavaQualifiedNames.getClassName(enumType, ProtoFlavor.PROTO2);
    }

    public static String getQualifiedName(Descriptors.Descriptor msg, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(msg, flavor).replace('$', '.');
    }

    public static String getQualifiedName(Descriptors.EnumDescriptor enumType, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(enumType, flavor).replace('$', '.');
    }

    public static String getClassName(Descriptors.Descriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor), descriptor.getFile(), flavor);
    }

    public static String getClassName(Descriptors.EnumDescriptor descriptor, ProtoFlavor flavor) {
        return JavaQualifiedNames.getClassName(JavaQualifiedNames.classNameWithoutPackage(descriptor), descriptor.getFile(), flavor);
    }

    public static String getFieldName(Descriptors.FieldDescriptor field, boolean capitializeFirstLetter) {
        String fieldName = field.getName();
        if (SPECIAL_CASES.containsKey(fieldName)) {
            String output = SPECIAL_CASES.get(fieldName);
            if (capitializeFirstLetter) {
                return output;
            }
            char c = (char)(output.charAt(0) + 32);
            String string = output.substring(1);
            return new StringBuilder(1 + String.valueOf(string).length()).append(c).append(string).toString();
        }
        return JavaQualifiedNames.underscoresToCamelCase(fieldName, capitializeFirstLetter);
    }

    public static String underscoresToCamelCase(String input, boolean capitializeNextLetter) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                if (capitializeNextLetter) {
                    result.append((char)(ch + -32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                if (i == 0 && !capitializeNextLetter) {
                    result.append((char)(ch + 32));
                } else {
                    result.append(ch);
                }
                capitializeNextLetter = false;
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                result.append(ch);
                capitializeNextLetter = true;
                continue;
            }
            capitializeNextLetter = true;
        }
        return result.toString();
    }

    private static String getClassName(String nameWithoutPackage, Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        if (JavaQualifiedNames.multipleJavaFiles(file, flavor)) {
            sb.append(JavaQualifiedNames.getPackage(file, flavor));
            if (sb.length() > 0) {
                sb.append('.');
            }
        } else {
            sb.append(JavaQualifiedNames.getClassName(file, flavor));
            if (sb.length() > 0) {
                sb.append('$');
            }
        }
        sb.append(nameWithoutPackage.replace('.', '$'));
        return sb.toString();
    }

    private static String getClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaQualifiedNames.getPackage(file, flavor));
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(JavaQualifiedNames.getFileClassName(file, flavor));
        return sb.toString();
    }

    public static String getPackage(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        return JavaQualifiedNames.getPackage(file.toProto(), flavor);
    }

    public static String getPackage(DescriptorProtos.FileDescriptorProto file, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions fileOptions = file.getOptions();
        StringBuilder sb = new StringBuilder();
        if (fileOptions.hasJavaPackage()) {
            sb.append(fileOptions.getJavaPackage());
        } else {
            sb.append("com.google.protos");
            if (!file.getPackage().isEmpty()) {
                sb.append('.').append(file.getPackage());
            }
        }
        int javaApiVersion = fileOptions.getJavaApiVersion();
        if (javaApiVersion == 1 && flavor != ProtoFlavor.PROTO1) {
            if (fileOptions.hasJavaAltApiPackage()) {
                return fileOptions.getJavaAltApiPackage();
            }
            sb.append(".proto2api");
        } else if (javaApiVersion == 2 && flavor == ProtoFlavor.PROTO1) {
            if (fileOptions.hasJavaAltApiPackage()) {
                return fileOptions.getJavaAltApiPackage();
            }
            sb.append(".proto1api");
        }
        if (flavor == ProtoFlavor.PROTO2_MUTABLE && JavaQualifiedNames.multipleJavaFiles(file, flavor)) {
            return fileOptions.getJavaMultipleFilesMutablePackage();
        }
        return sb.toString();
    }

    private static String classNameWithoutPackage(Descriptors.Descriptor descriptor) {
        return JavaQualifiedNames.stripPackageName(descriptor.getFullName(), descriptor.getFile());
    }

    private static String classNameWithoutPackage(Descriptors.EnumDescriptor descriptor) {
        Descriptors.Descriptor messageDescriptor = descriptor.getContainingType();
        if (messageDescriptor == null) {
            return descriptor.getName();
        }
        String string = JavaQualifiedNames.classNameWithoutPackage(messageDescriptor);
        String string2 = descriptor.getName();
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('.').append(string2).toString();
    }

    private static String stripPackageName(String fullName, Descriptors.FileDescriptor file) {
        if (file.getPackage().isEmpty()) {
            return fullName;
        }
        return fullName.substring(file.getPackage().length() + 1);
    }

    private static boolean multipleJavaFiles(Descriptors.FileDescriptor fd, ProtoFlavor flavor) {
        return JavaQualifiedNames.multipleJavaFiles(fd.toProto(), flavor);
    }

    private static boolean multipleJavaFiles(DescriptorProtos.FileDescriptorProto fd, ProtoFlavor flavor) {
        DescriptorProtos.FileOptions options = fd.getOptions();
        switch (flavor) {
            case PROTO1: {
                return options.getJavaMultipleFiles() || !options.hasJavaOuterClassname();
            }
            case PROTO2: {
                return options.getJavaMultipleFiles();
            }
            case PROTO2_MUTABLE: {
                return options.getJavaMultipleFiles() && options.hasJavaMultipleFilesMutablePackage();
            }
        }
        throw new AssertionError();
    }

    public static String getFileClassName(Descriptors.FileDescriptor file, ProtoFlavor flavor) {
        return JavaQualifiedNames.getFileClassName(file.toProto(), flavor);
    }

    public static String getFileClassName(DescriptorProtos.FileDescriptorProto file, ProtoFlavor flavor) {
        switch (flavor) {
            case PROTO1: {
                return file.getOptions().getJavaOuterClassname();
            }
            case PROTO2: {
                return JavaQualifiedNames.getFileImmutableClassName(file);
            }
            case PROTO2_MUTABLE: {
                String string = String.valueOf(JavaQualifiedNames.getFileImmutableClassName(file));
                return string.length() != 0 ? "Mutable".concat(string) : new String("Mutable");
            }
        }
        throw new AssertionError();
    }

    private static String getFileImmutableClassName(DescriptorProtos.FileDescriptorProto file) {
        if (file.getOptions().hasJavaOuterClassname()) {
            return file.getOptions().getJavaOuterClassname();
        }
        String className = JavaQualifiedNames.getFileDefaultImmutableClassName(file);
        if (JavaQualifiedNames.hasConflictingClassName(file, className)) {
            return String.valueOf(className).concat("OuterClass");
        }
        return className;
    }

    private static String getFileDefaultImmutableClassName(DescriptorProtos.FileDescriptorProto file) {
        String name = file.getName();
        int lastSlash = name.lastIndexOf(47);
        String basename = lastSlash < 0 ? name : name.substring(lastSlash + 1);
        return JavaQualifiedNames.underscoresToCamelCase(JavaQualifiedNames.stripProto(basename), true);
    }

    private static String stripProto(String filename) {
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            switch (filename.substring(lastDot)) {
                case ".protodevel": 
                case ".proto": {
                    return filename.substring(0, lastDot);
                }
            }
        }
        return filename;
    }

    private static boolean hasConflictingClassName(DescriptorProtos.DescriptorProto messageDesc, String name) {
        if (name.equals(messageDesc.getName())) {
            return true;
        }
        for (DescriptorProtos.EnumDescriptorProto enumDesc : messageDesc.getEnumTypeList()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto nestedMessageDesc : messageDesc.getNestedTypeList()) {
            if (!JavaQualifiedNames.hasConflictingClassName(nestedMessageDesc, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConflictingClassName(DescriptorProtos.FileDescriptorProto file, String name) {
        for (DescriptorProtos.EnumDescriptorProto enumDesc : file.getEnumTypeList()) {
            if (!name.equals(enumDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.ServiceDescriptorProto serviceDesc : file.getServiceList()) {
            if (!name.equals(serviceDesc.getName())) continue;
            return true;
        }
        for (DescriptorProtos.DescriptorProto messageDesc : file.getMessageTypeList()) {
            if (!JavaQualifiedNames.hasConflictingClassName(messageDesc, name)) continue;
            return true;
        }
        return false;
    }
}

