/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.flogger.GoogleLogger;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class TextRecordReader {
    private static final GoogleLogger logger = GoogleLogger.forInjectedClassName("com/google/appengine/repackaged/com/google/protobuf/contrib/TextRecordReader");

    private TextRecordReader() {
    }

    public static void loadFromStream(InputStream stream, String separator, ParseFunction parseFn) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        StringBuilder currentProtoAsString = new StringBuilder();
        while (true) {
            String line;
            if ((line = reader.readLine()) != null && !line.trim().equals(separator)) {
                if (line.startsWith("#")) continue;
                currentProtoAsString.append(line).append('\n');
                continue;
            }
            String s = currentProtoAsString.toString();
            if (!Strings.isNullOrEmpty(s)) {
                parseFn.parse(s);
            }
            if (line == null) break;
            currentProtoAsString = new StringBuilder();
        }
    }

    private static <T extends Message> List<T> loadFromStreamInternal(InputStream stream, String separator, final T prototype, final boolean strictParse) throws IOException {
        final TextFormat.Parser parser = TextFormat.Parser.newBuilder().setAllowUnknownFields(true).build();
        final ArrayList values = new ArrayList();
        TextRecordReader.loadFromStream(stream, separator, new ParseFunction(){

            @Override
            public void parse(String record) throws TextFormat.ParseException {
                try {
                    values.add(TextRecordReader.parseMessageFromString(parser, prototype, record));
                }
                catch (TextFormat.ParseException exc) {
                    if (strictParse) {
                        throw exc;
                    }
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withInjectedLogSite("com/google/appengine/repackaged/com/google/protobuf/contrib/TextRecordReader$1", "parse", 95, "TextRecordReader.java")).log("Error parsing protocol buffer: %s", exc.getMessage());
                }
            }
        });
        return values;
    }

    private static <T extends Message> T parseMessageFromString(TextFormat.Parser parser, T prototype, String content) throws TextFormat.ParseException {
        Message.Builder builder = prototype.newBuilderForType();
        parser.merge((CharSequence)content, builder);
        return (T)builder.build();
    }

    public static <T extends Message> List<T> loadFromStream(InputStream stream, String separator, T prototype) throws IOException {
        return TextRecordReader.loadFromStreamInternal(stream, separator, prototype, false);
    }

    public static <T extends Message> List<T> loadFromStreamStrict(InputStream stream, String separator, T prototype) throws IOException {
        return TextRecordReader.loadFromStreamInternal(stream, separator, prototype, true);
    }

    public static interface ParseFunction {
        public void parse(String var1) throws TextFormat.ParseException;
    }
}

