/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor.pool;

import com.google.appengine.repackaged.com.google.common.base.Verify;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultimap;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Extension;
import com.google.appengine.repackaged.com.google.protobuf.InternalProtobufMeta;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MutableGeneratedMetadataProto;
import com.google.appengine.repackaged.com.google.protobuf.contrib.MessageUtils;
import com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor.pool.DescriptorPool;
import com.google.appengine.repackaged.com.google.protobuf.contrib.descriptor.pool.MutableDescriptorPool;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class GeneratedDescriptorPool
implements DescriptorPool {
    @GuardedBy(value="descriptorPool")
    private final MutableDescriptorPool descriptorPool = new MutableDescriptorPool();
    @GuardedBy(value="populatedExtensionContainingTypeNames")
    private final HashSet<String> populatedExtensionContainingTypeNames = new HashSet();
    private final ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> generatedMessageMap;
    private final ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> generatedEnumMap;
    private final ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> generatedExtensionMap;

    private GeneratedDescriptorPool(ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> generatedMessageMap, ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> generatedEnumMap, ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> generatedExtensionMap) {
        this.generatedMessageMap = generatedMessageMap;
        this.generatedEnumMap = generatedEnumMap;
        this.generatedExtensionMap = generatedExtensionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Descriptors.Descriptor getDescriptorForTypeName(String typeName) {
        Descriptors.Descriptor descriptor;
        MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
        synchronized (mutableDescriptorPool) {
            descriptor = this.descriptorPool.getDescriptorForTypeName(typeName);
        }
        if (descriptor == null) {
            this.populateDescriptorPoolForTypeName(typeName);
            mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                descriptor = this.descriptorPool.getDescriptorForTypeName(typeName);
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Descriptors.EnumDescriptor getEnumDescriptorForName(String typeName) {
        Descriptors.EnumDescriptor descriptor;
        MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
        synchronized (mutableDescriptorPool) {
            descriptor = this.descriptorPool.getEnumDescriptorForName(typeName);
        }
        if (descriptor == null) {
            this.populateDescriptorPoolForEnumName(typeName);
            mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                descriptor = this.descriptorPool.getEnumDescriptorForName(typeName);
            }
        }
        return descriptor;
    }

    @Override
    public Descriptors.ServiceDescriptor getServiceDescriptorForName(String serviceName) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Descriptors.FieldDescriptor getExtension(String containingName, int extensionNumber) {
        Descriptors.FieldDescriptor descriptor;
        MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
        synchronized (mutableDescriptorPool) {
            descriptor = this.descriptorPool.getExtension(containingName, extensionNumber);
        }
        if (descriptor == null) {
            this.populateDescriptorPoolForTypeName(containingName);
            this.populateExtensionsForContainingTypeName(containingName);
            mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                descriptor = this.descriptorPool.getExtension(containingName, extensionNumber);
            }
        }
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ImmutableList<Descriptors.FieldDescriptor> getAllExtensionsForTypeName(String typeName) {
        ImmutableList<Descriptors.FieldDescriptor> descriptors;
        MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
        synchronized (mutableDescriptorPool) {
            descriptors = this.descriptorPool.getAllExtensionsForTypeName(typeName);
        }
        if (descriptors == null) {
            this.populateDescriptorPoolForTypeName(typeName);
            this.populateExtensionsForContainingTypeName(typeName);
            mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                descriptors = this.descriptorPool.getAllExtensionsForTypeName(typeName);
            }
        }
        return descriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDescriptorPoolForTypeName(String typeName) {
        Collection messageEntries = this.generatedMessageMap.get((Object)typeName);
        if (messageEntries.isEmpty()) {
            return;
        }
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry messageEntry : messageEntries) {
            String clazzName = messageEntry.getLoadPath();
            Message defaultInstance = GeneratedDescriptorPool.getDefaultInstance(clazzName);
            if (defaultInstance == null) continue;
            MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                this.descriptorPool.populateFromMessageType(defaultInstance);
                return;
            }
        }
        throw new IllegalStateException(String.format("Unable to locate any class for message %s tried %s", typeName, messageEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDescriptorPoolForEnumName(String typeName) {
        Collection enumEntries = this.generatedEnumMap.get((Object)typeName);
        if (enumEntries.isEmpty()) {
            return;
        }
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry enumEntry : enumEntries) {
            Descriptors.EnumDescriptor desc;
            String clazzName = enumEntry.getLoadPath();
            try {
                Method m = Class.forName(clazzName).getMethod("getDescriptor", new Class[0]);
                desc = (Descriptors.EnumDescriptor)m.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                continue;
            }
            MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                this.descriptorPool.populateFromFileDescriptor(desc.getFile());
                return;
            }
        }
        throw new IllegalStateException(String.format("Unable to locate any class for enum %s tried %s", typeName, enumEntries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateExtensionsForContainingTypeName(String typeName) {
        HashSet<String> hashSet = this.populatedExtensionContainingTypeNames;
        synchronized (hashSet) {
            if (this.populatedExtensionContainingTypeNames.contains(typeName)) {
                return;
            }
        }
        Collection entries = this.generatedExtensionMap.get((Object)typeName);
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry extensionEntry : entries) {
            Extension extension;
            String[] parts = extensionEntry.getLoadPath().split(":");
            Verify.verify(parts.length == 2);
            try {
                Field f = Class.forName(parts[0]).getDeclaredField(parts[1]);
                extension = (Extension)Extension.class.cast(f.get(null));
            }
            catch (ReflectiveOperationException e) {
                continue;
            }
            MutableDescriptorPool mutableDescriptorPool = this.descriptorPool;
            synchronized (mutableDescriptorPool) {
                this.descriptorPool.addExtension(extension.getDescriptor());
            }
        }
        HashSet<String> hashSet2 = this.populatedExtensionContainingTypeNames;
        synchronized (hashSet2) {
            this.populatedExtensionContainingTypeNames.add(typeName);
        }
    }

    @Nullable
    private static Message getDefaultInstance(String clazzName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            return (Message)MessageUtils.getDefaultInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static GeneratedDescriptorPool newInstance() {
        return new GeneratedDescriptorPool(GeneratedDescriptorPool.loadMessageMetadata(), GeneratedDescriptorPool.loadEnumMetadata(), GeneratedDescriptorPool.loadExtensionMetadata());
    }

    public static GeneratedDescriptorPool getInstance() {
        return Holder.INSTANCE;
    }

    private static ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> loadMessageMetadata() {
        ImmutableMultimap.Builder<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> generatedMessageMap = ImmutableMultimap.builder();
        List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry> entries = InternalProtobufMeta.getInstance().getMessages();
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedMessageEntry entry : entries) {
            generatedMessageMap.put(entry.getName(), entry);
        }
        return generatedMessageMap.build();
    }

    private static ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> loadEnumMetadata() {
        ImmutableMultimap.Builder<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> generatedEnumMap = ImmutableMultimap.builder();
        List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry> entries = InternalProtobufMeta.getInstance().getEnums();
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedEnumEntry entry : entries) {
            generatedEnumMap.put(entry.getName(), entry);
        }
        return generatedEnumMap.build();
    }

    private static ImmutableMultimap<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> loadExtensionMetadata() {
        ImmutableMultimap.Builder<String, MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> generatedExtensionMap = ImmutableMultimap.builder();
        List<MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry> entries = InternalProtobufMeta.getInstance().getExtensions();
        for (MutableGeneratedMetadataProto.GeneratedMetadata.GeneratedExtensionEntry entry : entries) {
            generatedExtensionMap.put(entry.getExtendedType(), entry);
        }
        return generatedExtensionMap.build();
    }

    private static class Holder {
        private static final GeneratedDescriptorPool INSTANCE = GeneratedDescriptorPool.newInstance();

        private Holder() {
        }
    }
}

