/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.backends.dev.LocalServerController;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.BackendContainer;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.ContainerUtils;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.InstanceHelper;
import com.google.appengine.tools.development.InstanceStateHolder;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.BackendsXml;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractBackendServers
implements BackendContainer,
LocalServerController,
AbstractContainerService.PortMappingProvider {
    public static final String SYSTEM_PROPERTY_STATIC_PORT_NUM_PREFIX = "com.google.appengine.devappserver.";
    private static final Integer DEFAULT_INSTANCES = 1;
    private static final String DEFAULT_INSTANCE_CLASS = "B1";
    private static final Integer DEFAULT_MAX_CONCURRENT_REQUESTS = 10;
    private static final int MAX_PENDING_QUEUE_LENGTH = 20;
    private static final int MAX_PENDING_QUEUE_TIME_MS = 10000;
    private static final int MAX_START_QUEUE_TIME_MS = 30000;
    private String address;
    private ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle;
    private File externalResourceDir;
    private Map<String, Object> containerConfigProperties;
    private Map<ServerInstanceEntry, ServerWrapper> backendServers = ImmutableMap.copyOf(new HashMap());
    private Map<String, String> portMapping = ImmutableMap.copyOf(new HashMap());
    protected Logger logger = Logger.getLogger(AbstractBackendServers.class.getName());
    private Map<String, String> serviceProperties = new HashMap<String, String>();
    private DevAppServer devAppServer;
    private ApiProxyLocal apiProxyLocal;

    @Override
    public void init(String address, ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle, File externalResourceDirectory, Map<String, Object> containerConfigProperties, DevAppServer devAppServer) {
        this.moduleConfigurationHandle = moduleConfigurationHandle;
        this.externalResourceDir = externalResourceDirectory;
        this.address = address;
        this.containerConfigProperties = containerConfigProperties;
        this.devAppServer = devAppServer;
    }

    @Override
    public void setServiceProperties(Map<String, String> properties) {
        this.serviceProperties = properties;
    }

    @Override
    public void shutdownAll() throws Exception {
        for (ServerWrapper server : this.backendServers.values()) {
            String string = String.valueOf(server);
            this.logger.logp(Level.FINER, "com.google.appengine.tools.development.AbstractBackendServers", "shutdownAll", new StringBuilder(17 + String.valueOf(string).length()).append("server shutdown: ").append(string).toString());
            server.shutdown();
        }
        this.backendServers = ImmutableMap.copyOf(new HashMap());
    }

    public TreeMap<String, LocalServerController.BackendStateInfo> getBackendState(String requestHostName) {
        TreeMap<String, LocalServerController.BackendStateInfo> serverInfoMap = new TreeMap<String, LocalServerController.BackendStateInfo>();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            String listenAddress;
            String name = serverWrapper.serverEntry.getName();
            if (requestHostName == null) {
                listenAddress = this.portMapping.get(serverWrapper.getDnsPrefix());
            } else {
                int n = serverWrapper.port;
                listenAddress = new StringBuilder(12 + String.valueOf(requestHostName).length()).append(requestHostName).append(":").append(n).toString();
            }
            LocalServerController.BackendStateInfo ssi = serverInfoMap.get(name);
            if (ssi == null) {
                ssi = new LocalServerController.BackendStateInfo(serverWrapper.serverEntry);
                serverInfoMap.put(name, ssi);
            }
            if (serverWrapper.isLoadBalanceServer()) {
                ssi.setState(serverWrapper.getStateHolder().getDisplayName());
                ssi.setAddress(listenAddress);
                continue;
            }
            ssi.add(new LocalServerController.InstanceStateInfo(serverWrapper.serverInstance, listenAddress, serverWrapper.getStateHolder().getDisplayName()));
        }
        return serverInfoMap;
    }

    public synchronized void startBackend(String serverToStart) throws IllegalStateException {
        if (!this.checkServerExists(serverToStart)) {
            String message = String.format("Tried to start unknown server %s", serverToStart);
            this.logger.logp(Level.WARNING, "com.google.appengine.tools.development.AbstractBackendServers", "startBackend", message);
            throw new IllegalStateException(message);
        }
        for (ServerWrapper server : this.backendServers.values()) {
            if (!server.getName().equals(serverToStart) || !server.getStateHolder().test(InstanceStateHolder.InstanceState.STOPPED)) continue;
            if (server.isLoadBalanceServer()) {
                server.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.STOPPED);
                continue;
            }
            server.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.SLEEPING, InstanceStateHolder.InstanceState.STOPPED);
            server.sendStartRequest();
        }
    }

    public synchronized void stopBackend(String serverToStop) throws Exception {
        if (!this.checkServerExists(serverToStop)) {
            String message = String.format("Tried to stop unknown server %s", serverToStop);
            this.logger.logp(Level.WARNING, "com.google.appengine.tools.development.AbstractBackendServers", "stopBackend", message);
            throw new IllegalStateException(message);
        }
        for (ServerWrapper server : this.backendServers.values()) {
            if (!server.getName().equals(serverToStop) || server.getStateHolder().test(InstanceStateHolder.InstanceState.STOPPED)) continue;
            if (server.isLoadBalanceServer()) {
                server.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.RUNNING);
                continue;
            }
            String string = String.valueOf(server.getDnsPrefix());
            this.logger.logp(Level.FINE, "com.google.appengine.tools.development.AbstractBackendServers", "stopBackend", string.length() != 0 ? "Stopping server: ".concat(string) : new String("Stopping server: "));
            server.shutdown();
            server.createConnection();
            server.startup(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureAll(ApiProxyLocal local) throws Exception {
        this.apiProxyLocal = local;
        BackendsXml backendsXml = this.moduleConfigurationHandle.getBackendsXml();
        if (backendsXml == null) {
            this.logger.logp(Level.FINE, "com.google.appengine.tools.development.AbstractBackendServers", "configureAll", "Got null backendsXml config.");
            return;
        }
        List<BackendsXml.Entry> servers = backendsXml.getBackends();
        if (servers.isEmpty()) {
            this.logger.logp(Level.FINE, "com.google.appengine.tools.development.AbstractBackendServers", "configureAll", "No backends configured.");
            return;
        }
        if (!this.backendServers.isEmpty()) {
            throw new Exception("Tried to start backend servers but some are already running.");
        }
        int n = servers.size();
        this.logger.logp(Level.FINER, "com.google.appengine.tools.development.AbstractBackendServers", "configureAll", new StringBuilder(38).append("Found ").append(n).append(" configured backends.").toString());
        HashMap<ServerInstanceEntry, ServerWrapper> serverMap = Maps.newHashMap();
        for (BackendsXml.Entry entry : servers) {
            entry = this.resolveDefaults(entry);
            for (int serverInstance = -1; serverInstance < entry.getInstances(); ++serverInstance) {
                int port = this.checkForStaticPort(entry.getName(), serverInstance);
                ServerWrapper serverWrapper2 = new ServerWrapper(ContainerUtils.loadContainer(), entry, serverInstance, port);
                serverMap.put(new ServerInstanceEntry(entry.getName(), serverInstance), serverWrapper2);
            }
        }
        this.backendServers = ImmutableMap.copyOf(serverMap);
        String prettyAddress = this.address;
        if ("0.0.0.0".equals(this.address)) {
            prettyAddress = "127.0.0.1";
        }
        HashMap<String, String> portMap = Maps.newHashMap();
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            int serverWrapper2 = serverWrapper.serverInstance;
            String string = serverWrapper.getName();
            String string2 = this.address;
            int n2 = serverWrapper.port;
            this.logger.logp(Level.FINER, "com.google.appengine.tools.development.AbstractBackendServers", "configureAll", new StringBuilder(45 + String.valueOf(string).length() + String.valueOf(string2).length()).append("starting server: ").append(serverWrapper2).append(".").append(string).append(" on ").append(string2).append(":").append(n2).toString());
            ApiProxy.Delegate configured = ApiProxy.getDelegate();
            try {
                ApiProxy.setDelegate((ApiProxy.Delegate)local);
                serverWrapper.createConnection();
            }
            finally {
                ApiProxy.setDelegate((ApiProxy.Delegate)configured);
            }
            string = prettyAddress;
            int n3 = serverWrapper.port;
            portMap.put(serverWrapper.getDnsPrefix(), new StringBuilder(12 + String.valueOf(string).length()).append(string).append(":").append(n3).toString());
        }
        this.portMapping = ImmutableMap.copyOf(portMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startupAll() throws Exception {
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            int n = serverWrapper.serverInstance;
            String string = serverWrapper.getName();
            String string2 = this.address;
            int n2 = serverWrapper.port;
            this.logger.logp(Level.FINER, "com.google.appengine.tools.development.AbstractBackendServers", "startupAll", new StringBuilder(45 + String.valueOf(string).length() + String.valueOf(string2).length()).append("starting server: ").append(n).append(".").append(string).append(" on ").append(string2).append(":").append(n2).toString());
            ApiProxy.Delegate configured = ApiProxy.getDelegate();
            try {
                ApiProxy.setDelegate((ApiProxy.Delegate)this.apiProxyLocal);
                serverWrapper.startup(false);
            }
            finally {
                ApiProxy.setDelegate((ApiProxy.Delegate)configured);
            }
        }
        for (ServerWrapper serverWrapper : this.backendServers.values()) {
            if (serverWrapper.isLoadBalanceServer()) continue;
            serverWrapper.sendStartRequest();
        }
    }

    private BackendsXml.Entry resolveDefaults(BackendsXml.Entry entry) {
        return new BackendsXml.Entry(entry.getName(), entry.getInstances() == null ? DEFAULT_INSTANCES : entry.getInstances(), entry.getInstanceClass() == null ? DEFAULT_INSTANCE_CLASS : entry.getInstanceClass(), entry.getMaxConcurrentRequests() == null ? DEFAULT_MAX_CONCURRENT_REQUESTS : entry.getMaxConcurrentRequests(), entry.getOptions(), entry.getState() == null ? BackendsXml.State.STOP : entry.getState());
    }

    void forwardToServer(String requestedServer, int instance, HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        ServerWrapper server = this.getServerWrapper(requestedServer, instance);
        String string = String.valueOf(server);
        this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "forwardToServer", new StringBuilder(30 + String.valueOf(string).length()).append("forwarding request to server: ").append(string).toString());
        server.getContainer().forwardToServer(hrequest, hresponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireServingPermit(String serverName, int instanceNumber, boolean allowQueueOnBackends) {
        this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "acquireServingPermit", String.format("trying to get serving permit for server %d.%s", instanceNumber, serverName));
        try {
            String string;
            ServerWrapper server = this.getServerWrapper(serverName, instanceNumber);
            int maxQueueTime = 0;
            InstanceStateHolder instanceStateHolder = server.getStateHolder();
            synchronized (instanceStateHolder) {
                if (!server.getStateHolder().acceptsConnections()) {
                    String string2 = String.valueOf(server);
                    this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "acquireServingPermit", new StringBuilder(50 + String.valueOf(string2).length()).append(string2).append(": got request but server is not in a serving state").toString());
                    return false;
                }
                if (server.getApproximateQueueLength() > 20) {
                    String string3 = String.valueOf(server);
                    this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "acquireServingPermit", new StringBuilder(22 + String.valueOf(string3).length()).append(string3).append(": server queue is full").toString());
                    return false;
                }
                if (server.getStateHolder().test(InstanceStateHolder.InstanceState.SLEEPING)) {
                    string = String.valueOf(server);
                    this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "acquireServingPermit", new StringBuilder(27 + String.valueOf(string).length()).append(string).append(": waking up sleeping server").toString());
                    server.sendStartRequest();
                }
                if (server.getStateHolder().test(InstanceStateHolder.InstanceState.RUNNING_START_REQUEST)) {
                    maxQueueTime = 30000;
                } else if (allowQueueOnBackends && server.getMaxPendingQueueSize() > 0) {
                    maxQueueTime = 10000;
                }
            }
            boolean gotPermit = server.acquireServingPermit(maxQueueTime);
            string = String.valueOf(server);
            int n = maxQueueTime;
            this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "acquireServingPermit", new StringBuilder(63 + String.valueOf(string).length()).append(string).append(": tried to get server permit, timeout=").append(n).append(" success=").append(gotPermit).toString());
            return gotPermit;
        }
        catch (InterruptedException e) {
            this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "acquireServingPermit", new StringBuilder(62 + String.valueOf(serverName).length()).append(instanceNumber).append(".").append(serverName).append(": got interrupted while waiting for serving permit").toString());
            return false;
        }
    }

    public int getAndReserveFreeInstance(String requestedServer) {
        String string = String.valueOf(requestedServer);
        this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "getAndReserveFreeInstance", string.length() != 0 ? "trying to get serving permit for server ".concat(string) : new String("trying to get serving permit for server "));
        ServerWrapper server = this.getServerWrapper(requestedServer, -1);
        if (server == null) {
            return -1;
        }
        if (!server.getStateHolder().acceptsConnections()) {
            return -1;
        }
        int instanceNum = server.getInstances();
        for (int i = 0; i < instanceNum; ++i) {
            if (!this.acquireServingPermit(requestedServer, i, false)) continue;
            return i;
        }
        if (server.getMaxPendingQueueSize() > 0) {
            return this.addToShortestInstanceQueue(requestedServer);
        }
        this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "getAndReserveFreeInstance", "no servers free");
        return -1;
    }

    int addToShortestInstanceQueue(String requestedServer) {
        this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "addToShortestInstanceQueue", String.valueOf(requestedServer).concat(": no instances free, trying to find a queue"));
        int shortestQueue = 20;
        ServerWrapper instanceWithShortestQueue = null;
        for (ServerWrapper server : this.backendServers.values()) {
            int serverQueue;
            if (!server.getStateHolder().acceptsConnections() || shortestQueue <= (serverQueue = server.getApproximateQueueLength())) continue;
            instanceWithShortestQueue = server;
            shortestQueue = serverQueue;
        }
        try {
            if (shortestQueue < 20) {
                Object object = String.valueOf(instanceWithShortestQueue);
                this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "addToShortestInstanceQueue", new StringBuilder(37 + String.valueOf(object).length()).append("adding request to queue on instance: ").append((String)object).toString());
                if (instanceWithShortestQueue.acquireServingPermit(10000)) {
                    object = String.valueOf(instanceWithShortestQueue);
                    this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers", "addToShortestInstanceQueue", new StringBuilder(36 + String.valueOf(object).length()).append("ready to serve request on instance: ").append((String)object).toString());
                    return instanceWithShortestQueue.serverInstance;
                }
            }
        }
        catch (InterruptedException e) {
            String string = String.valueOf(instanceWithShortestQueue);
            this.logger.logp(Level.FINER, "com.google.appengine.tools.development.AbstractBackendServers", "addToShortestInstanceQueue", new StringBuilder(34 + String.valueOf(string).length()).append("interupted while queued at server ").append(string).toString());
        }
        return -1;
    }

    public void returnServingPermit(String serverName, int instance) {
        ServerWrapper server = this.getServerWrapper(serverName, instance);
        server.releaseServingPermit();
    }

    public int getPort(String serverName, int instance) {
        ServerWrapper server = this.getServerWrapper(serverName, instance);
        return server.port;
    }

    public boolean checkInstanceExists(String serverName, int instance) {
        return this.getServerWrapper(serverName, instance) != null;
    }

    public boolean checkServerExists(String serverName) {
        return this.checkInstanceExists(serverName, -1);
    }

    public boolean checkServerStopped(String serverName) {
        return this.checkInstanceStopped(serverName, -1);
    }

    public boolean checkInstanceStopped(String serverName, int instance) {
        return !this.getServerWrapper(serverName, instance).getStateHolder().acceptsConnections();
    }

    @Override
    public Map<String, String> getPortMapping() {
        return this.portMapping;
    }

    public int getServerInstanceFromPort(int port) {
        ServerWrapper server = this.getServerWrapperFromPort(port);
        if (server != null) {
            return server.serverInstance;
        }
        return -1;
    }

    public String getServerNameFromPort(int port) {
        ServerWrapper server = this.getServerWrapperFromPort(port);
        if (server != null) {
            return server.getName();
        }
        return null;
    }

    private ServerWrapper getServerWrapperFromPort(int port) {
        for (Map.Entry<ServerInstanceEntry, ServerWrapper> entry : this.backendServers.entrySet()) {
            if (entry.getValue().port != port) continue;
            return entry.getValue();
        }
        return null;
    }

    protected ServerWrapper getServerWrapper(String serverName, int instanceNumber) {
        return this.backendServers.get(new ServerInstanceEntry(serverName, instanceNumber));
    }

    private int checkForStaticPort(String server, int instance) {
        StringBuilder key = new StringBuilder();
        key.append(SYSTEM_PROPERTY_STATIC_PORT_NUM_PREFIX);
        key.append(server);
        if (instance >= 0) {
            key.append(new StringBuilder(12).append(".").append(instance).toString());
        }
        key.append(".port");
        String configuredPort = this.serviceProperties.get(key.toString());
        if (configuredPort != null) {
            return Integer.parseInt(configuredPort);
        }
        return 0;
    }

    protected class ServerWrapper {
        private final ContainerService container;
        private final int serverInstance;
        private int port;
        private final BackendsXml.Entry serverEntry;
        private final InstanceStateHolder stateHolder;
        private final InstanceHelper instanceHelper;
        private final Semaphore servingQueue = new Semaphore(0, true);

        public ServerWrapper(ContainerService containerService, BackendsXml.Entry serverEntry, int instance, int port) {
            this.container = containerService;
            this.serverEntry = serverEntry;
            this.serverInstance = instance;
            this.port = port;
            this.stateHolder = new InstanceStateHolder(serverEntry.getName(), instance);
            this.instanceHelper = new InstanceHelper(serverEntry.getName(), instance, this.stateHolder, this.container);
        }

        void shutdown() throws Exception {
            this.instanceHelper.shutdown();
        }

        void createConnection() throws Exception {
            this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.INITIALIZING, InstanceStateHolder.InstanceState.SHUTDOWN);
            ImmutableMap<String, Object> instanceConfigProperties = ImmutableMap.builder().putAll(AbstractBackendServers.this.containerConfigProperties).put("com.google.appengine.backend.id", this.serverEntry.getName()).put("com.google.appengine.instance.id", (String)((Object)Integer.valueOf(this.serverInstance))).build();
            this.getContainer().configure(ContainerUtils.getServerInfo(), AbstractBackendServers.this.address, this.port, AbstractBackendServers.this.moduleConfigurationHandle, AbstractBackendServers.this.externalResourceDir, instanceConfigProperties, this.serverInstance, AbstractBackendServers.this.devAppServer);
            this.getContainer().createConnection();
            this.getContainer().setApiProxyDelegate(AbstractBackendServers.this.apiProxyLocal);
            this.port = this.getContainer().getPort();
        }

        void startup(boolean setStateToStopped) throws Exception {
            this.getContainer().startup();
            if (setStateToStopped) {
                this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.STOPPED, InstanceStateHolder.InstanceState.INITIALIZING);
            } else {
                int n = this.serverInstance;
                String string = this.serverEntry.getName();
                int n2 = this.port;
                AbstractBackendServers.this.logger.logp(Level.INFO, "com.google.appengine.tools.development.AbstractBackendServers$ServerWrapper", "startup", new StringBuilder(51 + String.valueOf(string).length()).append("server: ").append(n).append(".").append(string).append(" is running on port ").append(n2).toString());
                if (this.isLoadBalanceServer()) {
                    this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.INITIALIZING);
                } else {
                    this.getStateHolder().testAndSet(InstanceStateHolder.InstanceState.SLEEPING, InstanceStateHolder.InstanceState.INITIALIZING);
                }
            }
        }

        void sendStartRequest() {
            this.instanceHelper.sendStartRequest(new Runnable(){

                @Override
                public void run() {
                    ServerWrapper.this.servingQueue.release(ServerWrapper.this.serverEntry.getMaxConcurrentRequests());
                }
            });
        }

        boolean acquireServingPermit(int maxWaitTimeInMs) throws InterruptedException {
            String string = String.valueOf(this);
            int n = this.servingQueue.availablePermits();
            AbstractBackendServers.this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers$ServerWrapper", "acquireServingPermit", new StringBuilder(50 + String.valueOf(string).length()).append(string).append(": accuiring serving permit, available: ").append(n).toString());
            return this.servingQueue.tryAcquire(maxWaitTimeInMs, TimeUnit.MILLISECONDS);
        }

        void releaseServingPermit() {
            this.servingQueue.release();
            String string = String.valueOf(this);
            int n = this.servingQueue.availablePermits();
            AbstractBackendServers.this.logger.logp(Level.FINEST, "com.google.appengine.tools.development.AbstractBackendServers$ServerWrapper", "releaseServingPermit", new StringBuilder(49 + String.valueOf(string).length()).append(string).append(": returned serving permit, available: ").append(n).toString());
        }

        int getApproximateQueueLength() {
            return this.servingQueue.getQueueLength();
        }

        int getMaxPendingQueueSize() {
            return this.serverEntry.isFailFast() ? 0 : 20;
        }

        public String getDnsPrefix() {
            if (!this.isLoadBalanceServer()) {
                int n = this.serverInstance;
                String string = this.getName();
                return new StringBuilder(12 + String.valueOf(string).length()).append(n).append(".").append(string).toString();
            }
            return this.getName();
        }

        String getName() {
            return this.serverEntry.getName();
        }

        public int getInstances() {
            return this.serverEntry.getInstances();
        }

        InstanceStateHolder getStateHolder() {
            return this.stateHolder;
        }

        boolean isLoadBalanceServer() {
            return this.serverInstance == -1;
        }

        public String toString() {
            int n = this.serverInstance;
            String string = this.serverEntry.getName();
            String string2 = String.valueOf(this.stateHolder);
            return new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string2).length()).append(n).append(".").append(string).append(" state=").append(string2).toString();
        }

        public ContainerService getContainer() {
            return this.container;
        }
    }

    static class ServerInstanceEntry {
        private final int instanceNumber;
        private final String serverName;

        public ServerInstanceEntry(String serverName, int instanceNumber) {
            this.serverName = serverName;
            this.instanceNumber = instanceNumber;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ServerInstanceEntry)) {
                return false;
            }
            ServerInstanceEntry that = (ServerInstanceEntry)o;
            if (this.serverName != null ? !this.serverName.equals(that.serverName) : that.serverName != null) {
                return false;
            }
            return this.instanceNumber == that.instanceNumber;
        }

        public int hashCode() {
            int hash = 17;
            hash = 31 * hash + this.instanceNumber;
            if (this.serverName != null) {
                hash = 31 * hash + this.serverName.hashCode();
            }
            return hash;
        }

        public String toString() {
            int n = this.instanceNumber;
            String string = this.serverName;
            return new StringBuilder(12 + String.valueOf(string).length()).append(n).append(".").append(string).toString();
        }
    }
}

