/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.ExtendedRootResource;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.io.IoUtil;
import com.google.apphosting.utils.jetty.AppEngineWebAppContext;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.security.ConstraintMapping;

public class DevAppEngineWebAppContext
extends AppEngineWebAppContext {
    private static final Logger logger = Logger.getLogger(DevAppEngineWebAppContext.class.getName());
    private static final String JASPER_SERVLET_CLASSPATH = "org.apache.catalina.jsp_classpath";
    private static final String X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK = "X-Google-DevAppserver-SkipAdminCheck";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";
    private final Object transportGuaranteeLock = new Object();
    private boolean transportGuaranteesDisabled = false;

    public DevAppEngineWebAppContext(File appDir, File externalResourceDir, String serverInfo, ApiProxy.Delegate<?> apiProxyDelegate, DevAppServer devAppServer) {
        super(appDir, serverInfo);
        this.setAttribute(JASPER_SERVLET_CLASSPATH, this.buildClasspath());
        this._scontext.setAttribute("com.google.appengine.devappserver.ApiProxyLocal", apiProxyDelegate);
        this._scontext.setAttribute("com.google.appengine.devappserver.Server", devAppServer);
        if (externalResourceDir != null) {
            try {
                this.resolveWebApp();
                this.setBaseResource(new ExtendedRootResource(this.getBaseResource(), externalResourceDir));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        if (this.hasSkipAdminCheck(request)) {
            request.setAttribute(SKIP_ADMIN_CHECK_ATTR, (Object)Boolean.TRUE);
        }
        this.disableTransportGuarantee();
        String string = String.valueOf(Thread.currentThread().getName());
        System.setProperty(string.length() != 0 ? "devappserver-thread-".concat(string) : new String("devappserver-thread-"), "true");
        try {
            super.handle(target, request, response, dispatch);
        }
        catch (Throwable throwable) {
            String string2 = String.valueOf(Thread.currentThread().getName());
            System.clearProperty(string2.length() != 0 ? "devappserver-thread-".concat(string2) : new String("devappserver-thread-"));
            throw throwable;
        }
        String string3 = String.valueOf(Thread.currentThread().getName());
        System.clearProperty(string3.length() != 0 ? "devappserver-thread-".concat(string3) : new String("devappserver-thread-"));
    }

    private boolean hasSkipAdminCheck(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (!name.equalsIgnoreCase(X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK)) continue;
            return true;
        }
        return false;
    }

    private String buildClasspath() {
        Object f2;
        StringBuffer classpath = new StringBuffer();
        for (Object f2 : AppengineSdk.getSdk().getSharedLibFiles()) {
            classpath.append(((File)f2).getAbsolutePath());
            classpath.append(File.pathSeparatorChar);
        }
        String webAppPath = this.getWar();
        f2 = File.separator;
        char c = File.pathSeparatorChar;
        classpath.append(new StringBuilder(8 + String.valueOf(webAppPath).length() + String.valueOf(f2).length()).append(webAppPath).append((String)f2).append("classes").append(c).toString());
        List<File> files = IoUtil.getFilesAndDirectories(new File(webAppPath, "lib"));
        for (File f3 : files) {
            if (!f3.isFile() || !f3.getName().endsWith(".jar")) continue;
            classpath.append(f3.getAbsolutePath());
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableTransportGuarantee() {
        Object object = this.transportGuaranteeLock;
        synchronized (object) {
            ConstraintMapping[] mappings;
            if (!this.transportGuaranteesDisabled && this.getSecurityHandler() != null && (mappings = this.getSecurityHandler().getConstraintMappings()) != null) {
                for (ConstraintMapping mapping : mappings) {
                    if (mapping.getConstraint().getDataConstraint() <= 0) continue;
                    String string = mapping.getPathSpec();
                    logger.logp(Level.INFO, "com.google.appengine.tools.development.DevAppEngineWebAppContext", "disableTransportGuarantee", new StringBuilder(127 + String.valueOf(string).length()).append("Ignoring <transport-guarantee> for ").append(string).append(" as the SDK does not support HTTPS.  It will still be used when you upload your application.").toString());
                    mapping.getConstraint().setDataConstraint(0);
                }
            }
            this.transportGuaranteesDisabled = true;
        }
    }
}

