/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.log.dev.DevLogHandler;
import com.google.appengine.tools.development.ApiServerFactory;
import com.google.appengine.tools.development.ApiUtils;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogStubServicePb;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class DevAppServerRequestLogFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestId = DevLogHandler.getRequestId();
        if (ApiUtils.isUsingPythonStub("logservice")) {
            this.startRequestOnPythonApiServer(request, requestId);
            try {
                chain.doFilter(request, response);
            }
            finally {
                this.endRequestOnPythonApiServer(response, requestId);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void startRequestOnPythonApiServer(ServletRequest request, String requestId) throws IOException {
        String userAgent;
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        LogStubServicePb.StartRequestLogRequest startRequestLogRequest = new LogStubServicePb.StartRequestLogRequest().setRequestId(requestId).setUserRequestId(requestId).setIp(httpRequest.getRemoteAddr()).setAppId(env.getAppId()).setVersionId(env.getVersionId()).setHost(httpRequest.getLocalName()).setMethod(httpRequest.getMethod()).setResource(httpRequest.getRequestURI()).setHttpVersion(httpRequest.getProtocol()).setStartTime(System.currentTimeMillis() * 1000L).setModule(env.getModuleId());
        String nickname = httpRequest.getRemoteUser();
        if (nickname != null) {
            startRequestLogRequest.setNickname(nickname);
        }
        if ((userAgent = httpRequest.getHeader("User-Agent")) != null) {
            startRequestLogRequest.setUserAgent(userAgent);
        }
        byte[] requestBytes = ApiUtils.convertPbToBytes(startRequestLogRequest);
        ApiServerFactory.getExistingApiServer().makeSyncCall("logservice", "StartRequestLog", requestBytes);
    }

    private void endRequestOnPythonApiServer(ServletResponse response, String requestId) throws IOException {
        RecordingResponseWrapper httpResponse = new RecordingResponseWrapper((HttpServletResponse)response);
        LogStubServicePb.EndRequestLogRequest endRequestLogRequest = new LogStubServicePb.EndRequestLogRequest().setRequestId(requestId).setStatus(httpResponse.getStatus()).setResponseSize(httpResponse.getHeader("Content-Length"));
        byte[] requestBytes = ApiUtils.convertPbToBytes(endRequestLogRequest);
        ApiServerFactory.getExistingApiServer().makeSyncCall("logservice", "EndRequestLog", requestBytes);
    }

    private static class RecordingResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;
        private int contentLength = 0;

        RecordingResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            this.status = sc;
            super.setStatus(sc);
        }

        public void setStatus(int status, String string) {
            super.setStatus(status, string);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public void setIntHeader(String name, int value) {
            if (name.equalsIgnoreCase("content-length")) {
                this.contentLength = value;
            }
            super.setIntHeader(name, value);
        }

        public int getHeader(String name) {
            if (!name.equalsIgnoreCase("content-length")) {
                throw new IllegalArgumentException("RecordingResponseWrapper only tracks the Content-Length header value.");
            }
            return this.contentLength;
        }

        public void reset() {
            super.reset();
            this.status = 200;
            this.contentLength = 0;
        }
    }
}

