/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnvironmentVariableChecker {
    @VisibleForTesting
    static final Logger LOGGER = Logger.getLogger(EnvironmentVariableChecker.class.getName());
    private final MismatchReportingPolicy mismatchReportingPolicy;
    private final ImmutableList.Builder<Mismatch> mismatchListBuilder = ImmutableList.builder();

    EnvironmentVariableChecker(MismatchReportingPolicy mismatchReportingPolicy) {
        this.mismatchReportingPolicy = mismatchReportingPolicy;
    }

    void add(AppEngineWebXml appEngineWebXml, File appEngineWebXmlFile) {
        for (Map.Entry<String, String> entry : appEngineWebXml.getEnvironmentVariables().entrySet()) {
            if (entry.getValue().equals(System.getenv(entry.getKey()))) continue;
            this.mismatchListBuilder.add((Object)new Mismatch(entry.getKey(), System.getenv(entry.getKey()), entry.getValue(), appEngineWebXmlFile));
        }
    }

    void check() throws AppEngineConfigException {
        ImmutableCollection mismatches = this.mismatchListBuilder.build();
        if (!mismatches.isEmpty()) {
            String string = String.valueOf(mismatches);
            String msg = new StringBuilder(378 + String.valueOf(string).length()).append("One or more environment variables have been configured in appengine-web.xml that have missing or different values in your local environment. We recommend you use system properties instead, but if you are interacting with legacy code that requires specific environment variables to have specific values, please set these environment variables in your environment before running.\n").append(string).toString();
            if (this.mismatchReportingPolicy == MismatchReportingPolicy.LOG) {
                LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.EnvironmentVariableChecker", "check", msg);
            } else if (this.mismatchReportingPolicy == MismatchReportingPolicy.EXCEPTION) {
                throw new IncorrectEnvironmentVariableException(msg, (List)((Object)mismatches));
            }
        }
    }

    @VisibleForTesting
    public static class IncorrectEnvironmentVariableException
    extends AppEngineConfigException {
        private final List<Mismatch> mismatches;

        private IncorrectEnvironmentVariableException(String msg, List<Mismatch> mismatches) {
            super(msg);
            this.mismatches = mismatches;
        }

        public List<Mismatch> getMismatches() {
            return this.mismatches;
        }
    }

    @VisibleForTesting
    public static class Mismatch {
        private final String environmentVariableName;
        private final String environmentVariableValue;
        private final String appEngineWebXmlValue;
        private final File appEngineWebXmlFile;

        Mismatch(String environmentVariableName, String environmentVariableValue, String appEngineWebXmlValue, File appEngineWebXmlFile) {
            this.environmentVariableName = environmentVariableName;
            this.environmentVariableValue = environmentVariableValue;
            this.appEngineWebXmlValue = appEngineWebXmlValue;
            this.appEngineWebXmlFile = appEngineWebXmlFile;
        }

        public String getEnvironmentVariableName() {
            return this.environmentVariableName;
        }

        public String getEnvironmentVariableValue() {
            return this.environmentVariableValue;
        }

        public String getAppEngineWebXmlValue() {
            return this.appEngineWebXmlValue;
        }

        public File getAppEngineWebXmlFile() {
            return this.appEngineWebXmlFile;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.appEngineWebXmlFile == null ? 0 : this.appEngineWebXmlFile.hashCode());
            result = 31 * result + (this.appEngineWebXmlValue == null ? 0 : this.appEngineWebXmlValue.hashCode());
            result = 31 * result + (this.environmentVariableName == null ? 0 : this.environmentVariableName.hashCode());
            result = 31 * result + (this.environmentVariableValue == null ? 0 : this.environmentVariableValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mismatch other = (Mismatch)obj;
            if (this.appEngineWebXmlFile == null ? other.appEngineWebXmlFile != null : !this.appEngineWebXmlFile.equals(other.appEngineWebXmlFile)) {
                return false;
            }
            if (this.appEngineWebXmlValue == null ? other.appEngineWebXmlValue != null : !this.appEngineWebXmlValue.equals(other.appEngineWebXmlValue)) {
                return false;
            }
            if (this.environmentVariableName == null ? other.environmentVariableName != null : !this.environmentVariableName.equals(other.environmentVariableName)) {
                return false;
            }
            return !(this.environmentVariableValue == null ? other.environmentVariableValue != null : !this.environmentVariableValue.equals(other.environmentVariableValue));
        }

        public String toString() {
            String string = this.environmentVariableName;
            String string2 = this.environmentVariableValue;
            String string3 = this.appEngineWebXmlValue;
            String string4 = String.valueOf(this.appEngineWebXmlFile);
            return new StringBuilder(102 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("Mismatch environmentVariableName=").append(string).append(" environmentVariableValue=").append(string2).append(" appEngineWebXmlValue=").append(string3).append(" appEngineWebXmlFile=").append(string4).toString();
        }
    }

    public static enum MismatchReportingPolicy {
        LOG,
        EXCEPTION,
        NONE;

    }
}

