/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.GetMethod;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.ContainerService;
import com.google.appengine.tools.development.InstanceStateHolder;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebModule;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstanceHelper {
    private static final String X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK = "X-Google-DevAppserver-SkipAdminCheck";
    private static final int AH_REQUEST_INFINITE_TIMEOUT = 0;
    private static final int AH_REQUEST_DEFAULT_TIMEOUT = 30000;
    private static final Logger LOGGER = Logger.getLogger(InstanceHelper.class.getName());
    private final String serverOrBackendName;
    private final int instance;
    private final InstanceStateHolder instanceStateHolder;
    private final ContainerService containerService;

    InstanceHelper(String serverOrBackendName, int instance, InstanceStateHolder instanceStateHolder, ContainerService containerService) {
        this.serverOrBackendName = serverOrBackendName;
        this.instance = instance;
        this.instanceStateHolder = instanceStateHolder;
        this.containerService = containerService;
    }

    void sendStartRequest(final Runnable runOnSuccess) {
        int n;
        String string;
        if (LOGGER.isLoggable(Level.FINER)) {
            string = this.serverOrBackendName;
            n = this.instance;
            LOGGER.logp(Level.FINER, "com.google.appengine.tools.development.InstanceHelper", "sendStartRequest", new StringBuilder(73 + String.valueOf(string).length()).append("Entering send start request for serverOrBackendName=").append(string).append(" instance=").append(n).toString(), new Exception("Start sendStartRequest"));
        }
        if (this.instance < 0) {
            string = this.serverOrBackendName;
            n = this.instance;
            throw new IllegalStateException(new StringBuilder(71 + String.valueOf(string).length()).append("Attempt to send a start request to server/backend ").append(string).append(" instance ").append(n).toString());
        }
        InstanceStateHolder.InstanceState unchangedState = this.instanceStateHolder.testAndSetIf(InstanceStateHolder.InstanceState.RUNNING_START_REQUEST, InstanceStateHolder.InstanceState.SLEEPING);
        if (unchangedState == null) {
            Thread requestThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    InstanceHelper.this.sendStartRequest(0, runOnSuccess);
                }
            });
            requestThread.setDaemon(true);
            int n2 = this.instance;
            String string2 = this.serverOrBackendName;
            requestThread.setName(new StringBuilder(45 + String.valueOf(string2).length()).append("BackendServersStartRequestThread.").append(n2).append(".").append(string2).toString());
            requestThread.start();
        } else if (unchangedState != InstanceStateHolder.InstanceState.RUNNING_START_REQUEST && unchangedState != InstanceStateHolder.InstanceState.RUNNING) {
            InstanceStateHolder.reportInvalidStateChange(this.serverOrBackendName, this.instance, unchangedState, InstanceStateHolder.InstanceState.RUNNING_START_REQUEST, InstanceStateHolder.InstanceState.SLEEPING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStartRequest(int timeoutInMs, Runnable runOnSuccess) {
        try {
            String urlString = String.format("http://%s:%d/_ah/start", this.containerService.getAddress(), this.containerService.getPort());
            String string = String.valueOf(urlString);
            LOGGER.logp(Level.FINER, "com.google.appengine.tools.development.InstanceHelper", "sendStartRequest", string.length() != 0 ? "sending start request to: ".concat(string) : new String("sending start request to: "));
            HttpClient httpClient = new HttpClient();
            httpClient.getParams().setConnectionManagerTimeout((long)timeoutInMs);
            GetMethod request = new GetMethod(urlString);
            request.addRequestHeader(X_GOOGLE_DEV_APPSERVER_SKIPADMINCHECK, "true");
            try {
                int returnCode = httpClient.executeMethod((HttpMethod)request);
                byte[] buffer = new byte[1024];
                InputStream in = request.getResponseBodyAsStream();
                while (in.read(buffer) != -1) {
                }
                if (returnCode >= 200 && returnCode < 300 || returnCode == 404) {
                    LOGGER.logp(Level.FINE, "com.google.appengine.tools.development.InstanceHelper", "sendStartRequest", String.format("backend server %d.%s request to /_ah/start completed, code=%d", this.instance, this.serverOrBackendName, returnCode));
                    this.instanceStateHolder.testAndSet(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.RUNNING_START_REQUEST);
                    runOnSuccess.run();
                } else {
                    int n = this.instance;
                    String string2 = this.serverOrBackendName;
                    LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.InstanceHelper", "sendStartRequest", new StringBuilder(101 + String.valueOf(string2).length()).append("Start request to /_ah/start on server ").append(n).append(".").append(string2).append(" failed (HTTP status code=").append(returnCode).append("). Retrying...").toString());
                    Thread.sleep(1000L);
                    this.sendStartRequest(timeoutInMs, runOnSuccess);
                }
            }
            finally {
                request.releaseConnection();
            }
        }
        catch (MalformedURLException e) {
            LOGGER.logp(Level.SEVERE, "com.google.appengine.tools.development.InstanceHelper", "sendStartRequest", String.format("Unable to send start request to server: %d.%s, MalformedURLException: %s", this.instance, this.serverOrBackendName, e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.InstanceHelper", "sendStartRequest", String.format("Got exception while performing /_ah/start request on server: %d.%s, %s: %s", this.instance, this.serverOrBackendName, e.getClass().getName(), e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerLifecycleShutdownHookImpl() {
        ApiProxy.Environment prevEnvironment = ApiProxy.getCurrentEnvironment();
        try {
            ClassLoader serverClassLoader = this.containerService.getAppContext().getClassLoader();
            Class<?> lifeCycleManagerClass = Class.forName("com.google.appengine.api.LifecycleManager", true, serverClassLoader);
            Method lifeCycleManagerGetter = lifeCycleManagerClass.getMethod("getInstance", new Class[0]);
            Object userThreadLifeCycleManager = lifeCycleManagerGetter.invoke(null, new Object[0]);
            Method beginShutdown = lifeCycleManagerClass.getMethod("beginShutdown", Long.TYPE);
            AppEngineWebXml appEngineWebXml = this.containerService.getAppEngineWebXmlConfig();
            String moduleName = WebModule.getModuleName(appEngineWebXml);
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new AbstractContainerService.LocalInitializationEnvironment(appEngineWebXml.getAppId(), moduleName, appEngineWebXml.getMajorVersionId(), this.instance, this.containerService.getPort()));
            try {
                beginShutdown.invoke(userThreadLifeCycleManager, 30000);
            }
            catch (Exception e) {
                LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.InstanceHelper", "triggerLifecycleShutdownHookImpl", String.format("got exception when running shutdown hook on server %d.%s", this.instance, this.serverOrBackendName));
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            LOGGER.logp(Level.SEVERE, "com.google.appengine.tools.development.InstanceHelper", "triggerLifecycleShutdownHookImpl", String.format("Exception during reflective call to LifecycleManager.beginShutdown on server %d.%s, got %s: %s", this.instance, this.serverOrBackendName, e.getClass().getName(), e.getMessage()));
        }
        finally {
            ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)prevEnvironment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws Exception {
        InstanceStateHolder instanceStateHolder = this.instanceStateHolder;
        synchronized (instanceStateHolder) {
            if (this.instanceStateHolder.test(InstanceStateHolder.InstanceState.RUNNING, InstanceStateHolder.InstanceState.RUNNING_START_REQUEST)) {
                this.triggerLifecycleShutdownHookImpl();
            }
            this.containerService.shutdown();
            this.instanceStateHolder.set(InstanceStateHolder.InstanceState.SHUTDOWN);
        }
    }
}

