/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.ClassLoaderUtil;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.utils.io.IoUtil;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ReflectPermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingPermission;

public class IsolatedAppClassLoader
extends URLClassLoader {
    private static final Logger logger = Logger.getLogger(IsolatedAppClassLoader.class.getName());
    private static final String DEV_APP_SERVER_AGENT = "com.google.appengine.tools.development.agent.AppEngineDevAgent";
    private static final String FILE_READ_ACTION = "read";
    private final PermissionCollection appPermissions;
    private final Permissions appPermissionsAsPermissions;
    private final ClassLoader devAppServerClassLoader;
    private final Set<URL> sharedCodeLibs;
    private final Set<URL> agentRuntimeLibs;

    public IsolatedAppClassLoader(File appRoot, File externalResourceDir, URL[] urls, ClassLoader devAppServerClassLoader) {
        super(urls, ClassLoaderUtil.getPlatformClassLoader());
        IsolatedAppClassLoader.checkWorkingDirectory(appRoot, externalResourceDir);
        this.appPermissions = this.createAppPermissions(appRoot, externalResourceDir);
        this.appPermissionsAsPermissions = new Permissions();
        IsolatedAppClassLoader.addAllPermissions(this.appPermissions, this.appPermissionsAsPermissions);
        this.installPolicyProxy(appRoot);
        this.devAppServerClassLoader = devAppServerClassLoader;
        this.sharedCodeLibs = new HashSet<URL>(AppengineSdk.getSdk().getSharedLibs());
        this.agentRuntimeLibs = new HashSet<URL>(AppengineSdk.getSdk().getAgentRuntimeLibs());
    }

    private static void checkWorkingDirectory(File appRoot, File externalResourceDir) {
        File workingDir = new File(System.getProperty("user.dir"));
        String canonicalWorkingDir = null;
        String canonicalAppRoot = null;
        String canonicalExternalResourceDir = null;
        try {
            canonicalWorkingDir = workingDir.getCanonicalPath();
            canonicalAppRoot = appRoot.getCanonicalPath();
            if (externalResourceDir != null) {
                canonicalExternalResourceDir = externalResourceDir.getCanonicalPath();
            }
        }
        catch (IOException e) {
            logger.logp(Level.FINE, "com.google.appengine.tools.development.IsolatedAppClassLoader", "checkWorkingDirectory", "Unable to compare the working directory and app root.", e);
        }
        if (canonicalWorkingDir != null && !canonicalWorkingDir.equals(canonicalAppRoot)) {
            if (canonicalExternalResourceDir != null && canonicalWorkingDir.equals(canonicalExternalResourceDir)) {
                return;
            }
            String newLine = System.getProperty("line.separator");
            String workDir = workingDir.getAbsolutePath();
            String appDir = appRoot.getAbsolutePath();
            String msg = new StringBuilder(161 + String.valueOf(workDir).length() + String.valueOf(newLine).length() + String.valueOf(appDir).length() + String.valueOf(newLine).length() + String.valueOf(newLine).length()).append("Your working directory, (").append(workDir).append(") is not equal to your ").append(newLine).append("web application root (").append(appDir).append(")").append(newLine).append("You will not be able to access files from your working directory on the production server.").append(newLine).toString();
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.IsolatedAppClassLoader", "checkWorkingDirectory", msg);
        }
    }

    @Override
    public URL getResource(String name) {
        int bang;
        URL resource = this.devAppServerClassLoader.getResource(name);
        if (resource != null && resource.getProtocol().equals("jar") && (bang = resource.getPath().indexOf(33)) > 0) {
            try {
                URL url = new URL(resource.getPath().substring(0, bang));
                if (this.sharedCodeLibs.contains(url)) {
                    return resource;
                }
            }
            catch (MalformedURLException ex) {
                String string = String.valueOf(name);
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.IsolatedAppClassLoader", "getResource", string.length() != 0 ? "Unexpected exception while loading ".concat(string) : new String("Unexpected exception while loading "), ex);
            }
        }
        return super.getResource(name);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            final Class<?> c = this.devAppServerClassLoader.loadClass(name);
            CodeSource source = AccessController.doPrivileged(new PrivilegedAction<CodeSource>(this){

                @Override
                public CodeSource run() {
                    return c.getProtectionDomain().getCodeSource();
                }
            });
            if (source == null) {
                return c;
            }
            URL location = source.getLocation();
            if (this.sharedCodeLibs.contains(location) || location.getFile().endsWith("/appengine-agent.jar") || name.equals(DEV_APP_SERVER_AGENT)) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissions = super.getPermissions(codesource);
        if (this.agentRuntimeLibs.contains(codesource.getLocation())) {
            permissions.add(new AllPermission());
        } else {
            IsolatedAppClassLoader.addAllPermissions(this.appPermissions, permissions);
        }
        return permissions;
    }

    public Permissions getAppPermissions() {
        return this.appPermissionsAsPermissions;
    }

    private PermissionCollection createAppPermissions(File appRoot, File externalResourceDir) {
        Permissions permissions = new Permissions();
        IsolatedAppClassLoader.addAllPermissions(IsolatedAppClassLoader.buildPermissionsToAccessAppFiles(appRoot), permissions);
        if (externalResourceDir != null) {
            IsolatedAppClassLoader.addAllPermissions(IsolatedAppClassLoader.buildPermissionsToAccessAppFiles(externalResourceDir), permissions);
        }
        if (Boolean.valueOf(System.getProperty("--enable_all_permissions")).booleanValue()) {
            ((PermissionCollection)permissions).add(new AllPermission());
            return permissions;
        }
        ((PermissionCollection)permissions).add(new RuntimePermission("getClassLoader"));
        ((PermissionCollection)permissions).add(new RuntimePermission("setContextClassLoader"));
        ((PermissionCollection)permissions).add(new RuntimePermission("createClassLoader"));
        ((PermissionCollection)permissions).add(new RuntimePermission("getProtectionDomain"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessDeclaredMembers"));
        ((PermissionCollection)permissions).add(new ReflectPermission("suppressAccessChecks"));
        ((PermissionCollection)permissions).add(new LoggingPermission("control", ""));
        ((PermissionCollection)permissions).add(new RuntimePermission("getStackTrace"));
        ((PermissionCollection)permissions).add(new RuntimePermission("getenv.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("setIO"));
        ((PermissionCollection)permissions).add(new PropertyPermission("*", "read,write"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.xml.internal.ws.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.xml.internal.ws"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.xml.internal.stream.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.xml.internal.messaging.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.org.apache.xerces.internal.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.org.apache.xalan.internal.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.org.apache.xml.internal.security.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.org.jcp.xml.dsig.internal.*"));
        ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.com.sun.proxy"));
        ((PermissionCollection)permissions).add(new RuntimePermission("loadLibrary.keychain"));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "getMetadata", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "setStateManager", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "manageMetadata", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("javax.jdo.spi.JDOPermission", "closePersistenceManagerFactory", null, null));
        ((PermissionCollection)permissions).add(new UnresolvedPermission("groovy.security.GroovyCodeSourcePermission", "*", null, null));
        String string = System.getProperty("user.dir");
        char c = File.separatorChar;
        ((PermissionCollection)permissions).add(new FilePermission(new StringBuilder(2 + String.valueOf(string).length()).append(string).append(c).append("-").toString(), FILE_READ_ACTION));
        ((PermissionCollection)permissions).add(IsolatedAppClassLoader.getJreReadPermission());
        for (File f : AppengineSdk.getSdk().getSharedLibFiles()) {
            ((PermissionCollection)permissions).add(new FilePermission(f.getAbsolutePath(), FILE_READ_ACTION));
        }
        ((PermissionCollection)permissions).add(new SecurityPermission("putProviderProperty.*"));
        ((PermissionCollection)permissions).add(new SecurityPermission("insertProvider.*"));
        ((PermissionCollection)permissions).add(new SecurityPermission("removeProvider.*"));
        ((PermissionCollection)permissions).add(new SecurityPermission("getProperty.ssl.KeyManagerFactory.algorithm"));
        try {
            Class<?> jaxbPermission = Class.forName("javax.xml.bind.JAXBPermission");
            Constructor<?> constructor = jaxbPermission.getConstructor(String.class);
            ((PermissionCollection)permissions).add((Permission)constructor.newInstance("setDatatypeConverter"));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to load javax.xml.bind.JAXBPermission.");
        }
        permissions.setReadOnly();
        return permissions;
    }

    private void installPolicyProxy(File appRoot) {
        Policy p = Policy.getPolicy();
        if (p instanceof ProxyPolicy) {
            return;
        }
        Policy.setPolicy(new ProxyPolicy(p, appRoot));
    }

    private static PermissionCollection buildPermissionsToAccessAppFiles(File contextRoot) {
        Permissions permissions = new Permissions();
        IsolatedAppClassLoader.addPermissionsToAccessAppFiles(permissions, contextRoot);
        List<File> allFiles = IoUtil.getFilesAndDirectories(contextRoot);
        for (File file : allFiles) {
            IsolatedAppClassLoader.addPermissionsToAccessAppFiles(permissions, file);
        }
        permissions.setReadOnly();
        return permissions;
    }

    private static void addPermissionsToAccessAppFiles(PermissionCollection permissions, File fileOrDirectory) {
        String path = fileOrDirectory.getAbsolutePath();
        permissions.add(new FilePermission(path, FILE_READ_ACTION));
        permissions.add(new FilePermission(String.valueOf(path).concat("/-"), FILE_READ_ACTION));
    }

    private static Permission getReadPermission(URL url) {
        Permission p;
        try {
            URLConnection urlConnection = url.openConnection();
            p = urlConnection.getPermission();
        }
        catch (IOException e) {
            String string = String.valueOf(url);
            throw new RuntimeException(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to obtain the permission for ").append(string).toString(), e);
        }
        return new FilePermission(p.getName(), FILE_READ_ACTION);
    }

    private static Permission getJreReadPermission() {
        return IsolatedAppClassLoader.getReadPermission(Object.class.getResource("/java/lang/Object.class"));
    }

    private static void addAllPermissions(PermissionCollection src, PermissionCollection dest) {
        Enumeration<Permission> srcElements = src.elements();
        while (srcElements.hasMoreElements()) {
            dest.add(srcElements.nextElement());
        }
    }

    class ProxyPolicy
    extends Policy {
        private Policy delegate;
        private File appRoot;

        ProxyPolicy(Policy delegate, File appRoot) {
            this.delegate = delegate;
            this.appRoot = appRoot;
        }

        @Override
        public Provider getProvider() {
            return this.delegate.getProvider();
        }

        @Override
        public String getType() {
            return this.delegate.getType();
        }

        @Override
        public Policy.Parameters getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public PermissionCollection getPermissions(final CodeSource codeSource) {
            return AccessController.doPrivileged(new PrivilegedAction<PermissionCollection>(){

                @Override
                public PermissionCollection run() {
                    PermissionCollection delegatePerms = ProxyPolicy.this.delegate.getPermissions(codeSource);
                    try {
                        if (ProxyPolicy.this.appRoot.toURL().equals(codeSource.getLocation())) {
                            Permissions newPerms = new Permissions();
                            IsolatedAppClassLoader.addAllPermissions(delegatePerms, newPerms);
                            IsolatedAppClassLoader.addAllPermissions(IsolatedAppClassLoader.this.appPermissions, newPerms);
                            return newPerms;
                        }
                    }
                    catch (MalformedURLException ex) {
                        String string = String.valueOf(ProxyPolicy.this.appRoot);
                        throw new RuntimeException(new StringBuilder(25 + String.valueOf(string).length()).append("Could not turn ").append(string).append("into a URL").toString(), ex);
                    }
                    return delegatePerms;
                }
            });
        }

        @Override
        public PermissionCollection getPermissions(ProtectionDomain domain) {
            return this.getPermissions(domain.getCodeSource());
        }

        @Override
        public boolean implies(final ProtectionDomain domain, final Permission permission) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return ProxyPolicy.this.delegate.implies(domain, permission);
                }
            });
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }
    }
}

