/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.log.dev.DevLogHandler;
import com.google.appengine.api.log.dev.LocalLogService;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.development.AbstractContainerService;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppEngineWebAppContext;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.IsolatedAppClassLoader;
import com.google.appengine.tools.development.LocalHttpRequestEnvironment;
import com.google.appengine.tools.development.SerializableObjectsOnlyHashSessionManager;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebModule;
import com.google.apphosting.utils.jetty.JettyLogger;
import com.google.apphosting.utils.jetty.StubSessionManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.HandlerWrapper;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;
import org.mortbay.util.Scanner;

public class JettyContainerService
extends AbstractContainerService {
    private static final Logger log = Logger.getLogger(JettyContainerService.class.getName());
    private static final String FILES_API_DEPRECATION_WARNING = "The Files API is deprecated and will soon be removed. Further information is available  here: https://cloud.google.com/appengine/docs/deprecations/files_api";
    public static final String WEB_DEFAULTS_XML = "com/google/appengine/tools/development/webdefault.xml";
    private static final int MAX_SIMULTANEOUS_API_CALLS = 100;
    private static final Long SOFT_DEADLINE_DELAY_MS = 60000L;
    private static final int HEADER_BUFFER_SIZE = 65536;
    private static final String[] CONFIG_CLASSES = new String[]{"org.mortbay.jetty.webapp.WebXmlConfiguration", "org.mortbay.jetty.webapp.TagLibConfiguration"};
    private static final String WEB_XML_ATTR = "com.google.appengine.tools.development.webXml";
    private static final String APPENGINE_WEB_XML_ATTR = "com.google.appengine.tools.development.appEngineWebXml";
    private boolean disableFilesApiWarning = false;
    private static final int SCAN_INTERVAL_SECONDS = 5;
    private WebAppContext context;
    private AppContext appContext;
    private Server server;
    private Scanner scanner;

    @Override
    protected File initContext() throws IOException {
        this.context = new DevAppEngineWebAppContext(this.appDir, this.externalResourceDir, this.devAppServerVersion, this.apiProxyDelegate, this.devAppServer);
        this.appContext = new JettyAppContext();
        this.context.setDescriptor(this.webXmlLocation == null ? null : this.webXmlLocation.getAbsolutePath());
        String webDefaultXml = this.devAppServer.getServiceProperties().get("appengine.webdefault.xml");
        if (webDefaultXml == null) {
            webDefaultXml = WEB_DEFAULTS_XML;
        }
        this.context.setDefaultsDescriptor(webDefaultXml);
        this.context.setConfigurationClasses(CONFIG_CLASSES);
        File appRoot = this.determineAppRoot();
        this.installLocalInitializationEnvironment();
        URL[] classPath = this.getClassPathForApp(appRoot);
        this.context.setClassLoader(new IsolatedAppClassLoader(appRoot, this.externalResourceDir, classPath, JettyContainerService.class.getClassLoader()));
        if (Boolean.parseBoolean(System.getProperty("appengine.allowRemoteShutdown"))) {
            this.context.addServlet(new ServletHolder((Servlet)new ServerShutdownServlet()), "/_ah/admin/quit");
        }
        if (Boolean.parseBoolean(System.getProperty("appengine.disableFilesApiWarning"))) {
            this.disableFilesApiWarning = true;
        }
        return appRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectContainer() throws Exception {
        this.moduleConfigurationHandle.checkEnvironmentVariables();
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCcl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setHost(this.address);
            connector.setPort(this.port);
            connector.setHeaderBufferSize(65536);
            connector.setSoLingerTime(0);
            connector.open();
            this.server = new Server();
            this.server.addConnector(connector);
            this.port = connector.getLocalPort();
        }
        finally {
            currentThread.setContextClassLoader(previousCcl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startContainer() throws Exception {
        this.context.setAttribute(WEB_XML_ATTR, this.webXml);
        this.context.setAttribute(APPENGINE_WEB_XML_ATTR, this.appEngineWebXml);
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCcl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            ApiProxyHandler apiHandler = new ApiProxyHandler(this.appEngineWebXml);
            apiHandler.setHandler(this.context);
            this.server.setHandler(apiHandler);
            SessionHandler handler = this.context.getSessionHandler();
            if (this.isSessionsEnabled()) {
                handler.setSessionManager(new SerializableObjectsOnlyHashSessionManager());
            } else {
                handler.setSessionManager(new StubSessionManager());
            }
            this.server.start();
        }
        finally {
            currentThread.setContextClassLoader(previousCcl);
        }
    }

    @Override
    protected void stopContainer() throws Exception {
        this.server.stop();
    }

    @Override
    protected void startHotDeployScanner() throws Exception {
        String fullScanInterval = System.getProperty("appengine.fullscan.seconds");
        if (fullScanInterval != null) {
            try {
                int interval = Integer.parseInt(fullScanInterval);
                if (interval < 1) {
                    log.logp(Level.INFO, "com.google.appengine.tools.development.JettyContainerService", "startHotDeployScanner", "Full scan of the web app for changes is disabled.");
                    return;
                }
                log.logp(Level.INFO, "com.google.appengine.tools.development.JettyContainerService", "startHotDeployScanner", new StringBuilder(53).append("Full scan of the web app in place every ").append(interval).append("s.").toString());
                this.fullWebAppScanner(interval);
                return;
            }
            catch (NumberFormatException ex) {
                log.logp(Level.WARNING, "com.google.appengine.tools.development.JettyContainerService", "startHotDeployScanner", "appengine.fullscan.seconds property is not an integer:", ex);
                log.logp(Level.WARNING, "com.google.appengine.tools.development.JettyContainerService", "startHotDeployScanner", "Using the default scanning method.");
            }
        }
        this.scanner = new Scanner();
        this.scanner.setScanInterval(5);
        this.scanner.setScanDirs(ImmutableList.of(this.getScanTarget()));
        this.scanner.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                try {
                    return name.equals(JettyContainerService.this.getScanTarget().getName());
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        this.scanner.scan();
        this.scanner.addListener(new ScannerListener());
        this.scanner.start();
    }

    @Override
    protected void stopHotDeployScanner() throws Exception {
        if (this.scanner != null) {
            this.scanner.stop();
        }
        this.scanner = null;
    }

    private File getScanTarget() throws Exception {
        if (this.appDir.isFile() || this.context.getWebInf() == null) {
            return this.appDir;
        }
        String string = this.context.getWebInf().getFile().getPath();
        String string2 = File.separator;
        return new File(new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append("appengine-web.xml").toString());
    }

    private void fullWebAppScanner(int interval) throws IOException {
        String webInf = this.context.getWebInf().getFile().getPath();
        ArrayList scanList = new ArrayList();
        Collections.addAll(scanList, new File(webInf, "classes"), new File(webInf, "lib"), new File(webInf, "web.xml"), new File(webInf, "appengine-web.xml"));
        this.scanner = new Scanner();
        this.scanner.setScanInterval(interval);
        this.scanner.setScanDirs(scanList);
        this.scanner.setReportExistingFilesOnStartup(false);
        this.scanner.setRecursive(true);
        this.scanner.scan();
        this.scanner.addListener(new Scanner.BulkListener(){

            @Override
            public void filesChanged(List changedFiles) throws Exception {
                log.logp(Level.INFO, "com.google.appengine.tools.development.JettyContainerService$2", "filesChanged", "A file has changed, reloading the web application.");
                JettyContainerService.this.reloadWebApp();
            }
        });
        this.scanner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reloadWebApp() throws Exception {
        this.server.getHandler().stop();
        this.moduleConfigurationHandle.restoreSystemProperties();
        this.moduleConfigurationHandle.readConfiguration();
        this.moduleConfigurationHandle.checkEnvironmentVariables();
        this.extractFieldsFromWebModule(this.moduleConfigurationHandle.getModule());
        Thread currentThread = Thread.currentThread();
        ClassLoader previousCcl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(null);
        try {
            this.initContext();
            this.installLocalInitializationEnvironment();
            if (!this.isSessionsEnabled()) {
                this.context.getSessionHandler().setSessionManager(new StubSessionManager());
            }
            this.context.setAttribute(WEB_XML_ATTR, this.webXml);
            this.context.setAttribute(APPENGINE_WEB_XML_ATTR, this.appEngineWebXml);
            ApiProxyHandler apiHandler = new ApiProxyHandler(this.appEngineWebXml);
            apiHandler.setHandler(this.context);
            this.server.setHandler(apiHandler);
            apiHandler.start();
        }
        finally {
            currentThread.setContextClassLoader(previousCcl);
        }
    }

    @Override
    public AppContext getAppContext() {
        return this.appContext;
    }

    @Override
    public void forwardToServer(HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        String string = this.appEngineWebXml.getModule();
        int n = this.instance;
        log.logp(Level.FINEST, "com.google.appengine.tools.development.JettyContainerService", "forwardToServer", new StringBuilder(42 + String.valueOf(string).length()).append("forwarding request to module: ").append(string).append(".").append(n).toString());
        RequestDispatcher requestDispatcher = this.context.getServletContext().getRequestDispatcher(hrequest.getRequestURI());
        requestDispatcher.forward((ServletRequest)hrequest, (ServletResponse)hresponse);
    }

    private File determineAppRoot() throws IOException {
        Resource webInf = this.context.getWebInf();
        if (webInf == null) {
            if (this.userCodeClasspathManager.requiresWebInf()) {
                throw new AppEngineConfigException("Supplied application has to contain WEB-INF directory.");
            }
            return this.appDir;
        }
        return webInf.getFile().getParentFile();
    }

    static {
        System.setProperty("org.mortbay.log.class", JettyLogger.class.getName());
    }

    private class RecordingResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;

        RecordingResponseWrapper(JettyContainerService jettyContainerService, HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            this.status = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.status;
        }

        public void sendError(int sc) throws IOException {
            this.status = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.status = sc;
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.status = 302;
            super.sendRedirect(location);
        }

        public void setStatus(int status, String string) {
            super.setStatus(status, string);
            this.status = status;
        }

        public void reset() {
            super.reset();
            this.status = 200;
        }
    }

    private class ApiProxyHandler
    extends HandlerWrapper {
        private final AppEngineWebXml appEngineWebXml;

        ApiProxyHandler(AppEngineWebXml appEngineWebXml) {
            this.appEngineWebXml = appEngineWebXml;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (dispatch == 1) {
                long startTimeUsec = System.currentTimeMillis() * 1000L;
                Semaphore semaphore = new Semaphore(100);
                LocalHttpRequestEnvironment env = new LocalHttpRequestEnvironment(this.appEngineWebXml.getAppId(), WebModule.getModuleName(this.appEngineWebXml), this.appEngineWebXml.getMajorVersionId(), JettyContainerService.this.instance, JettyContainerService.this.getPort(), request, SOFT_DEADLINE_DELAY_MS, JettyContainerService.this.modulesFilterHelper);
                env.getAttributes().put("com.google.appengine.tools.development.api_call_semaphore", semaphore);
                int n = JettyContainerService.this.devAppServer.getPort();
                env.getAttributes().put("com.google.appengine.runtime.default_version_hostname", new StringBuilder(21).append("localhost:").append(n).toString());
                env.getAttributes().put("com.google.appengine.api.files.filesapi_was_used", false);
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)env);
                RecordingResponseWrapper wrappedResponse = new RecordingResponseWrapper(JettyContainerService.this, response);
                try {
                    super.handle(target, request, (HttpServletResponse)wrappedResponse, dispatch);
                    if (!request.getRequestURI().startsWith("/_ah/reloadwebapp")) return;
                    try {
                        JettyContainerService.this.reloadWebApp();
                        String string = String.valueOf(request.getParameter("info"));
                        log.logp(Level.INFO, "com.google.appengine.tools.development.JettyContainerService$ApiProxyHandler", "handle", string.length() != 0 ? "Reloaded the webapp context: ".concat(string) : new String("Reloaded the webapp context: "));
                        return;
                    }
                    catch (Exception ex) {
                        log.logp(Level.WARNING, "com.google.appengine.tools.development.JettyContainerService$ApiProxyHandler", "handle", "Failed to reload the current webapp context.", ex);
                    }
                    return;
                }
                finally {
                    try {
                        semaphore.acquire(100);
                    }
                    catch (InterruptedException ex) {
                        log.logp(Level.WARNING, "com.google.appengine.tools.development.JettyContainerService$ApiProxyHandler", "handle", "Interrupted while waiting for API calls to complete:", ex);
                    }
                    env.callRequestEndListeners();
                    if (JettyContainerService.this.apiProxyDelegate instanceof ApiProxyLocal) {
                        ApiProxyLocal apiProxyLocal = (ApiProxyLocal)JettyContainerService.this.apiProxyDelegate;
                        try {
                            String appId = env.getAppId();
                            String versionId = env.getVersionId();
                            String requestId = DevLogHandler.getRequestId();
                            long endTimeUsec = new Date().getTime() * 1000L;
                            LocalLogService logService = (LocalLogService)apiProxyLocal.getService("logservice");
                            if (!JettyContainerService.this.disableFilesApiWarning && ((Boolean)env.getAttributes().get("com.google.appengine.api.files.filesapi_was_used")).booleanValue()) {
                                log.logp(Level.WARNING, "com.google.appengine.tools.development.JettyContainerService$ApiProxyHandler", "handle", JettyContainerService.FILES_API_DEPRECATION_WARNING);
                            }
                            logService.addRequestInfo(appId, versionId, requestId, request.getRemoteAddr(), request.getRemoteUser(), startTimeUsec, endTimeUsec, request.getMethod(), request.getRequestURI(), request.getProtocol(), request.getHeader("User-Agent"), true, Integer.valueOf(wrappedResponse.getStatus()), request.getHeader("Referer"));
                            logService.clearResponseSize();
                        }
                        finally {
                            ApiProxy.clearEnvironmentForCurrentThread();
                        }
                    }
                }
            }
            super.handle(target, request, response, dispatch);
        }
    }

    private class ScannerListener
    implements Scanner.DiscreteListener {
        private ScannerListener() {
        }

        @Override
        public void fileAdded(String filename) throws Exception {
            this.fileChanged(filename);
        }

        @Override
        public void fileChanged(String filename) throws Exception {
            log.logp(Level.INFO, "com.google.appengine.tools.development.JettyContainerService$ScannerListener", "fileChanged", String.valueOf(filename).concat(" updated, reloading the webapp!"));
            JettyContainerService.this.reloadWebApp();
        }

        @Override
        public void fileRemoved(String filename) throws Exception {
        }
    }

    static class ServerShutdownServlet
    extends HttpServlet {
        ServerShutdownServlet() {
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            resp.getWriter().println("Shutting down local server.");
            resp.flushBuffer();
            DevAppServer server = (DevAppServer)this.getServletContext().getAttribute("com.google.appengine.devappserver.Server");
            server.gracefulShutdown();
        }
    }

    private class JettyAppContext
    implements AppContext {
        private JettyAppContext() {
        }

        @Override
        public IsolatedAppClassLoader getClassLoader() {
            return (IsolatedAppClassLoader)JettyContainerService.this.context.getClassLoader();
        }

        @Override
        public Permissions getUserPermissions() {
            return JettyContainerService.this.getUserPermissions();
        }

        @Override
        public Permissions getApplicationPermissions() {
            return this.getClassLoader().getAppPermissions();
        }

        @Override
        public Object getContainerContext() {
            return JettyContainerService.this.context;
        }
    }
}

