/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.StaticFileUtils;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebXml;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

public class LocalResourceFileServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(LocalResourceFileServlet.class.getName());
    private StaticFileUtils staticFileUtils;
    private Resource resourceBase;
    private String[] welcomeFiles;
    private String resourceRoot;

    public void init() throws ServletException {
        ContextHandler.SContext context = (ContextHandler.SContext)this.getServletContext();
        this.staticFileUtils = new StaticFileUtils(context);
        this.welcomeFiles = context.getContextHandler().getWelcomeFiles();
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        this.resourceRoot = appEngineWebXml.getPublicRoot();
        try {
            String string = String.valueOf("/");
            String string2 = String.valueOf(this.resourceRoot);
            this.resourceBase = context.getContextHandler().getResource(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        catch (MalformedURLException ex) {
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.LocalResourceFileServlet", "init", "Could not initialize:", ex);
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInContext;
        String pathInfo;
        String servletPath;
        Boolean included;
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        WebXml webXml = (WebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.webXml");
        Boolean forwarded = (Boolean)request.getAttribute("org.mortbay.jetty.forwarded");
        if (forwarded == null) {
            forwarded = Boolean.FALSE;
        }
        if ((included = (Boolean)request.getAttribute("org.mortbay.jetty.included")) != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
        }
        if (this.maybeServeWelcomeFile(pathInContext = URIUtil.addPaths(servletPath, pathInfo), included, request, response)) {
            return;
        }
        Resource resource = null;
        try {
            resource = this.getResource(pathInContext);
            if (resource != null && resource.isDirectory()) {
                if (included.booleanValue() || this.staticFileUtils.passConditionalHeaders(request, response, resource)) {
                    response.sendError(403);
                }
            } else if (resource == null || !resource.exists()) {
                String string = String.valueOf(pathInContext);
                logger.logp(Level.WARNING, "com.google.appengine.tools.development.LocalResourceFileServlet", "doGet", string.length() != 0 ? "No file found for: ".concat(string) : new String("No file found for: "));
                response.sendError(404);
            } else {
                String string = String.valueOf(this.resourceRoot);
                String string2 = String.valueOf(pathInContext);
                boolean isStatic = appEngineWebXml.includesStatic(string2.length() != 0 ? string.concat(string2) : new String(string));
                String string3 = String.valueOf(this.resourceRoot);
                String string4 = String.valueOf(pathInContext);
                boolean isResource = appEngineWebXml.includesResource(string4.length() != 0 ? string3.concat(string4) : new String(string3));
                boolean usesRuntime = webXml.matches(pathInContext);
                Boolean isWelcomeFile = (Boolean)request.getAttribute("com.google.appengine.tools.development.isWelcomeFile");
                if (isWelcomeFile == null) {
                    isWelcomeFile = false;
                }
                if (!(isStatic || usesRuntime || included.booleanValue() || forwarded.booleanValue())) {
                    logger.logp(Level.WARNING, "com.google.appengine.tools.development.LocalResourceFileServlet", "doGet", new StringBuilder(93 + String.valueOf(pathInContext).length()).append("Can not serve ").append(pathInContext).append(" directly.  You need to include it in <static-files> in your appengine-web.xml.").toString());
                    response.sendError(404);
                    return;
                }
                if (!isResource && !isWelcomeFile.booleanValue() && (included.booleanValue() || forwarded.booleanValue())) {
                    logger.logp(Level.WARNING, "com.google.appengine.tools.development.LocalResourceFileServlet", "doGet", new StringBuilder(114 + String.valueOf(pathInContext).length()).append("Could not serve ").append(pathInContext).append(" from a forward or include.  You need to include it in <resource-files> in your appengine-web.xml.").toString());
                    response.sendError(404);
                    return;
                }
                if (included.booleanValue() || this.staticFileUtils.passConditionalHeaders(request, response, resource)) {
                    this.staticFileUtils.sendData(request, response, included, resource);
                }
            }
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(405);
    }

    private Resource getResource(String pathInContext) {
        try {
            if (this.resourceBase != null) {
                return this.resourceBase.addPath(pathInContext);
            }
        }
        catch (IOException ex) {
            String string = String.valueOf(pathInContext);
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.LocalResourceFileServlet", "getResource", string.length() != 0 ? "Could not find: ".concat(string) : new String("Could not find: "), ex);
        }
        return null;
    }

    private boolean maybeServeWelcomeFile(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.welcomeFiles == null) {
            return false;
        }
        if (!path.endsWith("/")) {
            String string = String.valueOf(path);
            String string2 = String.valueOf("/");
            path = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        AppEngineWebXml appEngineWebXml = (AppEngineWebXml)this.getServletContext().getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        ContextHandler.SContext context = (ContextHandler.SContext)this.getServletContext();
        ServletHandler handler = ((Context)context.getContextHandler()).getServletHandler();
        PathMap.Entry defaultEntry = handler.getHolderEntry("/");
        PathMap.Entry jspEntry = handler.getHolderEntry("/foo.jsp");
        for (String welcomeName : this.welcomeFiles) {
            RequestDispatcher namedDispatcher;
            String string = String.valueOf(path);
            String string3 = String.valueOf(welcomeName);
            String welcomePath = string3.length() != 0 ? string.concat(string3) : new String(string);
            String relativePath = welcomePath.substring(1);
            PathMap.Entry entry = handler.getHolderEntry(welcomePath);
            if (entry != defaultEntry && entry != jspEntry) {
                String string4 = String.valueOf(path);
                String string5 = String.valueOf(welcomeName);
                RequestDispatcher dispatcher = request.getRequestDispatcher(string5.length() != 0 ? string4.concat(string5) : new String(string4));
                return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, included, request, response);
            }
            String string6 = String.valueOf(path);
            String string7 = String.valueOf(welcomeName);
            Resource welcomeFile = this.getResource(string7.length() != 0 ? string6.concat(string7) : new String(string6));
            if (welcomeFile != null && welcomeFile.exists()) {
                RequestDispatcher dispatcher;
                if (entry != defaultEntry) {
                    String string8 = String.valueOf(path);
                    String string9 = String.valueOf(welcomeName);
                    dispatcher = request.getRequestDispatcher(string9.length() != 0 ? string8.concat(string9) : new String(string8));
                    return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
                if (appEngineWebXml.includesResource(relativePath)) {
                    String string10 = String.valueOf(path);
                    String string11 = String.valueOf(welcomeName);
                    dispatcher = request.getRequestDispatcher(string11.length() != 0 ? string10.concat(string11) : new String(string10));
                    return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, included, request, response);
                }
            }
            if ((namedDispatcher = context.getNamedDispatcher(welcomeName)) == null) continue;
            return this.staticFileUtils.serveWelcomeFileAsForward(namedDispatcher, included, request, response);
        }
        return false;
    }
}

