/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.servlet.JspServlet;

public class PrivilegedJspServlet
extends JspServlet {
    private static final String JASPER_JSP_FILE = "org.apache.catalina.jsp_file";

    public void init(final ServletConfig config) throws ServletException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ServletException {
                    PrivilegedJspServlet.super.init(config);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception cause = ex.getException();
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    public void service(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        this.fixupJspFileAttribute(request);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, ServletException {
                    PrivilegedJspServlet.super.service(request, response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Exception cause = ex.getException();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private void fixupJspFileAttribute(HttpServletRequest request) {
        String jspFile = (String)request.getAttribute(JASPER_JSP_FILE);
        if (jspFile != null) {
            if (jspFile.length() == 0) {
                jspFile = "/";
            } else if (jspFile.charAt(0) != '/') {
                String string = String.valueOf(jspFile);
                jspFile = string.length() != 0 ? "/".concat(string) : new String("/");
            }
            request.setAttribute(JASPER_JSP_FILE, (Object)jspFile);
        }
    }
}

