/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.DevSocketImplFactory;
import com.google.appengine.tools.development.RequestEndListener;
import com.google.appengine.tools.development.RequestEndListenerHelper;
import com.google.apphosting.api.ApiProxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestThreadFactory
implements ThreadFactory {
    private static final Logger logger = Logger.getLogger(RequestThreadFactory.class.getName());
    private static final int THREAD_STARTUP_LATENCY_MS = 20;
    private static final int ONLINE_REQUEST_DEADLINE_MS = 60000;
    private static final int OFFLINE_REQUEST_DEADLINE_MS = 600000;

    @Override
    public Thread newThread(final Runnable runnable) {
        final boolean callerNativeMode = DevSocketImplFactory.isNativeSocketMode();
        final AccessControlContext context = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                final ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
                DevSocketImplFactory.setSocketNativeMode(callerNativeMode);
                Thread thread = new Thread(){

                    @Override
                    public void start() {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException ex) {
                            logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1", "start", "Interrupted while simulating thread startup latency", ex);
                            Thread.currentThread().interrupt();
                        }
                        super.start();
                        final 1 thread = this;
                        RequestEndListenerHelper.register(new RequestEndListener(){

                            @Override
                            public void onRequestEnd(ApiProxy.Environment environment) {
                                if (thread.isAlive()) {
                                    String string = String.valueOf(thread);
                                    logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", new StringBuilder(29 + String.valueOf(string).length()).append("Interrupting request thread: ").append(string).toString());
                                    thread.interrupt();
                                    string = String.valueOf(thread);
                                    logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", new StringBuilder(44 + String.valueOf(string).length()).append("Waiting up to 100ms for thread to complete: ").append(string).toString());
                                    try {
                                        thread.join(100L);
                                    }
                                    catch (InterruptedException ex) {
                                        logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", "Interrupted while waiting.");
                                    }
                                    if (thread.isAlive()) {
                                        string = String.valueOf(thread);
                                        logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", new StringBuilder(35 + String.valueOf(string).length()).append("Interrupting request thread again: ").append(string).toString());
                                        thread.interrupt();
                                        long remaining = RequestThreadFactory.this.getRemainingDeadlineMillis(environment);
                                        String string2 = String.valueOf(thread);
                                        logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", new StringBuilder(62 + String.valueOf(string2).length()).append("Waiting up to ").append(remaining).append(" ms for thread to complete: ").append(string2).toString());
                                        try {
                                            thread.join(remaining);
                                        }
                                        catch (InterruptedException ex) {
                                            logger.logp(Level.INFO, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", "Interrupted while waiting.");
                                        }
                                        if (thread.isAlive()) {
                                            Throwable stack = new Throwable();
                                            stack.setStackTrace(thread.getStackTrace());
                                            String string3 = String.valueOf(thread);
                                            logger.logp(Level.SEVERE, "com.google.appengine.tools.development.RequestThreadFactory$1$1$1", "onRequestEnd", new StringBuilder(74 + String.valueOf(string3).length()).append("Thread left running: ").append(string3).append(".  In production this will cause the request to fail.").toString(), stack);
                                        }
                                    }
                                }
                            }
                        });
                    }

                    @Override
                    public void run() {
                        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)environment);
                        AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                runnable.run();
                                return null;
                            }
                        }, context);
                    }
                };
                String string = String.valueOf(thread.getName());
                System.setProperty(string.length() != 0 ? "devappserver-thread-".concat(string) : new String("devappserver-thread-"), "true");
                return thread;
            }
        });
    }

    private long getRemainingDeadlineMillis(ApiProxy.Environment environment) {
        Boolean offline;
        Map attributes = environment.getAttributes();
        Date startTime = (Date)attributes.get("com.google.appengine.tools.development.start_time");
        if (startTime != null) {
            startTime = new Date();
        }
        int requestTimeMillis = (offline = (Boolean)attributes.get("com.google.appengine.request.offline")) != null && offline != false ? 600000 : 60000;
        return (long)requestTimeMillis - (System.currentTimeMillis() - startTime.getTime());
    }
}

