/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.StaticFileUtils;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

public class StaticFileFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(StaticFileFilter.class.getName());
    private StaticFileUtils staticFileUtils;
    private AppEngineWebXml appEngineWebXml;
    private Resource resourceBase;
    private String[] welcomeFiles;
    private String resourceRoot;
    private ContextHandler.SContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = (ContextHandler.SContext)filterConfig.getServletContext();
        this.staticFileUtils = new StaticFileUtils(this.servletContext);
        this.welcomeFiles = this.servletContext.getContextHandler().getWelcomeFiles();
        this.appEngineWebXml = (AppEngineWebXml)this.servletContext.getAttribute("com.google.appengine.tools.development.appEngineWebXml");
        this.resourceRoot = this.appEngineWebXml.getPublicRoot();
        try {
            String string = String.valueOf("/");
            String string2 = String.valueOf(this.resourceRoot);
            this.resourceBase = this.servletContext.getContextHandler().getResource(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        catch (MalformedURLException ex) {
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.StaticFileFilter", "init", "Could not initialize:", ex);
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        String pathInfo;
        Boolean included;
        Boolean forwarded = (Boolean)request.getAttribute("org.mortbay.jetty.forwarded");
        if (forwarded == null) {
            forwarded = Boolean.FALSE;
        }
        if ((included = (Boolean)request.getAttribute("org.mortbay.jetty.included")) == null) {
            included = Boolean.FALSE;
        }
        if (forwarded.booleanValue() || included.booleanValue()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String servletPath = httpRequest.getServletPath();
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo = httpRequest.getPathInfo());
        if (this.maybeServeWelcomeFile(pathInContext, httpRequest, httpResponse)) {
            return;
        }
        Resource resource = null;
        try {
            resource = this.getResource(pathInContext);
            if (resource != null && resource.exists() && !resource.isDirectory()) {
                String string = String.valueOf(this.resourceRoot);
                String string2 = String.valueOf(pathInContext);
                if (this.appEngineWebXml.includesStatic(string2.length() != 0 ? string.concat(string2) : new String(string))) {
                    if (this.staticFileUtils.passConditionalHeaders(httpRequest, httpResponse, resource)) {
                        this.staticFileUtils.sendData(httpRequest, httpResponse, false, resource);
                    }
                    return;
                }
            }
        }
        finally {
            if (resource != null) {
                resource.release();
            }
        }
        chain.doFilter(request, response);
    }

    private Resource getResource(String pathInContext) {
        try {
            if (this.resourceBase != null) {
                return this.resourceBase.addPath(pathInContext);
            }
        }
        catch (IOException ex) {
            String string = String.valueOf(pathInContext);
            logger.logp(Level.WARNING, "com.google.appengine.tools.development.StaticFileFilter", "getResource", string.length() != 0 ? "Could not find: ".concat(string) : new String("Could not find: "), ex);
        }
        return null;
    }

    private boolean maybeServeWelcomeFile(String path, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.welcomeFiles == null) {
            return false;
        }
        if (!path.endsWith("/")) {
            String string = String.valueOf(path);
            String string2 = String.valueOf("/");
            path = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        for (String welcomeName : this.welcomeFiles) {
            String string = String.valueOf(path);
            String string3 = String.valueOf(welcomeName);
            final String welcomePath = string3.length() != 0 ? string.concat(string3) : new String(string);
            String string4 = String.valueOf(path);
            String string5 = String.valueOf(welcomeName);
            Resource welcomeFile = this.getResource(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            if (welcomeFile == null || !welcomeFile.exists()) continue;
            String string6 = String.valueOf(this.resourceRoot);
            String string7 = String.valueOf(welcomePath);
            if (!this.appEngineWebXml.includesStatic(string7.length() != 0 ? string6.concat(string7) : new String(string6))) continue;
            RequestDispatcher dispatcher = this.servletContext.getNamedDispatcher("_ah_default");
            request = new HttpServletRequestWrapper(this, (HttpServletRequest)request){

                public String getServletPath() {
                    return welcomePath;
                }

                public String getPathInfo() {
                    return "";
                }
            };
            return this.staticFileUtils.serveWelcomeFileAsForward(dispatcher, false, (HttpServletRequest)request, response);
        }
        return false;
    }

    public void destroy() {
    }
}

