/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpClient;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.PostMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.methods.RequestEntity;
import com.google.appengine.tools.remoteapi.RemoteApiException;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    private final RemoteApiOptions options;
    private final HttpClient httpClient;
    private int rpcCount = 0;

    RemoteRpc(RemoteApiOptions options) {
        this.options = options;
        this.httpClient = new HttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] call(String serviceName, String methodName, String requestId, byte[] request) {
        logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: {0}.{1}", new Object[]{serviceName, methodName});
        long startTime = System.currentTimeMillis();
        try {
            RemoteApiPb.Request requestProto = RemoteRpc.makeRequest(serviceName, methodName, requestId, request);
            RemoteApiPb.Response responseProto = this.callImpl(requestProto);
            if (responseProto.hasJavaException()) {
                logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: failed due to a server-side Java exception");
                Throwable exception = RemoteRpc.parseJavaException(responseProto, requestProto.getServiceName(), requestProto.getMethod());
                throw new RemoteApiException("response was an exception", requestProto.getServiceName(), requestProto.getMethod(), exception);
            }
            if (responseProto.hasException()) {
                String pickle = responseProto.getException();
                logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: failed due to a server-side Python exception:\n{0}", pickle);
                String string = String.valueOf(pickle);
                throw new RemoteApiException(string.length() != 0 ? "response was a python exception:\n".concat(string) : new String("response was a python exception:\n"), requestProto.getServiceName(), requestProto.getMethod(), null);
            }
            byte[] byArray = responseProto.getResponseAsBytes();
            return byArray;
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "call", "remote API call: took {0} ms", elapsedTime);
        }
    }

    RemoteApiPb.Response callImpl(RemoteApiPb.Request requestProto) {
        ++this.rpcCount;
        byte[] requestBytes = requestProto.toByteArray();
        String string = this.options.getHostname();
        int n = this.options.getPort();
        String string2 = this.options.getRemoteApiPath();
        String url = new StringBuilder(19 + String.valueOf(string).length() + String.valueOf(string2).length()).append("http://").append(string).append(":").append(n).append(string2).toString();
        PostMethod post = new PostMethod(url);
        post.setFollowRedirects(false);
        post.addRequestHeader("Host", this.options.getHostname());
        post.addRequestHeader("X-appcfg-api-version", "1");
        post.addRequestHeader("Content-Type", "application/octet-stream");
        post.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(requestBytes));
        try {
            this.httpClient.executeMethod((HttpMethod)post);
            if (post.getStatusCode() != 200) {
                n = post.getStatusCode();
                throw RemoteRpc.makeException(new StringBuilder(37).append("unexpected HTTP response: ").append(n).toString(), null, requestProto);
            }
            RemoteApiPb.Response parsedResponse = new RemoteApiPb.Response();
            byte[] body = post.getResponseBody(this.options.getMaxHttpResponseSize());
            boolean parsed = parsedResponse.parseFrom(body);
            if (!parsed || !parsedResponse.isInitialized()) {
                throw RemoteRpc.makeException("Could not parse Remote API response", null, requestProto);
            }
            return parsedResponse;
        }
        catch (IOException e) {
            throw RemoteRpc.makeException("I/O error", e, requestProto);
        }
    }

    void resetRpcCount() {
        this.rpcCount = 0;
    }

    int getRpcCount() {
        return this.rpcCount;
    }

    private static RemoteApiPb.Request makeRequest(String packageName, String methodName, String requestId, byte[] payload) {
        RemoteApiPb.Request result = new RemoteApiPb.Request();
        result.setServiceName(packageName);
        result.setMethod(methodName);
        result.setRequestAsBytes(payload);
        result.setRequestId(requestId);
        return result;
    }

    private static Throwable parseJavaException(RemoteApiPb.Response parsedResponse, String packageName, String methodName) {
        try {
            ByteArrayInputStream ins = new ByteArrayInputStream(parsedResponse.getJavaExceptionAsBytes());
            ObjectInputStream in = new ObjectInputStream(ins);
            return (Throwable)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RemoteApiException("remote API call: can't deserialize server-side exception", packageName, methodName, (Throwable)e);
        }
    }

    private static RemoteApiException makeException(String message, Throwable cause, RemoteApiPb.Request request) {
        logger.logp(Level.FINE, "com.google.appengine.tools.development.devappserver2.RemoteRpc", "makeException", "remote API call: {0}", message);
        String string = String.valueOf(message);
        return new RemoteApiException(string.length() != 0 ? "remote API call: ".concat(string) : new String("remote API call: "), request.getServiceName(), request.getMethod(), cause);
    }
}

