/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty9;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public class AppEngineAuthentication {
    private static final Logger log = Logger.getLogger(AppEngineAuthentication.class.getName());
    private static final String AUTH_URL_PREFIX = "/_ah/";
    private static final String AUTH_METHOD = "Google Login";
    private static final String REALM_NAME = "Google App Engine";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";
    private static final String USER_ROLE = "*";
    private static final String ADMIN_ROLE = "admin";

    public static void configureSecurityHandler(ConstraintSecurityHandler handler) {
        AppEngineLoginService loginService = new AppEngineLoginService();
        AppEngineAuthenticator authenticator = new AppEngineAuthenticator();
        DefaultIdentityService identityService = new DefaultIdentityService();
        handler.setRoles(new HashSet<String>(Arrays.asList(USER_ROLE, ADMIN_ROLE)));
        handler.setLoginService((LoginService)loginService);
        handler.setAuthenticator((Authenticator)authenticator);
        handler.setIdentityService((IdentityService)identityService);
        authenticator.setConfiguration((Authenticator.AuthConfiguration)handler);
    }

    private static String getFullURL(HttpServletRequest request) {
        StringBuffer buffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            buffer.append('?');
            buffer.append(request.getQueryString());
        }
        return buffer.toString();
    }

    public static class AppEngineUserIdentity
    implements UserIdentity {
        private final AppEnginePrincipal userPrincipal;

        public AppEngineUserIdentity(AppEnginePrincipal userPrincipal) {
            this.userPrincipal = userPrincipal;
        }

        public Subject getSubject() {
            log.logp(Level.INFO, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineUserIdentity", "getSubject", "getSubject() throwing UnsupportedOperationException.");
            throw new UnsupportedOperationException();
        }

        public Principal getUserPrincipal() {
            return this.userPrincipal;
        }

        public boolean isUserInRole(String role, UserIdentity.Scope unusedScope) {
            UserService userService = UserServiceFactory.getUserService();
            String string = String.valueOf(this.userPrincipal);
            log.logp(Level.FINE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(role).length()).append("Checking if principal ").append(string).append(" is in role ").append(role).toString());
            if (this.userPrincipal == null) {
                log.logp(Level.INFO, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", "isUserInRole() called with null principal.");
                return false;
            }
            if (AppEngineAuthentication.USER_ROLE.equals(role)) {
                return true;
            }
            if (AppEngineAuthentication.ADMIN_ROLE.equals(role)) {
                User user = this.userPrincipal.getUser();
                if (user.equals((Object)userService.getCurrentUser())) {
                    return userService.isUserAdmin();
                }
                String string2 = String.valueOf(user);
                log.logp(Level.SEVERE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", new StringBuilder(47 + String.valueOf(string2).length()).append("Cannot tell if non-logged-in user ").append(string2).append(" is an admin.").toString());
                return false;
            }
            log.logp(Level.WARNING, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineUserIdentity", "isUserInRole", new StringBuilder(15 + String.valueOf(role).length()).append("Unknown role: ").append(role).append(".").toString());
            return false;
        }

        public String toString() {
            String string = AppEngineUserIdentity.class.getSimpleName();
            String string2 = String.valueOf(this.userPrincipal);
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("('").append(string2).append("')").toString();
        }
    }

    public static class AppEnginePrincipal
    implements Principal {
        private final User user;

        public AppEnginePrincipal(User user) {
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }

        @Override
        public String getName() {
            if (this.user.getFederatedIdentity() != null && this.user.getFederatedIdentity().length() > 0) {
                return this.user.getFederatedIdentity();
            }
            return this.user.getEmail();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof AppEnginePrincipal) {
                return this.user.equals((Object)((AppEnginePrincipal)other).user);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.user.toString();
        }

        @Override
        public int hashCode() {
            return this.user.hashCode();
        }
    }

    private static class AppEngineLoginService
    implements LoginService {
        private IdentityService identityService;

        private AppEngineLoginService() {
        }

        public String getName() {
            return AppEngineAuthentication.REALM_NAME;
        }

        public UserIdentity login(String unusedUsername, Object unusedCredentials, ServletRequest unusedRequest) {
            AppEngineUserIdentity appEngineUserIdentity = this.loadUser();
            return appEngineUserIdentity;
        }

        private AppEngineUserIdentity loadUser() {
            UserService userService = UserServiceFactory.getUserService();
            User engineUser = userService.getCurrentUser();
            if (engineUser == null) {
                return null;
            }
            return new AppEngineUserIdentity(new AppEnginePrincipal(engineUser));
        }

        public IdentityService getIdentityService() {
            return this.identityService;
        }

        public void logout(UserIdentity user) {
            if (user != null) {
                String string = String.valueOf(user);
                log.logp(Level.FINE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineLoginService", "logout", new StringBuilder(26 + String.valueOf(string).length()).append("Ignoring logout call for: ").append(string).toString());
            }
        }

        public void setIdentityService(IdentityService identityService) {
            this.identityService = identityService;
        }

        public boolean validate(UserIdentity user) {
            String string = String.valueOf(user);
            log.logp(Level.INFO, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineLoginService", "validate", new StringBuilder(50 + String.valueOf(string).length()).append("validate(").append(string).append(") throwing UnsupportedOperationException.").toString());
            throw new UnsupportedOperationException();
        }
    }

    private static class AppEngineAuthenticator
    extends LoginAuthenticator {
        private AppEngineAuthenticator() {
        }

        private static boolean isLoginOrErrorPage(String uri) {
            return uri.indexOf(AppEngineAuthentication.AUTH_URL_PREFIX) == 0;
        }

        public String getAuthMethod() {
            return AppEngineAuthentication.AUTH_METHOD;
        }

        public Authentication validateRequest(ServletRequest servletRequest, ServletResponse servletResponse, boolean mandatory) throws ServerAuthException {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            if (!mandatory) {
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            String uri = request.getRequestURI();
            if (uri == null) {
                uri = "/";
            }
            if (AppEngineAuthenticator.isLoginOrErrorPage(uri) && !DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                String string = uri;
                log.logp(Level.FINE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", new StringBuilder(78 + String.valueOf(string).length()).append("Got ").append(string).append(", returning DeferredAuthentication to imply authentication is in progress.").toString());
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            if (request.getAttribute(AppEngineAuthentication.SKIP_ADMIN_CHECK_ATTR) != null) {
                log.logp(Level.FINE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", "Returning DeferredAuthentication because of SkipAdminCheck.");
                return new DeferredAuthentication((LoginAuthenticator)this);
            }
            if (response == null) {
                throw new ServerAuthException("validateRequest called with null response!!!");
            }
            try {
                Object user;
                UserService userService = UserServiceFactory.getUserService();
                if (userService.isUserLoggedIn()) {
                    user = this._loginService.login(null, null, null);
                    String string = String.valueOf(user);
                    log.logp(Level.FINE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", new StringBuilder(43 + String.valueOf(string).length()).append("authenticate() returning new principal for ").append(string).toString());
                    if (user != null) {
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                }
                if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                    return Authentication.UNAUTHENTICATED;
                }
                try {
                    user = request.getRequestURI();
                    log.logp(Level.FINE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", new StringBuilder(43 + String.valueOf(user).length()).append("Got ").append((String)user).append(" but no one was logged in, redirecting.").toString());
                    String url = userService.createLoginURL(AppEngineAuthentication.getFullURL(request));
                    response.sendRedirect(url);
                    return Authentication.SEND_CONTINUE;
                }
                catch (ApiProxy.ApiProxyException ex) {
                    log.logp(Level.SEVERE, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineAuthenticator", "validateRequest", "Could not get login URL:", ex);
                    response.sendError(403);
                    return Authentication.SEND_FAILURE;
                }
            }
            catch (IOException ex) {
                throw new ServerAuthException((Throwable)ex);
            }
        }

        protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
            log.logp(Level.WARNING, "com.google.apphosting.runtime.jetty9.AppEngineAuthentication$AppEngineAuthenticator", "renewSession", "renewSession throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }

        public boolean secureResponse(ServletRequest servletRequest, ServletResponse servletResponse, boolean isAuthMandatory, Authentication.User user) {
            return true;
        }
    }
}

