/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.xml.XmlEscapers;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlConfig;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.PluginLoader;
import com.google.apphosting.utils.config.YamlUtils;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AppYaml {
    private String application;
    private String version;
    private String module;
    private String instanceClass;
    private AutomaticScaling automatic_scaling;
    private ManualScaling manual_scaling;
    private BasicScaling basic_scaling;
    private String runtime;
    private List<Handler> handlers;
    private String public_root;
    private List<StaticFile> static_files;
    private List<ResourceFile> resource_files;
    private boolean ssl_enabled = true;
    private boolean precompilation_enabled = true;
    private boolean sessions_enabled = false;
    private AsyncSessionPersistence async_session_persistence;
    private boolean threadsafe = false;
    private String auto_id_policy;
    private boolean threadsafeWasSet = false;
    private boolean codeLock = false;
    private Map<String, String> system_properties;
    private Map<String, String> env_variables;
    private Map<String, String> context_params;
    private List<String> welcome_files;
    private List<String> listeners;
    private List<String> inbound_services;
    private AdminConsole admin_console;
    private List<ErrorHandler> error_handlers;
    private ApiConfig api_config;
    private String web_xml;
    private static final String REQUIRED_FIELD = "Missing required element '%s'.";

    public String getApplication() {
        if (this.application == null) {
            throw new AppEngineConfigException(String.format(REQUIRED_FIELD, "application"));
        }
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getInstance_class() {
        return this.instanceClass;
    }

    public void setInstance_class(String instanceClass) {
        this.instanceClass = instanceClass;
    }

    public AutomaticScaling getAutomatic_scaling() {
        return this.automatic_scaling;
    }

    public void setAutomatic_scaling(AutomaticScaling automaticScaling) {
        this.automatic_scaling = automaticScaling;
    }

    public ManualScaling getManual_scaling() {
        return this.manual_scaling;
    }

    public void setManual_scaling(ManualScaling manualScaling) {
        this.manual_scaling = manualScaling;
    }

    public BasicScaling getBasic_scaling() {
        return this.basic_scaling;
    }

    public void setBasic_scaling(BasicScaling basicScaling) {
        this.basic_scaling = basicScaling;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<Handler> handlers) {
        this.handlers = handlers;
        if (this.api_config != null) {
            this.api_config.setHandlers(handlers);
        }
    }

    public String getPublic_root() {
        return this.public_root;
    }

    public void setPublic_root(String public_root) {
        this.public_root = public_root;
    }

    public List<StaticFile> getStatic_files() {
        return this.static_files;
    }

    public void setStatic_files(List<StaticFile> static_files) {
        this.static_files = static_files;
    }

    public List<ResourceFile> getResource_files() {
        return this.resource_files;
    }

    public void setResource_files(List<ResourceFile> resource_files) {
        this.resource_files = resource_files;
    }

    public String getSsl_enabled() {
        boolean bl = this.ssl_enabled;
        return new StringBuilder(5).append(bl).toString();
    }

    public void setSsl_enabled(String ssl_enabled) {
        this.ssl_enabled = YamlUtils.parseBoolean(ssl_enabled);
    }

    public boolean isSslEnabled() {
        return this.ssl_enabled;
    }

    public String getPrecompilation_enabled() {
        boolean bl = this.precompilation_enabled;
        return new StringBuilder(5).append(bl).toString();
    }

    public boolean isPrecompilationEnabled() {
        return this.precompilation_enabled;
    }

    public void setPrecompilation_enabled(String precompilation_enabled) {
        this.precompilation_enabled = YamlUtils.parseBoolean(precompilation_enabled);
    }

    public String getSessions_enabled() {
        boolean bl = this.sessions_enabled;
        return new StringBuilder(5).append(bl).toString();
    }

    public boolean isSessionsEnabled() {
        return this.sessions_enabled;
    }

    public void setSessions_enabled(String sessions_enabled) {
        this.sessions_enabled = YamlUtils.parseBoolean(sessions_enabled);
    }

    public AsyncSessionPersistence getAsync_session_persistence() {
        return this.async_session_persistence;
    }

    public void setAsync_session_persistence(AsyncSessionPersistence async_session_persistence) {
        this.async_session_persistence = async_session_persistence;
    }

    public String getThreadsafe() {
        boolean bl = this.threadsafe;
        return new StringBuilder(5).append(bl).toString();
    }

    public boolean isThreadsafeSet() {
        return this.threadsafeWasSet;
    }

    public void setThreadsafe(String threadsafe) {
        this.threadsafe = YamlUtils.parseBoolean(threadsafe);
        this.threadsafeWasSet = true;
    }

    public String getAuto_id_policy() {
        return this.auto_id_policy;
    }

    public void setAuto_id_policy(String policy) {
        this.auto_id_policy = policy;
    }

    public String getCode_lock() {
        boolean bl = this.codeLock;
        return new StringBuilder(5).append(bl).toString();
    }

    public void setCode_lock(String codeLock) {
        this.codeLock = YamlUtils.parseBoolean(codeLock);
    }

    public Map<String, String> getSystem_properties() {
        return this.system_properties;
    }

    public void setSystem_properties(Map<String, String> system_properties) {
        this.system_properties = system_properties;
    }

    public Map<String, String> getEnv_variables() {
        return this.env_variables;
    }

    public void setEnv_variables(Map<String, String> env_variables) {
        this.env_variables = env_variables;
    }

    public List<String> getWelcome_files() {
        return this.welcome_files;
    }

    public void setWelcome_files(List<String> welcome_files) {
        this.welcome_files = welcome_files;
    }

    public Map<String, String> getContext_params() {
        return this.context_params;
    }

    public void setContext_params(Map<String, String> context_params) {
        this.context_params = context_params;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<String> listeners) {
        this.listeners = listeners;
    }

    public String getWeb_xml() {
        return this.web_xml;
    }

    public void setWeb_xml(String web_xml) {
        this.web_xml = web_xml;
    }

    public List<String> getInbound_services() {
        return this.inbound_services;
    }

    public void setInbound_services(List<String> inbound_services) {
        this.inbound_services = inbound_services;
    }

    public AdminConsole getAdmin_console() {
        return this.admin_console;
    }

    public void setAdmin_console(AdminConsole admin_console) {
        this.admin_console = admin_console;
    }

    public List<ErrorHandler> getError_handlers() {
        return this.error_handlers;
    }

    public void setError_handlers(List<ErrorHandler> error_handlers) {
        this.error_handlers = error_handlers;
    }

    public ApiConfig getApi_config() {
        return this.api_config;
    }

    public void setApi_config(ApiConfig api_config) {
        this.api_config = api_config;
        if (this.handlers != null) {
            this.api_config.setHandlers(this.handlers);
        }
    }

    public AppYaml applyPlugins() {
        AppYaml yaml = this;
        for (Plugin plugin : PluginLoader.loadPlugins(Plugin.class)) {
            AppYaml modified = plugin.process(yaml);
            if (modified == null) continue;
            yaml = modified;
        }
        return yaml;
    }

    private void addOptionalElement(XmlWriter xml, String name, String value) {
        if (value != null) {
            xml.simpleElement(name, value, new String[0]);
        }
    }

    public void generateAppEngineWebXml(Writer writer) {
        XmlWriter xml = new XmlWriter(this, writer);
        xml.startElement("appengine-web-app", "xmlns", "http://appengine.google.com/ns/1.0");
        xml.simpleElement("application", this.getApplication(), new String[0]);
        this.addOptionalElement(xml, "version", this.getVersion());
        this.addOptionalElement(xml, "runtime", this.getRuntime());
        this.addOptionalElement(xml, "module", this.getModule());
        this.addOptionalElement(xml, "instance-class", this.getInstance_class());
        this.addOptionalElement(xml, "public-root", this.public_root);
        this.addOptionalElement(xml, "auto-id-policy", this.getAuto_id_policy());
        if (this.automatic_scaling != null) {
            xml.startElement("automatic-scaling", new String[0]);
            this.addOptionalElement(xml, "min-pending-latency", this.automatic_scaling.getMin_pending_latency());
            this.addOptionalElement(xml, "max-pending-latency", this.automatic_scaling.getMax_pending_latency());
            this.addOptionalElement(xml, "min-idle-instances", this.automatic_scaling.getMin_idle_instances());
            this.addOptionalElement(xml, "max-idle-instances", this.automatic_scaling.getMax_idle_instances());
            this.addOptionalElement(xml, "max-concurrent-requests", this.automatic_scaling.getMax_concurrent_requests());
            xml.endElement("automatic-scaling");
        }
        if (this.manual_scaling != null) {
            xml.startElement("manual-scaling", new String[0]);
            xml.simpleElement("instances", this.manual_scaling.getInstances(), new String[0]);
            xml.endElement("manual-scaling");
        }
        if (this.basic_scaling != null) {
            xml.startElement("basic-scaling", new String[0]);
            xml.simpleElement("max-instances", this.basic_scaling.getMax_instances(), new String[0]);
            this.addOptionalElement(xml, "idle-timeout", this.basic_scaling.getIdle_timeout());
            xml.endElement("basic-scaling");
        }
        xml.startElement("static-files", new String[0]);
        if (this.static_files != null) {
            for (StaticFile staticFile : this.static_files) {
                if (staticFile.getInclude() != null) {
                    this.generateInclude(staticFile, xml);
                    continue;
                }
                xml.emptyElement("exclude", "path", staticFile.getExclude());
            }
        }
        xml.endElement("static-files");
        xml.startElement("resource-files", new String[0]);
        if (this.resource_files != null) {
            for (ResourceFile resourceFile : this.resource_files) {
                String path;
                String name;
                if (resourceFile.getInclude() != null) {
                    name = "include";
                    path = resourceFile.getInclude();
                } else {
                    name = "exclude";
                    path = resourceFile.getExclude();
                }
                xml.emptyElement(name, "path", path);
            }
        }
        xml.endElement("resource-files");
        xml.simpleElement("ssl-enabled", this.getSsl_enabled(), new String[0]);
        xml.simpleElement("precompilation-enabled", this.getPrecompilation_enabled(), new String[0]);
        if (this.isThreadsafeSet()) {
            xml.simpleElement("threadsafe", this.getThreadsafe(), new String[0]);
        }
        xml.simpleElement("code-lock", this.getCode_lock(), new String[0]);
        xml.simpleElement("sessions-enabled", this.getSessions_enabled(), new String[0]);
        if (this.async_session_persistence != null) {
            xml.simpleElement("async-session-persistence", null, "enabled", this.getAsync_session_persistence().getEnabled(), "queue-name", this.getAsync_session_persistence().getQueue_name());
        }
        if (this.system_properties != null) {
            xml.startElement("system-properties", new String[0]);
            for (Map.Entry entry : this.system_properties.entrySet()) {
                xml.emptyElement("property", "name", (String)entry.getKey(), "value", (String)entry.getValue());
            }
            xml.endElement("system-properties");
        }
        if (this.env_variables != null) {
            xml.startElement("env-variables", new String[0]);
            for (Map.Entry entry : this.env_variables.entrySet()) {
                xml.emptyElement("env-var", "name", (String)entry.getKey(), "value", (String)entry.getValue());
            }
            xml.endElement("env-variables");
        }
        boolean warmupService = false;
        if (this.inbound_services != null) {
            xml.startElement("inbound-services", new String[0]);
            for (String service : this.inbound_services) {
                if ("warmup".equals(service)) {
                    warmupService = true;
                    continue;
                }
                xml.simpleElement("service", service, new String[0]);
            }
            xml.endElement("inbound-services");
        }
        xml.simpleElement("warmup-requests-enabled", Boolean.toString(warmupService), new String[0]);
        if (this.admin_console != null && this.admin_console.getPages() != null) {
            xml.startElement("admin-console", new String[0]);
            for (AdminPage page : this.admin_console.getPages()) {
                xml.emptyElement("page", "name", page.getName(), "url", page.getUrl());
            }
            xml.endElement("admin-console");
        }
        if (this.error_handlers != null) {
            xml.startElement("static-error-handlers", new String[0]);
            for (ErrorHandler handler : this.error_handlers) {
                xml.emptyElement("handler", "file", handler.getFile(), "error-code", handler.getError_code());
            }
            xml.endElement("static-error-handlers");
        }
        if (this.api_config != null) {
            this.api_config.generateXml(xml);
        }
        xml.endElement("appengine-web-app");
    }

    private void generateHandlerXml(XmlWriter xmlWriter) {
        if (this.handlers == null) {
            return;
        }
        LinkedHashMap<String, Handler> servletsByName = Maps.newLinkedHashMapWithExpectedSize(this.handlers.size());
        LinkedHashMap<String, Handler> filtersByName = Maps.newLinkedHashMapWithExpectedSize(this.handlers.size());
        for (Handler handler : this.handlers) {
            Handler existing;
            String name = handler.getName();
            if (name == null) continue;
            Handler.Type type = handler.getType();
            boolean isServlet = type == Handler.Type.SERVLET || type == Handler.Type.JSP;
            boolean isFilter = type == Handler.Type.FILTER;
            Handler handler2 = existing = isServlet ? (Handler)servletsByName.get(name) : (Handler)filtersByName.get(name);
            if (existing != null) {
                existing.mergeDefinitions(handler);
                continue;
            }
            if (isServlet) {
                servletsByName.put(name, handler);
            }
            if (!isFilter) continue;
            filtersByName.put(name, handler);
        }
        for (Handler handler : servletsByName.values()) {
            handler.generateDefinitionXml(xmlWriter);
        }
        for (Handler handler : filtersByName.values()) {
            handler.generateDefinitionXml(xmlWriter);
        }
        for (Handler handler : this.handlers) {
            handler.generateMappingXml(xmlWriter);
        }
    }

    public void generateWebXml(Writer writer) {
        XmlWriter xml = new XmlWriter(this, writer);
        xml.startElement("web-app", "version", "2.5", "xmlns", "http://java.sun.com/xml/ns/javaee", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd");
        this.generateHandlerXml(xml);
        if (this.context_params != null) {
            for (Map.Entry<String, String> entry : this.context_params.entrySet()) {
                xml.startElement("context-param", new String[0]);
                xml.simpleElement("param-name", entry.getKey(), new String[0]);
                xml.simpleElement("param-value", entry.getValue(), new String[0]);
                xml.endElement("context-param");
            }
        }
        if (this.welcome_files != null) {
            xml.startElement("welcome-file-list", new String[0]);
            for (String file : this.welcome_files) {
                xml.simpleElement("welcome-file", file, new String[0]);
            }
            xml.endElement("welcome-file-list");
        }
        if (this.listeners != null) {
            for (String listener : this.listeners) {
                xml.startElement("listener", new String[0]);
                xml.simpleElement("listener-class", listener, new String[0]);
                xml.endElement("listener");
            }
        }
        if (this.web_xml != null) {
            xml.writeUnescaped(this.web_xml);
        }
        xml.endElement("web-app");
    }

    public static AppYaml parse(Reader reader) {
        YamlReader yaml = new YamlReader(reader);
        AppYaml.prepareParser(yaml.getConfig());
        try {
            AppYaml appYaml = yaml.read(AppYaml.class);
            if (appYaml == null) {
                throw new YamlException("Unable to parse yaml file");
            }
            return appYaml.applyPlugins();
        }
        catch (YamlException e) {
            for (Throwable innerException = e.getCause(); innerException != null; innerException = innerException.getCause()) {
                if (!(innerException instanceof AppEngineConfigException)) continue;
                throw (AppEngineConfigException)innerException;
            }
            throw new AppEngineConfigException(e.getMessage(), e);
        }
    }

    public static AppYaml parse(String yaml) {
        return AppYaml.parse(new StringReader(yaml));
    }

    public static void prepareParser(YamlConfig config) {
        config.setPropertyElementType(AppYaml.class, "handlers", Handler.class);
        config.setPropertyElementType(AppYaml.class, "static_files", StaticFile.class);
        config.setPropertyElementType(AppYaml.class, "resource_files", ResourceFile.class);
        config.setPropertyElementType(AppYaml.class, "system_properties", String.class);
        config.setPropertyElementType(AppYaml.class, "context_params", String.class);
        config.setPropertyElementType(AppYaml.class, "env_variables", String.class);
        config.setPropertyElementType(AppYaml.class, "welcome_files", String.class);
        config.setPropertyElementType(AppYaml.class, "listeners", String.class);
        config.setPropertyElementType(AppYaml.class, "inbound_services", String.class);
        config.setPropertyElementType(Handler.class, "init_params", String.class);
        config.setPropertyElementType(AdminConsole.class, "pages", AdminPage.class);
        config.setPropertyElementType(AppYaml.class, "error_handlers", ErrorHandler.class);
    }

    private void generateInclude(StaticFile include, XmlWriter xml) {
        String path = include.getInclude();
        Map<String, String> httpHeaders = include.getHttp_headers();
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            xml.emptyElement("include", "path", include.getInclude(), "expiration", include.getExpiration());
        } else {
            xml.startElement("include", false, "path", include.getInclude(), "expiration", include.getExpiration());
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                xml.emptyElement("http-header", "name", entry.getKey(), "value", entry.getValue());
            }
            xml.endElement("include");
        }
    }

    private class XmlWriter {
        private static final String XML_HEADER = "<!-- Generated from app.yaml. Do not edit. -->";
        private final PrintWriter writer;
        private int indent = 0;
        private int apiEndpointId = 0;

        public XmlWriter(AppYaml appYaml, Writer w) {
            this.writer = new PrintWriter(w);
            this.writer.println(XML_HEADER);
        }

        public void startElement(String name, String ... attributes) {
            this.startElement(name, false, attributes);
            this.writer.println();
        }

        public void startElement(String name, boolean empty, String ... attributes) {
            this.indent();
            this.writer.print("<");
            this.writer.print(name);
            for (int i = 0; i < attributes.length; i += 2) {
                String attributeName = attributes[i];
                String value = attributes[i + 1];
                if (value == null) continue;
                this.writer.print(" ");
                this.writer.print(attributeName);
                this.writer.print("='");
                this.writer.print(this.escapeAttribute(value));
                this.writer.print("'");
            }
            if (empty) {
                this.writer.println("/>");
            } else {
                this.writer.print(">");
                this.indent += 2;
            }
        }

        public void endElement(String name) {
            this.endElement(name, true);
        }

        public void endElement(String name, boolean needIndent) {
            this.indent -= 2;
            if (needIndent) {
                this.indent();
            }
            this.writer.print("</");
            this.writer.print(name);
            this.writer.println(">");
        }

        public void emptyElement(String name, String ... attributes) {
            this.startElement(name, true, attributes);
        }

        public void simpleElement(String name, String value, String ... attributes) {
            this.startElement(name, false, attributes);
            this.writer.print(this.escapeContent(value));
            this.endElement(name, false);
        }

        public void writeUnescaped(String xmlContent) {
            this.writer.println(xmlContent);
        }

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.print(" ");
            }
        }

        private String escapeContent(String value) {
            if (value == null) {
                return null;
            }
            return XmlEscapers.xmlContentEscaper().escape(value);
        }

        private String escapeAttribute(String value) {
            if (value == null) {
                return null;
            }
            return XmlEscapers.xmlAttributeEscaper().escape(value);
        }

        private String nextApiEndpointId() {
            return String.format("endpoint-%1$d", ++this.apiEndpointId);
        }
    }

    public static class ApiConfig {
        private String url;
        private String servlet;
        private List<Handler> handlers;

        public void setHandlers(List<Handler> handlers) {
            this.handlers = handlers;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            YamlUtils.validateUrl(url);
            this.url = url;
        }

        public String getServlet() {
            return this.servlet;
        }

        public void setServlet(String servlet) {
            this.servlet = servlet;
        }

        private void generateXml(XmlWriter xml) {
            xml.startElement("api-config", "servlet-class", this.getServlet(), "url-pattern", this.getUrl());
            if (this.handlers != null) {
                for (Handler handler : this.handlers) {
                    handler.generateEndpointServletMappingId(xml);
                }
            }
            xml.endElement("api-config");
        }
    }

    public static class BasicScaling {
        private String maxInstances;
        private String idleTimeout;

        public String getMax_instances() {
            return this.maxInstances;
        }

        public void setMax_instances(String maxInstances) {
            this.maxInstances = maxInstances;
        }

        public String getIdle_timeout() {
            return this.idleTimeout;
        }

        public void setIdle_timeout(String idleTimeout) {
            this.idleTimeout = idleTimeout;
        }
    }

    public static class ManualScaling {
        private String instances;

        public String getInstances() {
            return this.instances;
        }

        public void setInstances(String instances) {
            this.instances = instances;
        }
    }

    public static class AutomaticScaling {
        private String minPendingLatency;
        private String maxPendingLatency;
        private String minIdleInstances;
        private String maxIdleInstances;
        private String maxConcurrentRequests;

        public String getMin_pending_latency() {
            return this.minPendingLatency;
        }

        public void setMin_pending_latency(String minPendingLatency) {
            this.minPendingLatency = minPendingLatency;
        }

        public String getMax_pending_latency() {
            return this.maxPendingLatency;
        }

        public void setMax_pending_latency(String maxPendingLatency) {
            this.maxPendingLatency = maxPendingLatency;
        }

        public String getMin_idle_instances() {
            return this.minIdleInstances;
        }

        public void setMin_idle_instances(String minIdleInstances) {
            this.minIdleInstances = minIdleInstances;
        }

        public String getMax_idle_instances() {
            return this.maxIdleInstances;
        }

        public void setMax_idle_instances(String maxIdleInstances) {
            this.maxIdleInstances = maxIdleInstances;
        }

        public String getMax_concurrent_requests() {
            return this.maxConcurrentRequests;
        }

        public void setMax_concurrent_requests(String maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
        }
    }

    public static class ErrorHandler {
        private String file;
        private String errorCode;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getError_code() {
            return this.errorCode;
        }

        public void setError_code(String errorCode) {
            this.errorCode = errorCode;
        }
    }

    public static class AsyncSessionPersistence {
        private boolean enabled = false;
        private String queue_name;

        public String getEnabled() {
            boolean bl = this.enabled;
            return new StringBuilder(5).append(bl).toString();
        }

        public void setEnabled(String enabled) {
            this.enabled = YamlUtils.parseBoolean(enabled);
        }

        public String getQueue_name() {
            return this.queue_name;
        }

        public void setQueue_name(String queue_name) {
            this.queue_name = queue_name;
        }
    }

    public static class AdminPage {
        private String name;
        private String url;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class AdminConsole {
        private List<AdminPage> pages;

        public List<AdminPage> getPages() {
            return this.pages;
        }

        public void setPages(List<AdminPage> pages) {
            this.pages = pages;
        }
    }

    public static class StaticFile
    extends ResourceFile {
        private static final String NO_INCLUDE = "Missing include.";
        private static final String INCLUDE_ONLY = "Expiration can only be specified with include.";
        private String expiration;

        public String getExpiration() {
            if (this.expiration != null && this.include == null) {
                throw new AppEngineConfigException(NO_INCLUDE);
            }
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            if (this.exclude != null) {
                throw new AppEngineConfigException(INCLUDE_ONLY);
            }
            this.expiration = expiration;
        }

        @Override
        public void setExclude(String exclude) {
            if (this.expiration != null) {
                throw new AppEngineConfigException(INCLUDE_ONLY);
            }
            super.setExclude(exclude);
        }
    }

    public static class ResourceFile {
        private static final String EMPTY_MESSAGE = "Missing include or exclude.";
        private static final String BOTH_MESSAGE = "Cannot specify both include and exclude.";
        protected String include;
        protected String exclude;
        protected Map<String, String> httpHeaders;

        public String getInclude() {
            if (this.exclude == null && this.include == null) {
                throw new AppEngineConfigException(EMPTY_MESSAGE);
            }
            return this.include;
        }

        public void setInclude(String include) {
            if (this.exclude != null) {
                throw new AppEngineConfigException(BOTH_MESSAGE);
            }
            this.include = include;
        }

        public String getExclude() {
            if (this.exclude == null && this.include == null) {
                throw new AppEngineConfigException(EMPTY_MESSAGE);
            }
            return this.exclude;
        }

        public void setExclude(String exclude) {
            if (this.include != null) {
                throw new AppEngineConfigException(BOTH_MESSAGE);
            }
            this.exclude = exclude;
        }

        public Map<String, String> getHttp_headers() {
            if (this.include == null) {
                throw new AppEngineConfigException("Missing include.");
            }
            return this.httpHeaders;
        }

        public void setHttp_headers(Map<String, String> httpHeaders) {
            if (this.include == null) {
                throw new AppEngineConfigException("Missing include.");
            }
            this.httpHeaders = httpHeaders;
        }
    }

    public static class Handler {
        private String url;
        private String jsp;
        private String servlet;
        private String filter;
        private LoginType login;
        private Security secure;
        private Map<String, String> init_params;
        private String name;
        private boolean load_on_startup;
        private boolean api_endpoint = false;
        private String script;
        private static final String MULTIPLE_HANDLERS = "Cannot set both %s and %s for the same url.";

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            YamlUtils.validateUrl(url);
            this.url = url;
        }

        public String getJsp() {
            return this.jsp;
        }

        public void setJsp(String jsp) {
            this.jsp = jsp;
            this.checkHandlers();
        }

        public String getServlet() {
            return this.servlet;
        }

        public void setServlet(String servlet) {
            this.servlet = servlet;
            this.checkHandlers();
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
            this.checkHandlers();
        }

        public Type getType() {
            if (this.servlet != null) {
                return Type.SERVLET;
            }
            if (this.filter != null) {
                return Type.FILTER;
            }
            if (this.jsp != null) {
                return Type.JSP;
            }
            return Type.NONE;
        }

        public String getTarget() {
            if (this.servlet != null) {
                return this.servlet;
            }
            if (this.filter != null) {
                return this.filter;
            }
            if (this.jsp != null) {
                return this.jsp;
            }
            return null;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public String getScript() {
            return this.script;
        }

        public LoginType getLogin() {
            return this.login;
        }

        public void setLogin(LoginType login) {
            this.login = login;
        }

        public Security getSecure() {
            return this.secure;
        }

        public void setSecure(Security secure) {
            if (secure == Security.never) {
                throw new AppEngineConfigException("Java does not support secure: never");
            }
            this.secure = secure;
        }

        public Map<String, String> getInit_params() {
            return this.init_params;
        }

        public void setInit_params(Map<String, String> init_params) {
            this.init_params = init_params == null ? null : new TreeMap<String, String>(init_params);
        }

        public String getName() {
            return this.name == null ? this.getTarget() : this.name;
        }

        public void setLoad_on_startup(boolean loadOnStartup) {
            this.load_on_startup = loadOnStartup;
        }

        public boolean getLoad_on_startup() {
            return this.load_on_startup;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getApi_endpoint() {
            boolean bl = this.api_endpoint;
            return new StringBuilder(5).append(bl).toString();
        }

        public void setApi_endpoint(String api_endpoint) {
            this.api_endpoint = YamlUtils.parseBoolean(api_endpoint);
        }

        public boolean isApiEndpoint() {
            return this.api_endpoint;
        }

        private void checkHandlers() {
            if (this.jsp != null && this.servlet != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "jsp", "servlet"));
            }
            if (this.jsp != null && this.filter != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "jsp", "filter"));
            }
            if (this.filter != null && this.servlet != null) {
                throw new AppEngineConfigException(String.format(MULTIPLE_HANDLERS, "filter", "servlet"));
            }
        }

        private void generateDefinitionXml(XmlWriter xml) {
            if (this.getServlet() != null || this.getJsp() != null) {
                this.generateServletDefinition(xml);
            } else if (this.getFilter() != null) {
                this.generateFilterDefintion(xml);
            }
        }

        private void generateMappingXml(XmlWriter xml) {
            if (this.getServlet() != null || this.getJsp() != null) {
                this.generateServletMapping(xml);
            } else if (this.getFilter() != null) {
                this.generateFilterMapping(xml);
            }
            this.generateSecurityConstraints(xml);
        }

        private void generateSecurityConstraints(XmlWriter xml) {
            if (this.secure == Security.always || this.login == LoginType.required || this.login == LoginType.admin) {
                xml.startElement("security-constraint", new String[0]);
                xml.startElement("web-resource-collection", new String[0]);
                xml.simpleElement("web-resource-name", "aname", new String[0]);
                xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
                xml.endElement("web-resource-collection");
                if (this.login == LoginType.required) {
                    this.securityConstraint(xml, "auth", "role-name", "*");
                } else if (this.login == LoginType.admin) {
                    this.securityConstraint(xml, "auth", "role-name", "admin");
                }
                if (this.secure == Security.always) {
                    this.securityConstraint(xml, "user-data", "transport-guarantee", "CONFIDENTIAL");
                }
                xml.endElement("security-constraint");
            }
        }

        private void securityConstraint(XmlWriter xml, String type, String name, String value) {
            type = String.valueOf(type).concat("-constraint");
            xml.startElement(type, new String[0]);
            xml.simpleElement(name, value, new String[0]);
            xml.endElement(type);
        }

        private void generateFilterDefintion(XmlWriter xml) {
            xml.startElement("filter", new String[0]);
            xml.simpleElement("filter-name", this.getName(), new String[0]);
            xml.simpleElement("filter-class", this.getFilter(), new String[0]);
            this.generateInitParams(xml);
            xml.endElement("filter");
        }

        private void generateFilterMapping(XmlWriter xml) {
            xml.startElement("filter-mapping", new String[0]);
            xml.simpleElement("filter-name", this.getName(), new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("filter-mapping");
        }

        private void generateServletDefinition(XmlWriter xml) {
            xml.startElement("servlet", new String[0]);
            xml.simpleElement("servlet-name", this.getName(), new String[0]);
            if (this.getJsp() == null) {
                xml.simpleElement("servlet-class", this.getServlet(), new String[0]);
            } else {
                xml.simpleElement("jsp-file", this.getJsp(), new String[0]);
            }
            this.generateInitParams(xml);
            if (this.load_on_startup) {
                xml.simpleElement("load-on-startup", "1", new String[0]);
            }
            xml.endElement("servlet");
        }

        public void mergeDefinitions(Handler otherHandler) {
            String string = this.getName();
            Object object = otherHandler.getName();
            Preconditions.checkArgument(this.getName().equals(otherHandler.getName()), new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(object).length()).append("Cannot merge handler named ").append(string).append(" with handler named ").append((String)object).toString());
            string = String.valueOf((Object)this.getType());
            object = String.valueOf((Object)otherHandler.getType());
            Preconditions.checkArgument(this.getType() == otherHandler.getType(), new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(object).length()).append("Cannot merge handler of type ").append(string).append(" with handler of type ").append((String)object).toString());
            string = this.getTarget();
            object = otherHandler.getTarget();
            Preconditions.checkArgument(this.getTarget().equals(otherHandler.getTarget()), new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(object).length()).append("Cannont merge handler with target ").append(string).append(" with handler with target ").append((String)object).toString());
            this.load_on_startup = this.load_on_startup || otherHandler.load_on_startup;
            LinkedHashMap<String, String> mergedInitParams = new LinkedHashMap<String, String>();
            if (this.init_params != null) {
                mergedInitParams.putAll(this.init_params);
            }
            if (otherHandler.init_params != null) {
                for (String key : otherHandler.init_params.keySet()) {
                    String thisValue = (String)mergedInitParams.get(key);
                    String otherValue = otherHandler.init_params.get(key);
                    if (thisValue == null) {
                        mergedInitParams.put(key, otherValue);
                        continue;
                    }
                    if (thisValue.equals(otherValue)) continue;
                    throw new IllegalArgumentException(new StringBuilder(73 + String.valueOf(key).length() + String.valueOf(thisValue).length() + String.valueOf(otherValue).length()).append("Cannot merge handlers with conflicting values for the init_param: ").append(key).append(" : ").append(thisValue).append(" vs ").append(otherValue).toString());
                }
            }
            if (mergedInitParams.size() != 0) {
                this.init_params = mergedInitParams;
            }
        }

        private void generateServletMapping(XmlWriter xml) {
            if (this.isApiEndpoint()) {
                xml.startElement("servlet-mapping", "id", xml.nextApiEndpointId());
            } else {
                xml.startElement("servlet-mapping", new String[0]);
            }
            xml.simpleElement("servlet-name", this.getName(), new String[0]);
            xml.simpleElement("url-pattern", this.getUrl(), new String[0]);
            xml.endElement("servlet-mapping");
        }

        private void generateInitParams(XmlWriter xml) {
            if (this.init_params != null) {
                for (Map.Entry<String, String> param : this.init_params.entrySet()) {
                    xml.startElement("init-param", new String[0]);
                    xml.simpleElement("param-name", param.getKey(), new String[0]);
                    xml.simpleElement("param-value", param.getValue(), new String[0]);
                    xml.endElement("init-param");
                }
            }
        }

        private void generateEndpointServletMappingId(XmlWriter xml) {
            if (this.isApiEndpoint()) {
                xml.simpleElement("endpoint-servlet-mapping-id", xml.nextApiEndpointId(), new String[0]);
            }
        }

        public static enum Security {
            always,
            optional,
            never;

        }

        public static enum LoginType {
            admin,
            required;

        }

        public static enum Type {
            SERVLET,
            JSP,
            FILTER,
            NONE;

        }
    }

    public static interface Plugin {
        public AppYaml process(AppYaml var1);
    }
}

