/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.jetty;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.security.Authenticator;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;

class AppEngineAuthentication {
    private static final Logger log = Logger.getLogger(AppEngineAuthentication.class.getName());
    private static final String AUTH_URL_PREFIX = "/_ah/";
    private static final String AUTH_METHOD = "Google Login";
    private static final String AUTH_TYPE = "GOOGLE_AUTH";
    private static final String REALM_NAME = "Google App Engine";
    private static final String SKIP_ADMIN_CHECK_ATTR = "com.google.apphosting.internal.SkipAdminCheck";

    AppEngineAuthentication() {
    }

    public static void configureSecurityHandler(SecurityHandler handler) {
        handler.setAuthenticator(new AppEngineAuthenticator());
        handler.setUserRealm(new AppEngineUserRealm());
    }

    private static String getFullURL(HttpServletRequest request) {
        StringBuffer buffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            buffer.append('?');
            buffer.append(request.getQueryString());
        }
        return buffer.toString();
    }

    public static class AppEnginePrincipal
    implements Principal {
        private final User user;

        public AppEnginePrincipal(User user) {
            this.user = user;
        }

        public User getUser() {
            return this.user;
        }

        @Override
        public String getName() {
            if (this.user.getFederatedIdentity() != null && this.user.getFederatedIdentity().length() > 0) {
                return this.user.getFederatedIdentity();
            }
            return this.user.getEmail();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof AppEnginePrincipal) {
                return this.user.equals((Object)((AppEnginePrincipal)other).user);
            }
            return false;
        }

        @Override
        public String toString() {
            return this.user.toString();
        }

        @Override
        public int hashCode() {
            return this.user.hashCode();
        }
    }

    private static class AppEngineUserRealm
    implements UserRealm {
        private static final String USER_ROLE = "*";
        private static final String ADMIN_ROLE = "admin";

        private AppEngineUserRealm() {
        }

        @Override
        public boolean isUserInRole(Principal principal, String role) {
            UserService userService = UserServiceFactory.getUserService();
            String string = String.valueOf(principal);
            log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "isUserInRole", new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(role).length()).append("Checking if principal ").append(string).append(" is in role ").append(role).toString());
            if (principal == null) {
                log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "isUserInRole", "isUserInRole() called with null principal.");
                return false;
            }
            if (!(principal instanceof AppEnginePrincipal)) {
                String string2 = String.valueOf(principal.getClass().getName());
                log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "isUserInRole", string2.length() != 0 ? "Got an unexpected principal of type: ".concat(string2) : new String("Got an unexpected principal of type: "));
                return false;
            }
            User user = ((AppEnginePrincipal)principal).getUser();
            if (USER_ROLE.equals(role)) {
                return true;
            }
            if (ADMIN_ROLE.equals(role)) {
                if (user.equals((Object)userService.getCurrentUser())) {
                    return userService.isUserAdmin();
                }
                String string3 = String.valueOf(user);
                log.logp(Level.WARNING, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "isUserInRole", new StringBuilder(47 + String.valueOf(string3).length()).append("Cannot tell if non-logged-in user ").append(string3).append(" is an admin.").toString());
                return false;
            }
            log.logp(Level.WARNING, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "isUserInRole", new StringBuilder(15 + String.valueOf(role).length()).append("Unknown role: ").append(role).append(".").toString());
            return false;
        }

        @Override
        public String getName() {
            return AppEngineAuthentication.REALM_NAME;
        }

        @Override
        public void disassociate(Principal user) {
            if (user != null) {
                String string = String.valueOf(user);
                log.logp(Level.FINE, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "disassociate", new StringBuilder(32 + String.valueOf(string).length()).append("Ignoring disassociate call for: ").append(string).toString());
            }
        }

        @Override
        public Principal getPrincipal(String username) {
            log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "getPrincipal", new StringBuilder(54 + String.valueOf(username).length()).append("getPrincipal(").append(username).append(") throwing UnsupportedOperationException.").toString());
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal authenticate(String username, Object credentials, Request request) {
            String string = String.valueOf(credentials);
            log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "authenticate", new StringBuilder(56 + String.valueOf(username).length() + String.valueOf(string).length()).append("Authenticate(").append(username).append(", ").append(string).append(") throwing UnsupportedOperationException.").toString());
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean reauthenticate(Principal user) {
            String string = String.valueOf(user);
            log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "reauthenticate", new StringBuilder(56 + String.valueOf(string).length()).append("reauthenticate(").append(string).append(") throwing UnsupportedOperationException.").toString());
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal pushRole(Principal user, String role) {
            log.logp(Level.WARNING, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "pushRole", "pushRole throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }

        @Override
        public Principal popRole(Principal user) {
            log.logp(Level.WARNING, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "popRole", "popRole throwing an UnsupportedOperationException");
            throw new UnsupportedOperationException();
        }

        @Override
        public void logout(Principal user) {
            String string = String.valueOf(user);
            log.logp(Level.WARNING, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineUserRealm", "logout", new StringBuilder(50 + String.valueOf(string).length()).append("logout(").append(string).append(") throwing an UnsupportedOperationException").toString());
            throw new UnsupportedOperationException();
        }
    }

    private static class AppEngineAuthenticator
    implements Authenticator {
        private AppEngineAuthenticator() {
        }

        @Override
        public Principal authenticate(UserRealm realm, String pathInContext, Request request, Response response) {
            UserService userService = UserServiceFactory.getUserService();
            if (request.getRequestURI().indexOf(AppEngineAuthentication.AUTH_URL_PREFIX) == 0) {
                String string = request.getRequestURI();
                log.logp(Level.FINE, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", new StringBuilder(62 + String.valueOf(string).length()).append("Got ").append(string).append(", returning NOBODY to imply authentication is in progress.").toString());
                return SecurityHandler.__NOBODY;
            }
            if (request.getAttribute(AppEngineAuthentication.SKIP_ADMIN_CHECK_ATTR) != null) {
                log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", "Returning NOBODY because of SkipAdminCheck.");
                return SecurityHandler.__NOBODY;
            }
            if (userService.isUserLoggedIn()) {
                User user = userService.getCurrentUser();
                String string = String.valueOf(user);
                log.logp(Level.FINE, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", new StringBuilder(43 + String.valueOf(string).length()).append("authenticate() returning new principal for ").append(string).toString());
                AppEnginePrincipal princpal = new AppEnginePrincipal(user);
                request.setUserPrincipal(princpal);
                request.setAuthType(AppEngineAuthentication.AUTH_TYPE);
                return princpal;
            }
            if (response == null) {
                String princpal = request.getRequestURI();
                log.logp(Level.FINE, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", new StringBuilder(40 + String.valueOf(princpal).length()).append("Got ").append(princpal).append(" with null response, returning null.").toString());
                return null;
            }
            String princpal = request.getRequestURI();
            log.logp(Level.INFO, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", new StringBuilder(43 + String.valueOf(princpal).length()).append("Got ").append(princpal).append(" but no one was logged in, redirecting.").toString());
            try {
                try {
                    String url = userService.createLoginURL(AppEngineAuthentication.getFullURL(request));
                    response.sendRedirect(url);
                    return null;
                }
                catch (ApiProxy.ApiProxyException ex) {
                    log.logp(Level.SEVERE, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", "Could not get login URL:", ex);
                    response.sendError(403);
                    return null;
                }
            }
            catch (IOException ex) {
                log.logp(Level.WARNING, "com.google.apphosting.utils.jetty.AppEngineAuthentication$AppEngineAuthenticator", "authenticate", "Got an IOException from sendRedirect:", ex);
                return null;
            }
        }

        @Override
        public String getAuthMethod() {
            return AppEngineAuthentication.AUTH_METHOD;
        }
    }
}

