/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.jetty;

import com.google.apphosting.api.ApiProxy;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import org.mortbay.log.Logger;

public class JettyLogger
implements Logger {
    private static boolean logToApiProxy = Boolean.getBoolean("appengine.jetty.also_log_to_apiproxy");
    private final java.util.logging.Logger logger;

    public JettyLogger() {
        this(null);
    }

    public JettyLogger(String name) {
        String logName = new StringBuilder(13 + String.valueOf(name).length()).append("JettyLogger(").append(name).append(")").toString();
        this.logger = java.util.logging.Logger.getLogger(logName);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.getLevel() == Level.FINEST;
    }

    @Override
    public void setDebugEnabled(boolean enabled) {
        this.logger.setLevel(enabled ? Level.FINEST : Level.INFO);
    }

    @Override
    public void info(String msg, Object arg0, Object arg1) {
        this.logger.logp(Level.INFO, "com.google.apphosting.utils.jetty.JettyLogger", "info", this.format(msg, arg0, arg1));
    }

    @Override
    public void debug(String msg, Throwable th) {
        this.logger.logp(Level.FINE, "com.google.apphosting.utils.jetty.JettyLogger", "debug", msg, th);
    }

    @Override
    public void debug(String msg, Object arg0, Object arg1) {
        this.logger.logp(Level.FINE, "com.google.apphosting.utils.jetty.JettyLogger", "debug", this.format(msg, arg0, arg1));
    }

    @Override
    public void warn(String msg, Object arg0, Object arg1) {
        this.logger.logp(Level.WARNING, "com.google.apphosting.utils.jetty.JettyLogger", "warn", this.format(msg, arg0, arg1));
    }

    @Override
    public void warn(String msg, Throwable th) {
        this.logger.logp(Level.WARNING, "com.google.apphosting.utils.jetty.JettyLogger", "warn", msg, th);
        if (logToApiProxy && ApiProxy.getCurrentEnvironment() != null && th != null) {
            ApiProxy.log((ApiProxy.LogRecord)this.createLogRecord(msg, th));
        }
    }

    private String format(String msg, Object arg0, Object arg1) {
        String string;
        String string2;
        String string3;
        int i1;
        int i0 = msg.indexOf("{}");
        int n = i1 = i0 < 0 ? -1 : msg.indexOf("{}", i0 + 2);
        if (arg1 != null && i1 >= 0) {
            string3 = msg.substring(0, i1);
            string2 = String.valueOf(arg1);
            string = msg.substring(i1 + 2);
            msg = new StringBuilder(String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append(string3).append(string2).append(string).toString();
        }
        if (arg0 != null && i0 >= 0) {
            string3 = msg.substring(0, i0);
            string2 = String.valueOf(arg0);
            string = msg.substring(i0 + 2);
            msg = new StringBuilder(String.valueOf(string3).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append(string3).append(string2).append(string).toString();
        }
        return msg;
    }

    @Override
    public Logger getLogger(String name) {
        return new JettyLogger(name);
    }

    public String toString() {
        return this.logger.getName();
    }

    private ApiProxy.LogRecord createLogRecord(String message, Throwable ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(message);
        if (ex != null) {
            ex.printStackTrace(printWriter);
        }
        return new ApiProxy.LogRecord(ApiProxy.LogRecord.Level.warn, System.currentTimeMillis() * 1000L, stringWriter.toString());
    }
}

