/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.runtime;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Enums;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.RuntimePb;
import com.google.apphosting.utils.remoteapi.RemoteApiPb;
import com.google.net.util.proto2api.Status;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApiProxyUtils {
    private static final Logger logger = Logger.getLogger(ApiProxyUtils.class.getName());

    public static ApiProxy.ApiProxyException convertApiError(RuntimePb.APIResponse apiResponse, String packageName, String methodName, Logger logger) {
        RuntimePb.APIResponse.ERROR error = RuntimePb.APIResponse.ERROR.valueOf((int)apiResponse.getError());
        switch (error) {
            case CALL_NOT_FOUND: {
                return new ApiProxy.CallNotFoundException(packageName, methodName);
            }
            case PARSE_ERROR: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case SECURITY_VIOLATION: {
                logger.logp(Level.SEVERE, "com.google.apphosting.utils.runtime.ApiProxyUtils", "convertApiError", "Security violation: invalid request id used!");
                return new ApiProxy.UnknownException(packageName, methodName);
            }
            case CAPABILITY_DISABLED: {
                return new ApiProxy.CapabilityDisabledException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case OVER_QUOTA: {
                return new ApiProxy.OverQuotaException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case REQUEST_TOO_LARGE: {
                return new ApiProxy.RequestTooLargeException(packageName, methodName);
            }
            case RESPONSE_TOO_LARGE: {
                return new ApiProxy.ResponseTooLargeException(packageName, methodName);
            }
            case BAD_REQUEST: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case CANCELLED: {
                return new ApiProxy.CancelledException(packageName, methodName);
            }
            case BUFFER_ERROR: {
                logger.logp(Level.SEVERE, "com.google.apphosting.utils.runtime.ApiProxyUtils", "convertApiError", "API returned BUFFER_ERROR, but shared buffers no longer supported.");
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case FEATURE_DISABLED: {
                return new ApiProxy.FeatureNotEnabledException(apiResponse.getErrorMessage(), packageName, methodName);
            }
            case RPC_ERROR: {
                return ApiProxyUtils.convertApiResponseRpcErrorToException(RuntimePb.APIResponse.RpcError.valueOf((int)apiResponse.getRpcError()), packageName, methodName, apiResponse.getRpcApplicationError(), apiResponse.getErrorMessage(), logger);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    private static ApiProxy.ApiProxyException convertApiResponseRpcErrorToException(RuntimePb.APIResponse.RpcError rpcError, String packageName, String methodName, int applicationError, String errorDetail, Logger logger) {
        String string = String.valueOf(rpcError);
        logger.logp(Level.WARNING, "com.google.apphosting.utils.runtime.ApiProxyUtils", "convertApiResponseRpcErrorToException", new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(errorDetail).length()).append("RPC failed : ").append(string).append(" : ").append(errorDetail).toString());
        if (rpcError == null) {
            return new ApiProxy.UnknownException(packageName, methodName);
        }
        switch (rpcError) {
            case DEADLINE_EXCEEDED: {
                return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
            }
            case APPLICATION_ERROR: {
                return new ApiProxy.ApplicationException(applicationError, errorDetail);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    public static ApiProxy.ApiProxyException getRpcError(String packageName, String methodName, Status.StatusProto status, int applicationError, String errorDetail) {
        Optional<ApiProxy.ApiProxyException> statusException = ApiProxyUtils.statusException(status, packageName, methodName);
        if (statusException.isPresent()) {
            return statusException.get();
        }
        if (applicationError == 9 && "memcache".equals(packageName)) {
            return new ApiProxy.CapabilityDisabledException(errorDetail, packageName, methodName);
        }
        return new ApiProxy.ApplicationException(applicationError, errorDetail);
    }

    public static ApiProxy.ApiProxyException getApiError(String packageName, String methodName, RemoteApiPb.Response response, Logger logger) {
        RuntimePb.APIResponse apiResponse = new RuntimePb.APIResponse();
        apiResponse.setError(ApiProxyUtils.remoteApiErrorToApiResponseError(response).getValue());
        apiResponse.setPbAsBytes(response.getResponseAsBytes());
        return ApiProxyUtils.getApiError(packageName, methodName, apiResponse, logger);
    }

    public static ApiProxy.ApiProxyException getApiError(String packageName, String methodName, RuntimePb.APIResponse apiResponse, Logger logger) {
        int n = apiResponse.getError();
        String string = apiResponse.getErrorMessage();
        logger.logp(Level.WARNING, "com.google.apphosting.utils.runtime.ApiProxyUtils", "getApiError", new StringBuilder(44 + String.valueOf(string).length()).append("Received error from APIHost : ").append(n).append(" : ").append(string).toString());
        return ApiProxyUtils.convertApiError(apiResponse, packageName, methodName, logger);
    }

    @VisibleForTesting
    public static Optional<ApiProxy.ApiProxyException> statusException(Status.StatusProto status, String packageName, String methodName) {
        switch (status.getSpace()) {
            case "generic": {
                if (status.getCode() == 1) {
                    return Optional.of(new ApiProxy.CancelledException(packageName, methodName));
                }
                return Optional.absent();
            }
            case "RPC": {
                if (status.getCode() == 4) {
                    return Optional.of(new ApiProxy.ApiDeadlineExceededException(packageName, methodName));
                }
                return Optional.of(new ApiProxy.UnknownException(packageName, methodName));
            }
        }
        return Optional.absent();
    }

    public static RuntimePb.APIResponse.ERROR remoteApiErrorToApiResponseError(RemoteApiPb.Response responsePb) {
        RemoteApiPb.RpcError.ErrorCode errorCode;
        Optional<RuntimePb.APIResponse.ERROR> maybeError;
        if (!responsePb.hasRpcError()) {
            return RuntimePb.APIResponse.ERROR.OK;
        }
        int code = responsePb.getRpcError().getCode();
        RemoteApiPb.RpcError.ErrorCode[] errorCodes = RemoteApiPb.RpcError.ErrorCode.values();
        if (code >= 0 && code < errorCodes.length && (maybeError = Enums.getIfPresent(RuntimePb.APIResponse.ERROR.class, (errorCode = errorCodes[code]).name())).isPresent()) {
            return maybeError.get();
        }
        logger.logp(Level.WARNING, "com.google.apphosting.utils.runtime.ApiProxyUtils", "remoteApiErrorToApiResponseError", "Unknown error code {0}", code);
        return RuntimePb.APIResponse.ERROR.RPC_ERROR;
    }
}

