/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.component;

import java.util.EventListener;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class Container {
    private Object _listeners;

    public synchronized void addEventListener(Listener listener) {
        this._listeners = LazyList.add(this._listeners, listener);
    }

    public synchronized void removeEventListener(Listener listener) {
        this._listeners = LazyList.remove(this._listeners, listener);
    }

    public synchronized void update(Object object, Object object2, Object object3, String string) {
        if (object2 != null && !object2.equals(object3)) {
            this.remove(object, object2, string);
        }
        if (object3 != null && !object3.equals(object2)) {
            this.add(object, object3, string);
        }
    }

    public synchronized void update(Object object, Object object2, Object object3, String string, boolean bl) {
        if (object2 != null && !object2.equals(object3)) {
            this.remove(object, object2, string);
            if (bl) {
                this.removeBean(object2);
            }
        }
        if (object3 != null && !object3.equals(object2)) {
            if (bl) {
                this.addBean(object3);
            }
            this.add(object, object3, string);
        }
    }

    public synchronized void update(Object object, Object[] objectArray, Object[] objectArray2, String string) {
        this.update(object, objectArray, objectArray2, string, false);
    }

    public synchronized void update(Object object, Object[] objectArray, Object[] objectArray2, String string, boolean bl) {
        int n;
        Object[] objectArray3 = null;
        if (objectArray2 != null) {
            objectArray3 = new Object[objectArray2.length];
            n = objectArray2.length;
            while (n-- > 0) {
                boolean bl2 = true;
                if (objectArray != null) {
                    int n2 = objectArray.length;
                    while (n2-- > 0) {
                        if (objectArray2[n] == null || !objectArray2[n].equals(objectArray[n2])) continue;
                        objectArray[n2] = null;
                        bl2 = false;
                    }
                }
                if (!bl2) continue;
                objectArray3[n] = objectArray2[n];
            }
        }
        if (objectArray != null) {
            n = objectArray.length;
            while (n-- > 0) {
                if (objectArray[n] == null) continue;
                this.remove(object, objectArray[n], string);
                if (!bl) continue;
                this.removeBean(objectArray[n]);
            }
        }
        if (objectArray3 != null) {
            for (n = 0; n < objectArray3.length; ++n) {
                if (objectArray3[n] == null) continue;
                if (bl) {
                    this.addBean(objectArray3[n]);
                }
                this.add(object, objectArray3[n], string);
            }
        }
    }

    public void addBean(Object object) {
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                Listener listener = (Listener)LazyList.get(this._listeners, i);
                listener.addBean(object);
            }
        }
    }

    public void removeBean(Object object) {
        if (this._listeners != null) {
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                ((Listener)LazyList.get(this._listeners, i)).removeBean(object);
            }
        }
    }

    private void add(Object object, Object object2, String string) {
        if (Log.isDebugEnabled()) {
            Log.debug("Container " + object + " + " + object2 + " as " + string);
        }
        if (this._listeners != null) {
            Relationship relationship = new Relationship(this, object, object2, string);
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                ((Listener)LazyList.get(this._listeners, i)).add(relationship);
            }
        }
    }

    private void remove(Object object, Object object2, String string) {
        if (Log.isDebugEnabled()) {
            Log.debug("Container " + object + " - " + object2 + " as " + string);
        }
        if (this._listeners != null) {
            Relationship relationship = new Relationship(this, object, object2, string);
            for (int i = 0; i < LazyList.size(this._listeners); ++i) {
                ((Listener)LazyList.get(this._listeners, i)).remove(relationship);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void addBean(Object var1);

        public void removeBean(Object var1);

        public void add(Relationship var1);

        public void remove(Relationship var1);
    }

    public static class Relationship {
        private Object _parent;
        private Object _child;
        private String _relationship;
        private Container _container;

        private Relationship(Container container, Object object, Object object2, String string) {
            this._container = container;
            this._parent = object;
            this._child = object2;
            this._relationship = string;
        }

        public Container getContainer() {
            return this._container;
        }

        public Object getChild() {
            return this._child;
        }

        public Object getParent() {
            return this._parent;
        }

        public String getRelationship() {
            return this._relationship;
        }

        public String toString() {
            return this._parent + "---" + this._relationship + "-->" + this._child;
        }

        public int hashCode() {
            return this._parent.hashCode() + this._child.hashCode() + this._relationship.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Relationship)) {
                return false;
            }
            Relationship relationship = (Relationship)object;
            return relationship._parent == this._parent && relationship._child == this._child && relationship._relationship.equals(this._relationship);
        }
    }
}

