/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.Portable;

public class ByteArrayBuffer
extends AbstractBuffer {
    protected byte[] _bytes;

    protected ByteArrayBuffer(int n, boolean bl) {
        super(n, bl);
    }

    public ByteArrayBuffer(byte[] byArray) {
        this(byArray, 0, byArray.length, 2);
    }

    public ByteArrayBuffer(byte[] byArray, int n, int n2) {
        this(byArray, n, n2, 2);
    }

    public ByteArrayBuffer(byte[] byArray, int n, int n2, int n3) {
        super(2, false);
        this._bytes = byArray;
        this.setPutIndex(n + n2);
        this.setGetIndex(n);
        this._access = n3;
    }

    public ByteArrayBuffer(byte[] byArray, int n, int n2, int n3, boolean bl) {
        super(2, bl);
        this._bytes = byArray;
        this.setPutIndex(n + n2);
        this.setGetIndex(n);
        this._access = n3;
    }

    public ByteArrayBuffer(int n) {
        this(new byte[n], 0, n, 2);
        this.setPutIndex(0);
    }

    public ByteArrayBuffer(String string) {
        super(2, false);
        this._bytes = Portable.getBytes(string);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = string;
    }

    public ByteArrayBuffer(String string, String string2) throws UnsupportedEncodingException {
        super(2, false);
        this._bytes = string.getBytes(string2);
        this.setGetIndex(0);
        this.setPutIndex(this._bytes.length);
        this._access = 0;
        this._string = string;
    }

    @Override
    public byte[] array() {
        return this._bytes;
    }

    @Override
    public int capacity() {
        return this._bytes.length;
    }

    @Override
    public void compact() {
        int n;
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        int n2 = n = this.markIndex() >= 0 ? this.markIndex() : this.getIndex();
        if (n > 0) {
            int n3 = this.putIndex() - n;
            if (n3 > 0) {
                Portable.arraycopy(this._bytes, n, this._bytes, 0, n3);
            }
            if (this.markIndex() > 0) {
                this.setMarkIndex(this.markIndex() - n);
            }
            this.setGetIndex(this.getIndex() - n);
            this.setPutIndex(this.putIndex() - n);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Buffer)) {
            return false;
        }
        if (object instanceof Buffer.CaseInsensitve) {
            return this.equalsIgnoreCase((Buffer)object);
        }
        Buffer buffer = (Buffer)object;
        if (buffer.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && object instanceof AbstractBuffer) {
            AbstractBuffer abstractBuffer = (AbstractBuffer)object;
            if (abstractBuffer._hash != 0 && this._hash != abstractBuffer._hash) {
                return false;
            }
        }
        int n = this.getIndex();
        int n2 = buffer.putIndex();
        int n3 = this.putIndex();
        while (n3-- > n) {
            byte by;
            byte by2 = this._bytes[n3];
            if (by2 == (by = buffer.peek(--n2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreCase(Buffer buffer) {
        if (buffer == this) {
            return true;
        }
        if (buffer == null || buffer.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && buffer instanceof AbstractBuffer) {
            AbstractBuffer abstractBuffer = (AbstractBuffer)buffer;
            if (abstractBuffer._hash != 0 && this._hash != abstractBuffer._hash) {
                return false;
            }
        }
        int n = this.getIndex();
        int n2 = buffer.putIndex();
        byte[] byArray = buffer.array();
        if (byArray == null) {
            int n3 = this.putIndex();
            while (n3-- > n) {
                byte by;
                byte by2 = this._bytes[n3];
                if (by2 == (by = buffer.peek(--n2))) continue;
                if (97 <= by2 && by2 <= 122) {
                    by2 = (byte)(by2 - 97 + 65);
                }
                if (97 <= by && by <= 122) {
                    by = (byte)(by - 97 + 65);
                }
                if (by2 == by) continue;
                return false;
            }
        } else {
            int n4 = this.putIndex();
            while (n4-- > n) {
                byte by;
                byte by3 = this._bytes[n4];
                if (by3 == (by = byArray[--n2])) continue;
                if (97 <= by3 && by3 <= 122) {
                    by3 = (byte)(by3 - 97 + 65);
                }
                if (97 <= by && by <= 122) {
                    by = (byte)(by - 97 + 65);
                }
                if (by3 == by) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public byte get() {
        return this._bytes[this._get++];
    }

    @Override
    public int hashCode() {
        if (this._hash == 0 || this._hashGet != this._get || this._hashPut != this._put) {
            int n = this.getIndex();
            int n2 = this.putIndex();
            while (n2-- > n) {
                byte by = this._bytes[n2];
                if (97 <= by && by <= 122) {
                    by = (byte)(by - 97 + 65);
                }
                this._hash = 31 * this._hash + by;
            }
            if (this._hash == 0) {
                this._hash = -1;
            }
            this._hashGet = this._get;
            this._hashPut = this._put;
        }
        return this._hash;
    }

    @Override
    public byte peek(int n) {
        return this._bytes[n];
    }

    @Override
    public int peek(int n, byte[] byArray, int n2, int n3) {
        int n4 = n3;
        if (n + n4 > this.capacity() && (n4 = this.capacity() - n) == 0) {
            return -1;
        }
        if (n4 < 0) {
            return -1;
        }
        Portable.arraycopy(this._bytes, n, byArray, n2, n4);
        return n4;
    }

    @Override
    public void poke(int n, byte by) {
        this._bytes[n] = by;
    }

    @Override
    public int poke(int n, Buffer buffer) {
        byte[] byArray;
        this._hash = 0;
        int n2 = buffer.length();
        if (n + n2 > this.capacity()) {
            n2 = this.capacity() - n;
        }
        if ((byArray = buffer.array()) != null) {
            Portable.arraycopy(byArray, buffer.getIndex(), this._bytes, n, n2);
        } else if (byArray != null) {
            int n3 = buffer.getIndex();
            for (int i = 0; i < n2; ++i) {
                this.poke(n++, byArray[n3++]);
            }
        } else {
            int n4 = buffer.getIndex();
            for (int i = 0; i < n2; ++i) {
                this._bytes[n++] = buffer.peek(n4++);
            }
        }
        return n2;
    }

    @Override
    public int poke(int n, byte[] byArray, int n2, int n3) {
        this._hash = 0;
        if (n + n3 > this.capacity()) {
            n3 = this.capacity() - n;
        }
        Portable.arraycopy(byArray, n2, this._bytes, n, n3);
        return n3;
    }

    public void wrap(byte[] byArray, int n, int n2) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("IMMUTABLE");
        }
        this._bytes = byArray;
        this.clear();
        this.setGetIndex(n);
        this.setPutIndex(n + n2);
    }

    public void wrap(byte[] byArray) {
        if (this.isReadOnly()) {
            throw new IllegalStateException("READONLY");
        }
        if (this.isImmutable()) {
            throw new IllegalStateException("IMMUTABLE");
        }
        this._bytes = byArray;
        this.setGetIndex(0);
        this.setPutIndex(byArray.length);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this._bytes, this.getIndex(), this.length());
        this.clear();
    }

    @Override
    public int readFrom(InputStream inputStream, int n) throws IOException {
        if (n < 0 || n > this.space()) {
            n = this.space();
        }
        int n2 = this.putIndex();
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n4 < n && (n3 = inputStream.read(this._bytes, n2, n5)) >= 0) {
            if (n3 > 0) {
                n4 += n3;
                n5 -= n3;
                this.setPutIndex(n2 += n3);
            }
            if (inputStream.available() > 0) continue;
        }
        if (n3 < 0 && n4 == 0) {
            return -1;
        }
        return n4;
    }

    @Override
    public int space() {
        return this._bytes.length - this._put;
    }

    public static class CaseInsensitive
    extends ByteArrayBuffer
    implements Buffer.CaseInsensitve {
        public CaseInsensitive(String string) {
            super(string);
        }

        public CaseInsensitive(byte[] byArray, int n, int n2, int n3) {
            super(byArray, n, n2, n3);
        }

        @Override
        public boolean equals(Object object) {
            return this.equalsIgnoreCase((Buffer)object);
        }
    }
}

