/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.mortbay.io.RuntimeIOException;
import org.mortbay.log.Log;

public class UncheckedPrintWriter
extends PrintWriter {
    private boolean autoFlush = false;
    private String lineSeparator;

    public UncheckedPrintWriter(Writer writer) {
        this(writer, false);
    }

    public UncheckedPrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
        this.autoFlush = bl;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public UncheckedPrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public UncheckedPrintWriter(OutputStream outputStream, boolean bl) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), bl);
    }

    private void isOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            this.setError();
            throw new RuntimeIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            this.setError();
            throw new RuntimeIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(n);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            this.setError();
            throw new RuntimeIOException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(cArray, n, n2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            this.setError();
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(string, n, n2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            this.setError();
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.isOpen();
                this.out.write(this.lineSeparator);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            Log.debug(iOException);
            this.setError();
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    @Override
    public void print(char c) {
        this.write(c);
    }

    @Override
    public void print(int n) {
        this.write(String.valueOf(n));
    }

    @Override
    public void print(long l) {
        this.write(String.valueOf(l));
    }

    @Override
    public void print(float f) {
        this.write(String.valueOf(f));
    }

    @Override
    public void print(double d) {
        this.write(String.valueOf(d));
    }

    @Override
    public void print(char[] cArray) {
        this.write(cArray);
    }

    @Override
    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    @Override
    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }
}

