/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.mortbay.io.bio.StreamEndPoint;
import org.mortbay.log.Log;

public class SocketEndPoint
extends StreamEndPoint {
    Socket _socket;
    InetSocketAddress _local;
    InetSocketAddress _remote;

    public SocketEndPoint(Socket socket) throws IOException {
        super(socket.getInputStream(), socket.getOutputStream());
        this._socket = socket;
    }

    @Override
    public boolean isOpen() {
        return super.isOpen() && this._socket != null && !this._socket.isClosed() && !this._socket.isInputShutdown() && !this._socket.isOutputShutdown();
    }

    @Override
    public void close() throws IOException {
        if (!this._socket.isClosed() && !this._socket.isOutputShutdown()) {
            try {
                this._socket.shutdownOutput();
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Log.ignore(unsupportedOperationException);
            }
        }
        this._socket.close();
        this._in = null;
        this._out = null;
    }

    @Override
    public String getLocalAddr() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    @Override
    public String getLocalHost() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    @Override
    public int getLocalPort() {
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    @Override
    public String getRemoteAddr() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        InetAddress inetAddress = this._remote.getAddress();
        return inetAddress == null ? null : inetAddress.getHostAddress();
    }

    @Override
    public String getRemoteHost() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    @Override
    public int getRemotePort() {
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return -1;
        }
        return this._remote.getPort();
    }

    @Override
    public Object getTransport() {
        return this._socket;
    }
}

