/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.NIOBuffer;
import org.mortbay.log.Log;

public class ChannelEndPoint
implements EndPoint {
    protected ByteChannel _channel;
    protected ByteBuffer[] _gather2 = new ByteBuffer[2];
    protected Socket _socket;
    protected InetSocketAddress _local;
    protected InetSocketAddress _remote;

    public ChannelEndPoint(ByteChannel byteChannel) {
        this._channel = byteChannel;
        if (byteChannel instanceof SocketChannel) {
            this._socket = ((SocketChannel)byteChannel).socket();
        }
    }

    @Override
    public boolean isBlocking() {
        if (this._channel instanceof SelectableChannel) {
            return ((SelectableChannel)((Object)this._channel)).isBlocking();
        }
        return true;
    }

    @Override
    public boolean blockReadable(long l) throws IOException {
        return true;
    }

    @Override
    public boolean blockWritable(long l) throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this._channel.isOpen()) {
            try {
                Socket socket;
                if (this._channel instanceof SocketChannel && !(socket = ((SocketChannel)this._channel).socket()).isClosed() && !socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Log.ignore(unsupportedOperationException);
            }
            finally {
                this._channel.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(Buffer buffer) throws IOException {
        Buffer buffer2 = buffer.buffer();
        int n = 0;
        if (buffer2 instanceof NIOBuffer) {
            NIOBuffer nIOBuffer = (NIOBuffer)buffer2;
            ByteBuffer byteBuffer = nIOBuffer.getByteBuffer();
            NIOBuffer nIOBuffer2 = nIOBuffer;
            synchronized (nIOBuffer2) {
                try {
                    byteBuffer.position(buffer.putIndex());
                    n = this._channel.read(byteBuffer);
                    if (n < 0) {
                        this._channel.close();
                    }
                }
                finally {
                    buffer.setPutIndex(byteBuffer.position());
                    byteBuffer.position(0);
                }
            }
        }
        throw new IOException("Not Implemented");
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer buffer) throws IOException {
        Buffer buffer2 = buffer.buffer();
        int n = 0;
        if (buffer2 instanceof NIOBuffer) {
            ByteBuffer byteBuffer;
            NIOBuffer nIOBuffer = (NIOBuffer)buffer2;
            ByteBuffer byteBuffer2 = byteBuffer = nIOBuffer.getByteBuffer();
            synchronized (byteBuffer2) {
                try {
                    byteBuffer.position(buffer.getIndex());
                    byteBuffer.limit(buffer.putIndex());
                    n = this._channel.write(byteBuffer);
                }
                finally {
                    if (n > 0) {
                        buffer.skip(n);
                    }
                    byteBuffer.position(0);
                    byteBuffer.limit(byteBuffer.capacity());
                }
            }
        }
        if (buffer.array() != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer.array(), buffer.getIndex(), buffer.length());
            n = this._channel.write(byteBuffer);
            if (n > 0) {
                buffer.skip(n);
            }
        } else {
            throw new IOException("Not Implemented");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer buffer, Buffer buffer2, Buffer buffer3) throws IOException {
        Buffer buffer4;
        int n = 0;
        Buffer buffer5 = buffer == null ? null : buffer.buffer();
        Buffer buffer6 = buffer4 = buffer2 == null ? null : buffer2.buffer();
        if (this._channel instanceof GatheringByteChannel && buffer != null && buffer.length() != 0 && buffer instanceof NIOBuffer && buffer2 != null && buffer2.length() != 0 && buffer2 instanceof NIOBuffer) {
            NIOBuffer nIOBuffer = (NIOBuffer)buffer5;
            ByteBuffer byteBuffer = nIOBuffer.getByteBuffer();
            NIOBuffer nIOBuffer2 = (NIOBuffer)buffer4;
            ByteBuffer byteBuffer2 = nIOBuffer2.getByteBuffer();
            ChannelEndPoint channelEndPoint = this;
            synchronized (channelEndPoint) {
                ByteBuffer byteBuffer3 = byteBuffer;
                synchronized (byteBuffer3) {
                    ByteBuffer byteBuffer4 = byteBuffer2;
                    synchronized (byteBuffer4) {
                        try {
                            byteBuffer.position(buffer.getIndex());
                            byteBuffer.limit(buffer.putIndex());
                            byteBuffer2.position(buffer2.getIndex());
                            byteBuffer2.limit(buffer2.putIndex());
                            this._gather2[0] = byteBuffer;
                            this._gather2[1] = byteBuffer2;
                            n = (int)((GatheringByteChannel)((Object)this._channel)).write(this._gather2);
                            int n2 = buffer.length();
                            if (n > n2) {
                                buffer.clear();
                                buffer2.skip(n - n2);
                            } else if (n > 0) {
                                buffer.skip(n);
                            }
                        }
                        finally {
                            if (!buffer.isImmutable()) {
                                buffer.setGetIndex(byteBuffer.position());
                            }
                            if (!buffer2.isImmutable()) {
                                buffer2.setGetIndex(byteBuffer2.position());
                            }
                            byteBuffer.position(0);
                            byteBuffer2.position(0);
                            byteBuffer.limit(byteBuffer.capacity());
                            byteBuffer2.limit(byteBuffer2.capacity());
                        }
                    }
                }
            }
        }
        if (buffer != null && buffer.length() > 0) {
            n = this.flush(buffer);
        }
        if ((buffer == null || buffer.length() == 0) && buffer2 != null && buffer2.length() > 0) {
            n += this.flush(buffer2);
        }
        if (!(buffer != null && buffer.length() != 0 || buffer2 != null && buffer2.length() != 0 || buffer3 == null || buffer3.length() <= 0)) {
            n += this.flush(buffer3);
        }
        return n;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public String getLocalAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    @Override
    public String getLocalHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    @Override
    public int getLocalPort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    @Override
    public String getRemoteAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getHostAddress();
    }

    @Override
    public String getRemoteHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    @Override
    public int getRemotePort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return -1;
        }
        return this._remote == null ? -1 : this._remote.getPort();
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean isBufferingInput() {
        return false;
    }

    @Override
    public boolean isBufferingOutput() {
        return false;
    }

    @Override
    public boolean isBufferred() {
        return false;
    }
}

