/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.nio.ByteBuffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.nio.NIOBuffer;

public class IndirectNIOBuffer
extends ByteArrayBuffer
implements NIOBuffer {
    protected ByteBuffer _buf;

    public IndirectNIOBuffer(int n) {
        super(2, false);
        this._buf = ByteBuffer.allocate(n);
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._bytes = this._buf.array();
    }

    public IndirectNIOBuffer(ByteBuffer byteBuffer, boolean bl) {
        super(bl ? 0 : 2, false);
        if (byteBuffer.isDirect()) {
            throw new IllegalArgumentException();
        }
        this._buf = byteBuffer;
        this.setGetIndex(byteBuffer.position());
        this.setPutIndex(byteBuffer.limit());
        this._bytes = this._buf.array();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this._buf;
    }

    @Override
    public boolean isDirect() {
        return false;
    }
}

