/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;

public abstract class AbstractBuffers
extends AbstractLifeCycle
implements Buffers {
    private int _headerBufferSize = 4096;
    private int _requestBufferSize = 8192;
    private int _responseBufferSize = 24576;
    private static final int __HEADER = 0;
    private static final int __REQUEST = 1;
    private static final int __RESPONSE = 2;
    private static final int __OTHER = 3;
    private final int[] _pool = new int[]{2, 1, 1, 2};
    private final ThreadLocal _buffers = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadBuffers(AbstractBuffers.this._pool[0], AbstractBuffers.this._pool[1], AbstractBuffers.this._pool[2], AbstractBuffers.this._pool[3]);
        }
    };

    @Override
    public Buffer getBuffer(int n) {
        int n2 = n == this._headerBufferSize ? 0 : (n == this._responseBufferSize ? 2 : (n == this._requestBufferSize ? 1 : 3));
        ThreadBuffers threadBuffers = (ThreadBuffers)this._buffers.get();
        Buffer[] bufferArray = threadBuffers._buffers[n2];
        for (int i = 0; i < bufferArray.length; ++i) {
            Buffer buffer = bufferArray[i];
            if (buffer == null || buffer.capacity() != n) continue;
            bufferArray[i] = null;
            return buffer;
        }
        return this.newBuffer(n);
    }

    @Override
    public void returnBuffer(Buffer buffer) {
        buffer.clear();
        if (buffer.isVolatile() || buffer.isImmutable()) {
            return;
        }
        int n = buffer.capacity();
        int n2 = n == this._headerBufferSize ? 0 : (n == this._responseBufferSize ? 2 : (n == this._requestBufferSize ? 1 : 3));
        ThreadBuffers threadBuffers = (ThreadBuffers)this._buffers.get();
        Buffer[] bufferArray = threadBuffers._buffers[n2];
        for (int i = 0; i < bufferArray.length; ++i) {
            if (bufferArray[i] != null) continue;
            bufferArray[i] = buffer;
            return;
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._headerBufferSize == this._requestBufferSize && this._headerBufferSize == this._responseBufferSize) {
            this._pool[0] = this._pool[0] + (this._pool[1] + this._pool[2]);
            this._pool[1] = 0;
            this._pool[2] = 0;
        } else if (this._headerBufferSize == this._requestBufferSize) {
            this._pool[0] = this._pool[0] + this._pool[1];
            this._pool[1] = 0;
        } else if (this._headerBufferSize == this._responseBufferSize) {
            this._pool[0] = this._pool[0] + this._pool[2];
            this._pool[2] = 0;
        } else if (this._requestBufferSize == this._responseBufferSize) {
            this._pool[2] = this._pool[2] + this._pool[1];
            this._pool[1] = 0;
        }
    }

    public int getHeaderBufferSize() {
        return this._headerBufferSize;
    }

    public void setHeaderBufferSize(int n) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._headerBufferSize = n;
    }

    public int getRequestBufferSize() {
        return this._requestBufferSize;
    }

    public void setRequestBufferSize(int n) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._requestBufferSize = n;
    }

    public int getResponseBufferSize() {
        return this._responseBufferSize;
    }

    public void setResponseBufferSize(int n) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        this._responseBufferSize = n;
    }

    protected abstract Buffer newBuffer(int var1);

    public String toString() {
        return "{{" + this._headerBufferSize + "," + this._requestBufferSize + "," + this._responseBufferSize + "}}";
    }

    protected static class ThreadBuffers {
        final Buffer[][] _buffers = new Buffer[4][];

        ThreadBuffers(int n, int n2, int n3, int n4) {
            this._buffers[0] = new Buffer[n];
            this._buffers[1] = new Buffer[n2];
            this._buffers[2] = new Buffer[n3];
            this._buffers[3] = new Buffer[n4];
        }
    }
}

