/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.mortbay.component.LifeCycle;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.AbstractBuffers;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.WaitingContinuation;

public abstract class AbstractConnector
extends AbstractBuffers
implements Connector {
    private String _name;
    private Server _server;
    private ThreadPool _threadPool;
    private String _host;
    private int _port = 0;
    private String _integralScheme = "https";
    private int _integralPort = 0;
    private String _confidentialScheme = "https";
    private int _confidentialPort = 0;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    private int _acceptorPriorityOffset = 0;
    private boolean _useDNS;
    private boolean _forwarded;
    private String _hostHeader;
    private String _forwardedHostHeader = "X-Forwarded-Host";
    private String _forwardedServerHeader = "X-Forwarded-Server";
    private String _forwardedForHeader = "X-Forwarded-For";
    private boolean _reuseAddress = true;
    protected int _maxIdleTime = 200000;
    protected int _lowResourceMaxIdleTime = -1;
    protected int _soLingerTime = -1;
    private transient Thread[] _acceptorThread;
    Object _statsLock = new Object();
    transient long _statsStartedAt = -1L;
    transient int _requests;
    transient int _connections;
    transient int _connectionsOpen;
    transient int _connectionsOpenMin;
    transient int _connectionsOpenMax;
    transient long _connectionsDurationMin;
    transient long _connectionsDurationMax;
    transient long _connectionsDurationTotal;
    transient int _connectionsRequestsMin;
    transient int _connectionsRequestsMax;

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public void setServer(Server server) {
        this._server = server;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    @Override
    public void setHost(String string) {
        this._host = string;
    }

    @Override
    public String getHost() {
        return this._host;
    }

    @Override
    public void setPort(int n) {
        this._port = n;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    @Override
    public void setMaxIdleTime(int n) {
        this._maxIdleTime = n;
    }

    @Override
    public int getLowResourceMaxIdleTime() {
        return this._lowResourceMaxIdleTime;
    }

    @Override
    public void setLowResourceMaxIdleTime(int n) {
        this._lowResourceMaxIdleTime = n;
    }

    public int getSoLingerTime() {
        return this._soLingerTime;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int n) {
        this._acceptQueueSize = n;
    }

    public int getAcceptors() {
        return this._acceptors;
    }

    public void setAcceptors(int n) {
        this._acceptors = n;
    }

    public void setSoLingerTime(int n) {
        this._soLingerTime = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() throws Exception {
        if (this._server == null) {
            throw new IllegalStateException("No server");
        }
        this.open();
        super.doStart();
        if (this._threadPool == null) {
            this._threadPool = this._server.getThreadPool();
        }
        if (this._threadPool != this._server.getThreadPool() && this._threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)this._threadPool)).start();
        }
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            this._acceptorThread = new Thread[this.getAcceptors()];
            for (int i = 0; i < this._acceptorThread.length; ++i) {
                if (this._threadPool.dispatch(new Acceptor(i))) continue;
                Log.warn("insufficient maxThreads configured for {}", this);
                break;
            }
        }
        Log.info("Started {}", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws Exception {
        try {
            this.close();
        }
        catch (IOException iOException) {
            Log.warn(iOException);
        }
        if (this._threadPool == this._server.getThreadPool()) {
            this._threadPool = null;
        } else if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)((Object)this._threadPool)).stop();
        }
        super.doStop();
        Thread[] threadArray = null;
        AbstractConnector abstractConnector = this;
        synchronized (abstractConnector) {
            threadArray = this._acceptorThread;
            this._acceptorThread = null;
        }
        if (threadArray != null) {
            for (int i = 0; i < threadArray.length; ++i) {
                Thread thread = threadArray[i];
                if (thread == null) continue;
                thread.interrupt();
            }
        }
    }

    public void join() throws InterruptedException {
        Thread[] threadArray = this._acceptorThread;
        if (threadArray != null) {
            for (int i = 0; i < threadArray.length; ++i) {
                if (threadArray[i] == null) continue;
                threadArray[i].join();
            }
        }
    }

    protected void configure(Socket socket) throws IOException {
        try {
            socket.setTcpNoDelay(true);
            if (this._maxIdleTime >= 0) {
                socket.setSoTimeout(this._maxIdleTime);
            }
            if (this._soLingerTime >= 0) {
                socket.setSoLinger(true, this._soLingerTime / 1000);
            } else {
                socket.setSoLinger(false, 0);
            }
        }
        catch (Exception exception) {
            Log.ignore(exception);
        }
    }

    @Override
    public void customize(EndPoint endPoint, Request request) throws IOException {
        if (this.isForwarded()) {
            this.checkForwardedHeaders(endPoint, request);
        }
    }

    protected void checkForwardedHeaders(EndPoint endPoint, Request request) throws IOException {
        HttpFields httpFields = request.getConnection().getRequestFields();
        String string = this.getLeftMostValue(httpFields.getStringField(this.getForwardedHostHeader()));
        String string2 = this.getLeftMostValue(httpFields.getStringField(this.getForwardedServerHeader()));
        String string3 = this.getLeftMostValue(httpFields.getStringField(this.getForwardedForHeader()));
        if (this._hostHeader != null) {
            httpFields.put(HttpHeaders.HOST_BUFFER, this._hostHeader);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (string != null) {
            httpFields.put(HttpHeaders.HOST_BUFFER, string);
            request.setServerName(null);
            request.setServerPort(-1);
            request.getServerName();
        } else if (string2 != null) {
            request.setServerName(string2);
        }
        if (string3 != null) {
            request.setRemoteAddr(string3);
            InetAddress inetAddress = null;
            if (this._useDNS) {
                try {
                    inetAddress = InetAddress.getByName(string3);
                }
                catch (UnknownHostException unknownHostException) {
                    Log.ignore(unknownHostException);
                }
            }
            request.setRemoteHost(inetAddress == null ? string3 : inetAddress.getHostName());
        }
    }

    protected String getLeftMostValue(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(44);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    @Override
    public void persist(EndPoint endPoint) throws IOException {
    }

    @Override
    public int getConfidentialPort() {
        return this._confidentialPort;
    }

    @Override
    public String getConfidentialScheme() {
        return this._confidentialScheme;
    }

    @Override
    public boolean isIntegral(Request request) {
        return false;
    }

    @Override
    public int getIntegralPort() {
        return this._integralPort;
    }

    @Override
    public String getIntegralScheme() {
        return this._integralScheme;
    }

    @Override
    public boolean isConfidential(Request request) {
        return false;
    }

    public void setConfidentialPort(int n) {
        this._confidentialPort = n;
    }

    public void setConfidentialScheme(String string) {
        this._confidentialScheme = string;
    }

    public void setIntegralPort(int n) {
        this._integralPort = n;
    }

    public void setIntegralScheme(String string) {
        this._integralScheme = string;
    }

    @Override
    public Continuation newContinuation() {
        return new WaitingContinuation();
    }

    protected abstract void accept(int var1) throws IOException, InterruptedException;

    public void stopAccept(int n) throws Exception {
    }

    @Override
    public boolean getResolveNames() {
        return this._useDNS;
    }

    public void setResolveNames(boolean bl) {
        this._useDNS = bl;
    }

    public boolean isForwarded() {
        return this._forwarded;
    }

    public void setForwarded(boolean bl) {
        if (bl) {
            Log.debug(this + " is forwarded");
        }
        this._forwarded = bl;
    }

    public String getHostHeader() {
        return this._hostHeader;
    }

    public void setHostHeader(String string) {
        this._hostHeader = string;
    }

    public String getForwardedHostHeader() {
        return this._forwardedHostHeader;
    }

    public void setForwardedHostHeader(String string) {
        this._forwardedHostHeader = string;
    }

    public String getForwardedServerHeader() {
        return this._forwardedServerHeader;
    }

    public void setForwardedServerHeader(String string) {
        this._forwardedServerHeader = string;
    }

    public String getForwardedForHeader() {
        return this._forwardedForHeader;
    }

    public void setForwardedForHeader(String string) {
        this._forwardedForHeader = string;
    }

    @Override
    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + "@" + (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
    }

    @Override
    public String getName() {
        if (this._name == null) {
            this._name = (this.getHost() == null ? "0.0.0.0" : this.getHost()) + ":" + (this.getLocalPort() <= 0 ? this.getPort() : this.getLocalPort());
        }
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    @Override
    public int getRequests() {
        return this._requests;
    }

    @Override
    public long getConnectionsDurationMin() {
        return this._connectionsDurationMin;
    }

    @Override
    public long getConnectionsDurationTotal() {
        return this._connectionsDurationTotal;
    }

    @Override
    public int getConnectionsOpenMin() {
        return this._connectionsOpenMin;
    }

    @Override
    public int getConnectionsRequestsMin() {
        return this._connectionsRequestsMin;
    }

    @Override
    public int getConnections() {
        return this._connections;
    }

    @Override
    public int getConnectionsOpen() {
        return this._connectionsOpen;
    }

    @Override
    public int getConnectionsOpenMax() {
        return this._connectionsOpenMax;
    }

    @Override
    public long getConnectionsDurationAve() {
        return this._connections == 0 ? 0L : this._connectionsDurationTotal / (long)this._connections;
    }

    @Override
    public long getConnectionsDurationMax() {
        return this._connectionsDurationMax;
    }

    @Override
    public int getConnectionsRequestsAve() {
        return this._connections == 0 ? 0 : this._requests / this._connections;
    }

    @Override
    public int getConnectionsRequestsMax() {
        return this._connectionsRequestsMax;
    }

    @Override
    public void statsReset() {
        this._statsStartedAt = this._statsStartedAt == -1L ? -1L : System.currentTimeMillis();
        this._connections = 0;
        this._connectionsOpenMin = this._connectionsOpen;
        this._connectionsOpenMax = this._connectionsOpen;
        this._connectionsOpen = 0;
        this._connectionsDurationMin = 0L;
        this._connectionsDurationMax = 0L;
        this._connectionsDurationTotal = 0L;
        this._requests = 0;
        this._connectionsRequestsMin = 0;
        this._connectionsRequestsMax = 0;
    }

    @Override
    public void setStatsOn(boolean bl) {
        if (bl && this._statsStartedAt != -1L) {
            return;
        }
        Log.debug("Statistics on = " + bl + " for " + this);
        this.statsReset();
        this._statsStartedAt = bl ? System.currentTimeMillis() : -1L;
    }

    @Override
    public boolean getStatsOn() {
        return this._statsStartedAt != -1L;
    }

    @Override
    public long getStatsOnMs() {
        return this._statsStartedAt != -1L ? System.currentTimeMillis() - this._statsStartedAt : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionOpened(HttpConnection httpConnection) {
        if (this._statsStartedAt == -1L) {
            return;
        }
        Object object = this._statsLock;
        synchronized (object) {
            ++this._connectionsOpen;
            if (this._connectionsOpen > this._connectionsOpenMax) {
                this._connectionsOpenMax = this._connectionsOpen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(HttpConnection httpConnection) {
        if (this._statsStartedAt >= 0L) {
            long l = System.currentTimeMillis() - httpConnection.getTimeStamp();
            int n = httpConnection.getRequests();
            Object object = this._statsLock;
            synchronized (object) {
                this._requests += n;
                ++this._connections;
                --this._connectionsOpen;
                this._connectionsDurationTotal += l;
                if (this._connectionsOpen < 0) {
                    this._connectionsOpen = 0;
                }
                if (this._connectionsOpen < this._connectionsOpenMin) {
                    this._connectionsOpenMin = this._connectionsOpen;
                }
                if (this._connectionsDurationMin == 0L || l < this._connectionsDurationMin) {
                    this._connectionsDurationMin = l;
                }
                if (l > this._connectionsDurationMax) {
                    this._connectionsDurationMax = l;
                }
                if (this._connectionsRequestsMin == 0 || n < this._connectionsRequestsMin) {
                    this._connectionsRequestsMin = n;
                }
                if (n > this._connectionsRequestsMax) {
                    this._connectionsRequestsMax = n;
                }
            }
        }
        httpConnection.destroy();
    }

    public int getAcceptorPriorityOffset() {
        return this._acceptorPriorityOffset;
    }

    public void setAcceptorPriorityOffset(int n) {
        this._acceptorPriorityOffset = n;
    }

    public boolean getReuseAddress() {
        return this._reuseAddress;
    }

    public void setReuseAddress(boolean bl) {
        this._reuseAddress = bl;
    }

    private class Acceptor
    implements Runnable {
        int _acceptor = 0;

        Acceptor(int n) {
            this._acceptor = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String string;
            Thread thread = Thread.currentThread();
            AbstractConnector abstractConnector = AbstractConnector.this;
            synchronized (abstractConnector) {
                if (AbstractConnector.this._acceptorThread == null) {
                    return;
                }
                ((AbstractConnector)AbstractConnector.this)._acceptorThread[this._acceptor] = thread;
                string = AbstractConnector.this._acceptorThread[this._acceptor].getName();
                thread.setName(string + " - Acceptor" + this._acceptor + " " + AbstractConnector.this);
            }
            int n = thread.getPriority();
            try {
                thread.setPriority(n - AbstractConnector.this._acceptorPriorityOffset);
                while (AbstractConnector.this.isRunning() && AbstractConnector.this.getConnection() != null) {
                    try {
                        AbstractConnector.this.accept(this._acceptor);
                    }
                    catch (EofException eofException) {
                        Log.ignore(eofException);
                    }
                    catch (IOException iOException) {
                        Log.ignore(iOException);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        Log.warn(throwable);
                    }
                }
            }
            finally {
                thread.setPriority(n);
                thread.setName(string);
                try {
                    if (this._acceptor == 0) {
                        AbstractConnector.this.close();
                    }
                }
                catch (IOException iOException) {
                    Log.warn(iOException);
                }
                AbstractConnector abstractConnector2 = AbstractConnector.this;
                synchronized (abstractConnector2) {
                    if (AbstractConnector.this._acceptorThread != null) {
                        ((AbstractConnector)AbstractConnector.this)._acceptorThread[this._acceptor] = null;
                    }
                }
            }
        }
    }
}

