/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.Buffer;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.View;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.Generator;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.log.Log;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public abstract class AbstractGenerator
implements Generator {
    public static final int STATE_HEADER = 0;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_FLUSHING = 3;
    public static final int STATE_END = 4;
    private static byte[] NO_BYTES = new byte[0];
    private static int MAX_OUTPUT_CHARS = 512;
    private static Buffer[] __reasons = new Buffer[505];
    protected int _state = 0;
    protected int _status = 0;
    protected int _version = 11;
    protected Buffer _reason;
    protected Buffer _method;
    protected String _uri;
    protected long _contentWritten = 0L;
    protected long _contentLength = -3L;
    protected boolean _last = false;
    protected boolean _head = false;
    protected boolean _noContent = false;
    protected boolean _close = false;
    protected Buffers _buffers;
    protected EndPoint _endp;
    protected int _headerBufferSize;
    protected int _contentBufferSize;
    protected Buffer _header;
    protected Buffer _buffer;
    protected Buffer _content;
    private boolean _sendServerVersion;

    protected static Buffer getReasonBuffer(int n) {
        Buffer buffer = n < __reasons.length ? __reasons[n] : null;
        return buffer == null ? null : buffer;
    }

    public static String getReason(int n) {
        Buffer buffer = n < __reasons.length ? __reasons[n] : null;
        return buffer == null ? TypeUtil.toString(n) : buffer.toString();
    }

    public AbstractGenerator(Buffers buffers, EndPoint endPoint, int n, int n2) {
        this._buffers = buffers;
        this._endp = endPoint;
        this._headerBufferSize = n;
        this._contentBufferSize = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(boolean bl) {
        this._state = 0;
        this._status = 0;
        this._version = 11;
        this._reason = null;
        this._last = false;
        this._head = false;
        this._noContent = false;
        this._close = false;
        this._contentWritten = 0L;
        this._contentLength = -3L;
        AbstractGenerator abstractGenerator = this;
        synchronized (abstractGenerator) {
            if (bl) {
                if (this._header != null) {
                    this._buffers.returnBuffer(this._header);
                }
                this._header = null;
                if (this._buffer != null) {
                    this._buffers.returnBuffer(this._buffer);
                }
                this._buffer = null;
            } else {
                if (this._header != null) {
                    this._header.clear();
                }
                if (this._buffer != null) {
                    this._buffers.returnBuffer(this._buffer);
                    this._buffer = null;
                }
            }
        }
        this._content = null;
        this._method = null;
    }

    @Override
    public void resetBuffer() {
        if (this._state >= 3) {
            throw new IllegalStateException("Flushed");
        }
        this._last = false;
        this._close = false;
        this._contentWritten = 0L;
        this._contentLength = -3L;
        this._content = null;
        if (this._buffer != null) {
            this._buffer.clear();
        }
    }

    @Override
    public int getContentBufferSize() {
        return this._contentBufferSize;
    }

    @Override
    public void increaseContentBufferSize(int n) {
        if (n > this._contentBufferSize) {
            this._contentBufferSize = n;
            if (this._buffer != null) {
                Buffer buffer = this._buffers.getBuffer(this._contentBufferSize);
                buffer.put(this._buffer);
                this._buffers.returnBuffer(this._buffer);
                this._buffer = buffer;
            }
        }
    }

    public Buffer getUncheckedBuffer() {
        return this._buffer;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    @Override
    public void setSendServerVersion(boolean bl) {
        this._sendServerVersion = bl;
    }

    public int getState() {
        return this._state;
    }

    public boolean isState(int n) {
        return this._state == n;
    }

    @Override
    public boolean isComplete() {
        return this._state == 4;
    }

    @Override
    public boolean isIdle() {
        return this._state == 0 && this._method == null && this._status == 0;
    }

    @Override
    public boolean isCommitted() {
        return this._state != 0;
    }

    public boolean isHead() {
        return this._head;
    }

    @Override
    public void setContentLength(long l) {
        this._contentLength = l < 0L ? -3L : l;
    }

    @Override
    public void setHead(boolean bl) {
        this._head = bl;
    }

    @Override
    public boolean isPersistent() {
        return !this._close;
    }

    @Override
    public void setPersistent(boolean bl) {
        this._close = !bl;
    }

    @Override
    public void setVersion(int n) {
        if (this._state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this._version = n;
        if (this._version == 9 && this._method != null) {
            this._noContent = true;
        }
    }

    public int getVersion() {
        return this._version;
    }

    @Override
    public void setRequest(String string, String string2) {
        this._method = string == null || "GET".equals(string) ? HttpMethods.GET_BUFFER : HttpMethods.CACHE.lookup(string);
        this._uri = string2;
        if (this._version == 9) {
            this._noContent = true;
        }
    }

    @Override
    public void setResponse(int n, String string) {
        if (this._state != 0) {
            throw new IllegalStateException("STATE!=START");
        }
        this._status = n;
        if (string != null) {
            int n2 = string.length();
            if (n2 > this._headerBufferSize / 2) {
                n2 = this._headerBufferSize / 2;
            }
            this._reason = new ByteArrayBuffer(n2);
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c != '\r' && c != '\n') {
                    this._reason.put((byte)c);
                    continue;
                }
                this._reason.put((byte)32);
            }
        }
    }

    protected abstract int prepareUncheckedAddContent() throws IOException;

    void uncheckedAddContent(int n) {
        this._buffer.put((byte)n);
    }

    void completeUncheckedAddContent() {
        if (this._noContent) {
            if (this._buffer != null) {
                this._buffer.clear();
            }
            return;
        }
        this._contentWritten += (long)this._buffer.length();
        if (this._head) {
            this._buffer.clear();
        }
    }

    @Override
    public boolean isBufferFull() {
        if (this._buffer != null && this._buffer.space() == 0) {
            if (this._buffer.length() == 0 && !this._buffer.isImmutable()) {
                this._buffer.compact();
            }
            return this._buffer.space() == 0;
        }
        return this._content != null && this._content.length() > 0;
    }

    @Override
    public boolean isContentWritten() {
        return this._contentLength >= 0L && this._contentWritten >= this._contentLength;
    }

    @Override
    public abstract void completeHeader(HttpFields var1, boolean var2) throws IOException;

    @Override
    public void complete() throws IOException {
        if (this._state == 0) {
            throw new IllegalStateException("State==HEADER");
        }
        if (this._contentLength >= 0L && this._contentLength != this._contentWritten && !this._head) {
            if (Log.isDebugEnabled()) {
                Log.debug("ContentLength written==" + this._contentWritten + " != contentLength==" + this._contentLength);
            }
            this._close = true;
        }
    }

    @Override
    public abstract long flush() throws IOException;

    @Override
    public void sendError(int n, String string, String string2, boolean bl) throws IOException {
        if (!this.isCommitted()) {
            this.setResponse(n, string);
            this._close = bl;
            this.completeHeader(null, false);
            if (string2 != null) {
                this.addContent(new View(new ByteArrayBuffer(string2)), true);
            }
            this.complete();
        }
    }

    @Override
    public long getContentWritten() {
        return this._contentWritten;
    }

    static /* synthetic */ byte[] access$000() {
        return NO_BYTES;
    }

    static {
        Field[] fieldArray = HttpServletResponse.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if ((fieldArray[i].getModifiers() & 8) == 0 || !fieldArray[i].getName().startsWith("SC_")) continue;
            try {
                int n = fieldArray[i].getInt(null);
                if (n >= __reasons.length) continue;
                AbstractGenerator.__reasons[n] = new ByteArrayBuffer(fieldArray[i].getName().substring(3));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static class OutputWriter
    extends Writer {
        private static final int WRITE_CONV = 0;
        private static final int WRITE_ISO1 = 1;
        private static final int WRITE_UTF8 = 2;
        Output _out;
        AbstractGenerator _generator;
        int _writeMode;
        int _surrogate;

        public OutputWriter(Output output) {
            this._out = output;
            this._generator = this._out._generator;
        }

        public void setCharacterEncoding(String string) {
            if (string == null || StringUtil.__ISO_8859_1.equalsIgnoreCase(string)) {
                this._writeMode = 1;
            } else if ("UTF-8".equalsIgnoreCase(string)) {
                this._writeMode = 2;
            } else {
                this._writeMode = 0;
                if (this._out._characterEncoding == null || !this._out._characterEncoding.equalsIgnoreCase(string)) {
                    this._out._converter = null;
                }
            }
            this._out._characterEncoding = string;
            if (this._out._bytes == null) {
                this._out._bytes = new ByteArrayOutputStream2(MAX_OUTPUT_CHARS);
            }
        }

        @Override
        public void close() throws IOException {
            this._out.close();
        }

        @Override
        public void flush() throws IOException {
            this._out.flush();
        }

        @Override
        public void write(String string, int n, int n2) throws IOException {
            while (n2 > MAX_OUTPUT_CHARS) {
                this.write(string, n, MAX_OUTPUT_CHARS);
                n += MAX_OUTPUT_CHARS;
                n2 -= MAX_OUTPUT_CHARS;
            }
            if (this._out._chars == null) {
                this._out._chars = new char[MAX_OUTPUT_CHARS];
            }
            char[] cArray = this._out._chars;
            string.getChars(n, n + n2, cArray, 0);
            this.write(cArray, 0, n2);
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            Output output = this._out;
            while (n2 > 0) {
                output._bytes.reset();
                int n3 = n2 > MAX_OUTPUT_CHARS ? MAX_OUTPUT_CHARS : n2;
                switch (this._writeMode) {
                    case 0: {
                        Object object = this.getConverter();
                        ((Writer)object).write(cArray, n, n3);
                        ((Writer)object).flush();
                        break;
                    }
                    case 1: {
                        int n4;
                        int n5;
                        Object object = output._bytes.getBuf();
                        int n6 = output._bytes.getCount();
                        if (n3 > ((Object)object).length - n6) {
                            n3 = ((Object)object).length - n6;
                        }
                        for (n5 = 0; n5 < n3; ++n5) {
                            n4 = cArray[n + n5];
                            object[n6++] = (byte)(n4 < 256 ? n4 : 63);
                        }
                        if (n6 < 0) break;
                        output._bytes.setCount(n6);
                        break;
                    }
                    case 2: {
                        int n4;
                        int n5;
                        Object object = output._bytes.getBuf();
                        int n6 = output._bytes.getCount();
                        if (n6 + n3 > ((Object)object).length) {
                            n3 = ((Object)object).length - n6;
                        }
                        for (n5 = 0; n5 < n3; ++n5) {
                            n4 = cArray[n + n5];
                            if (this._surrogate == 0) {
                                if (Character.isHighSurrogate((char)n4)) {
                                    this._surrogate = n4;
                                    continue;
                                }
                            } else if (Character.isLowSurrogate((char)n4)) {
                                n4 = Character.toCodePoint((char)this._surrogate, (char)n4);
                            } else {
                                n4 = this._surrogate;
                                this._surrogate = 0;
                                --n5;
                            }
                            if ((n4 & 0xFFFFFF80) == 0) {
                                if (n6 >= ((Object)object).length) {
                                    n3 = n5;
                                    break;
                                }
                                object[n6++] = (byte)n4;
                                continue;
                            }
                            if ((n4 & 0xFFFFF800) == 0) {
                                if (n6 + 2 > ((Object)object).length) {
                                    n3 = n5;
                                    break;
                                }
                                object[n6++] = (byte)(0xC0 | n4 >> 6);
                                object[n6++] = (byte)(0x80 | n4 & 0x3F);
                            } else if ((n4 & 0xFFFF0000) == 0) {
                                if (n6 + 3 > ((Object)object).length) {
                                    n3 = n5;
                                    break;
                                }
                                object[n6++] = (byte)(0xE0 | n4 >> 12);
                                object[n6++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 & 0x3F);
                            } else if ((n4 & 0xFF200000) == 0) {
                                if (n6 + 4 > ((Object)object).length) {
                                    n3 = n5;
                                    break;
                                }
                                object[n6++] = (byte)(0xF0 | n4 >> 18);
                                object[n6++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 & 0x3F);
                            } else if ((n4 & 0xF4000000) == 0) {
                                if (n6 + 5 > ((Object)object).length) {
                                    n3 = n5;
                                    break;
                                }
                                object[n6++] = (byte)(0xF8 | n4 >> 24);
                                object[n6++] = (byte)(0x80 | n4 >> 18 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 & 0x3F);
                            } else if ((n4 & Integer.MIN_VALUE) == 0) {
                                if (n6 + 6 > ((Object)object).length) {
                                    n3 = n5;
                                    break;
                                }
                                object[n6++] = (byte)(0xFC | n4 >> 30);
                                object[n6++] = (byte)(0x80 | n4 >> 24 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 >> 18 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                                object[n6++] = (byte)(0x80 | n4 & 0x3F);
                            } else {
                                object[n6++] = 63;
                            }
                            this._surrogate = 0;
                            if (n6 != ((Object)object).length) continue;
                            n3 = n5 + 1;
                            break;
                        }
                        output._bytes.setCount(n6);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                output._bytes.writeTo((OutputStream)((Object)output));
                n2 -= n3;
                n += n3;
            }
        }

        private Writer getConverter() throws IOException {
            if (this._out._converter == null) {
                this._out._converter = new OutputStreamWriter((OutputStream)this._out._bytes, this._out._characterEncoding);
            }
            return this._out._converter;
        }
    }

    public static class Output
    extends ServletOutputStream {
        protected AbstractGenerator _generator;
        protected long _maxIdleTime;
        protected ByteArrayBuffer _buf = new ByteArrayBuffer(AbstractGenerator.access$000());
        protected boolean _closed;
        String _characterEncoding;
        Writer _converter;
        char[] _chars;
        ByteArrayOutputStream2 _bytes;

        public Output(AbstractGenerator abstractGenerator, long l) {
            this._generator = abstractGenerator;
            this._maxIdleTime = l;
        }

        public void close() throws IOException {
            this._closed = true;
        }

        void blockForOutput() throws IOException {
            if (this._generator._endp.isBlocking()) {
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    this._generator._endp.close();
                    throw iOException;
                }
            } else {
                if (!this._generator._endp.blockWritable(this._maxIdleTime)) {
                    this._generator._endp.close();
                    throw new EofException("timeout");
                }
                this._generator.flush();
            }
        }

        void reopen() {
            this._closed = false;
        }

        public void flush() throws IOException {
            Buffer buffer = this._generator._content;
            Buffer buffer2 = this._generator._buffer;
            if (buffer != null && buffer.length() > 0 || buffer2 != null && buffer2.length() > 0 || this._generator.isBufferFull()) {
                this._generator.flush();
                while ((buffer != null && buffer.length() > 0 || buffer2 != null && buffer2.length() > 0) && this._generator._endp.isOpen()) {
                    this.blockForOutput();
                }
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this._buf.wrap(byArray, n, n2);
            this.write(this._buf);
        }

        public void write(byte[] byArray) throws IOException {
            this._buf.wrap(byArray);
            this.write(this._buf);
        }

        public void write(int n) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (!this._generator._endp.isOpen()) {
                throw new EofException();
            }
            while (this._generator.isBufferFull()) {
                this.blockForOutput();
                if (this._closed) {
                    throw new IOException("Closed");
                }
                if (this._generator._endp.isOpen()) continue;
                throw new EofException();
            }
            if (this._generator.addContent((byte)n)) {
                this.flush();
            }
            if (this._generator.isContentWritten()) {
                this.flush();
                this.close();
            }
        }

        private void write(Buffer buffer) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (!this._generator._endp.isOpen()) {
                throw new EofException();
            }
            while (this._generator.isBufferFull()) {
                this.blockForOutput();
                if (this._closed) {
                    throw new IOException("Closed");
                }
                if (this._generator._endp.isOpen()) continue;
                throw new EofException();
            }
            this._generator.addContent(buffer, false);
            if (this._generator.isBufferFull()) {
                this.flush();
            }
            if (this._generator.isContentWritten()) {
                this.flush();
                this.close();
            }
            while (buffer.length() > 0 && this._generator._endp.isOpen()) {
                this.blockForOutput();
            }
        }

        public void print(String string) throws IOException {
            this.write(string.getBytes());
        }
    }
}

