/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.jetty.AbstractGenerator;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.EncodedHttpURI;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.Generator;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpGenerator;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpParser;
import org.mortbay.jetty.HttpURI;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.Parser;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.Server;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.URIUtil;
import org.mortbay.util.ajax.Continuation;

public class HttpConnection
implements Connection {
    private static int UNKNOWN = -2;
    private static ThreadLocal __currentConnection = new ThreadLocal();
    private long _timeStamp = System.currentTimeMillis();
    private int _requests;
    private boolean _handling;
    private boolean _destroy;
    protected final Connector _connector;
    protected final EndPoint _endp;
    protected final Server _server;
    protected final HttpURI _uri;
    protected final Parser _parser;
    protected final HttpFields _requestFields;
    protected final Request _request;
    protected ServletInputStream _in;
    protected final Generator _generator;
    protected final HttpFields _responseFields;
    protected final Response _response;
    protected Output _out;
    protected OutputWriter _writer;
    protected PrintWriter _printWriter;
    int _include;
    private Object _associatedObject;
    private transient int _expect = UNKNOWN;
    private transient int _version = UNKNOWN;
    private transient boolean _head = false;
    private transient boolean _host = false;
    private transient boolean _delayedHandling = false;

    public static HttpConnection getCurrentConnection() {
        return (HttpConnection)__currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection httpConnection) {
        __currentConnection.set(httpConnection);
    }

    public HttpConnection(Connector connector, EndPoint endPoint, Server server) {
        this._uri = URIUtil.__CHARSET == "UTF-8" ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endPoint;
        this._parser = new HttpParser(this._connector, endPoint, new RequestHandler(), this._connector.getHeaderBufferSize(), this._connector.getRequestBufferSize());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(this._connector, this._endp, this._connector.getHeaderBufferSize(), this._connector.getResponseBufferSize());
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    protected HttpConnection(Connector connector, EndPoint endPoint, Server server, Parser parser, Generator generator, Request request) {
        this._uri = URIUtil.__CHARSET == "UTF-8" ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._endp = endPoint;
        this._parser = parser;
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields();
        this._request = request;
        this._response = new Response(this);
        this._generator = generator;
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            this._destroy = true;
            if (!this._handling) {
                if (this._parser != null) {
                    this._parser.reset(true);
                }
                if (this._generator != null) {
                    this._generator.reset(true);
                }
                if (this._requestFields != null) {
                    this._requestFields.destroy();
                }
                if (this._responseFields != null) {
                    this._responseFields.destroy();
                }
            }
        }
    }

    public Parser getParser() {
        return this._parser;
    }

    public int getRequests() {
        return this._requests;
    }

    public long getTimeStamp() {
        return this._timeStamp;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object object) {
        this._associatedObject = object;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this._connector != null) {
            return this._connector.isIntegral(request);
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this._endp;
    }

    public boolean getResolveNames() {
        return this._connector.getResolveNames();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() {
        if (this._in == null) {
            this._in = new HttpParser.Input((HttpParser)this._parser, this._connector.getMaxIdleTime());
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String string) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = new PrintWriter(this._writer){

                @Override
                public void close() {
                    try {
                        this.out.close();
                    }
                    catch (IOException iOException) {
                        Log.debug(iOException);
                        this.setError();
                    }
                }
            };
        }
        this._writer.setCharacterEncoding(string);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle() throws IOException {
        boolean bl = true;
        int n = 0;
        while (bl) {
            Object object;
            block43: {
                try {
                    object = this;
                    synchronized (object) {
                        if (this._handling) {
                            throw new IllegalStateException();
                        }
                        this._handling = true;
                    }
                    HttpConnection.setCurrentConnection(this);
                    long l = 0L;
                    Continuation continuation = this._request.getContinuation();
                    if (continuation != null && continuation.isPending()) {
                        Log.debug("resume continuation {}", continuation);
                        if (this._request.getMethod() == null) {
                            throw new IllegalStateException();
                        }
                        this.handleRequest();
                        break block43;
                    }
                    if (!this._parser.isComplete()) {
                        l = this._parser.parseAvailable();
                    }
                    while (this._generator.isCommitted() && !this._generator.isComplete()) {
                        long l2 = this._generator.flush();
                        l += l2;
                        if (l2 <= 0L) break;
                        if (!this._endp.isBufferingOutput()) continue;
                        this._endp.flush();
                    }
                    if (this._endp.isBufferingOutput()) {
                        this._endp.flush();
                        if (!this._endp.isBufferingOutput()) {
                            n = 0;
                        }
                    }
                    if (l > 0L) {
                        n = 0;
                        break block43;
                    }
                    if (n++ < 2) break block43;
                }
                catch (HttpException httpException) {
                    try {
                        if (Log.isDebugEnabled()) {
                            Log.debug("uri=" + this._uri);
                            Log.debug("fields=" + this._requestFields);
                            Log.debug(httpException);
                        }
                        this._generator.sendError(httpException.getStatus(), httpException.getReason(), null, true);
                        this._parser.reset(true);
                        this._endp.close();
                        throw httpException;
                    }
                    catch (Throwable throwable) {
                        HttpConnection.setCurrentConnection(null);
                        bl = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                        Object object2 = this;
                        synchronized (object2) {
                            this._handling = false;
                            if (this._destroy) {
                                this.destroy();
                                return;
                            }
                        }
                        if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                            if (!this._generator.isPersistent()) {
                                this._parser.reset(true);
                                bl = false;
                            }
                            if (bl) {
                                this.reset(false);
                                bl = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                            } else {
                                this.reset(true);
                            }
                            n = 0;
                        }
                        if ((object2 = this._request.getContinuation()) != null && object2.isPending()) break;
                        if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp instanceof SelectChannelEndPoint) {
                            ((SelectChannelEndPoint)this._endp).setWritable(false);
                        }
                        throw throwable;
                    }
                }
                HttpConnection.setCurrentConnection(null);
                bl = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                Object object3 = this;
                synchronized (object3) {
                    this._handling = false;
                    if (this._destroy) {
                        this.destroy();
                        return;
                    }
                }
                if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                    if (!this._generator.isPersistent()) {
                        this._parser.reset(true);
                        bl = false;
                    }
                    if (bl) {
                        this.reset(false);
                        bl = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                    } else {
                        this.reset(true);
                    }
                    n = 0;
                }
                if ((object3 = this._request.getContinuation()) != null && object3.isPending()) break;
                if (this._generator.isCommitted() && !this._generator.isComplete() && this._endp instanceof SelectChannelEndPoint) {
                    ((SelectChannelEndPoint)this._endp).setWritable(false);
                }
                return;
            }
            HttpConnection.setCurrentConnection(null);
            bl = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
            object = this;
            synchronized (object) {
                this._handling = false;
                if (this._destroy) {
                    this.destroy();
                    return;
                }
            }
            if (this._parser.isComplete() && this._generator.isComplete() && !this._endp.isBufferingOutput()) {
                if (!this._generator.isPersistent()) {
                    this._parser.reset(true);
                    bl = false;
                }
                if (bl) {
                    this.reset(false);
                    bl = this._parser.isMoreInBuffer() || this._endp.isBufferingInput();
                } else {
                    this.reset(true);
                }
                n = 0;
            }
            if ((object = this._request.getContinuation()) != null && object.isPending()) break;
            if (!this._generator.isCommitted() || this._generator.isComplete() || !(this._endp instanceof SelectChannelEndPoint)) continue;
            ((SelectChannelEndPoint)this._endp).setWritable(false);
        }
    }

    public void reset(boolean bl) {
        this._parser.reset(bl);
        this._requestFields.clear();
        this._request.recycle();
        this._generator.reset(bl);
        this._responseFields.clear();
        this._response.recycle();
        this._uri.clear();
    }

    /*
     * Exception decompiling
     */
    protected void handleRequest() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void commitResponse(boolean bl) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                this._generator.completeHeader(this._responseFields, bl);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                Log.warn("header full: " + runtimeException);
                if (Log.isDebugEnabled() && this._generator instanceof HttpGenerator) {
                    Log.debug(((HttpGenerator)this._generator)._header.toDetailString(), runtimeException);
                }
                this._response.reset();
                this._generator.reset(true);
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw runtimeException;
            }
        }
        if (bl) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                this._generator.completeHeader(this._responseFields, true);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                Log.warn("header full: " + runtimeException);
                Log.debug(runtimeException);
                this._response.reset();
                this._generator.reset(true);
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw runtimeException;
            }
        }
        this._generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flush();
        }
        catch (IOException iOException) {
            throw iOException instanceof EofException ? iOException : new EofException(iOException);
        }
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    @Override
    public boolean isIdle() {
        return this._generator.isIdle() && (this._parser.isIdle() || this._delayedHandling);
    }

    public class OutputWriter
    extends AbstractGenerator.OutputWriter {
        OutputWriter() {
            super(HttpConnection.this._out);
        }
    }

    public class Output
    extends AbstractGenerator.Output {
        Output() {
            super((AbstractGenerator)HttpConnection.this._generator, HttpConnection.this._connector.getMaxIdleTime());
        }

        @Override
        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            if (!HttpConnection.this.isIncluding() && !this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(true);
            } else {
                HttpConnection.this.flushResponse();
            }
            super.close();
        }

        @Override
        public void flush() throws IOException {
            if (!this._generator.isCommitted()) {
                HttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        @Override
        public void print(String string) throws IOException {
            if (this._closed) {
                throw new IOException("Closed");
            }
            PrintWriter printWriter = HttpConnection.this.getPrintWriter(null);
            printWriter.print(string);
        }

        public void sendResponse(Buffer buffer) throws IOException {
            ((HttpGenerator)this._generator).sendResponse(buffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendContent(Object object) throws IOException {
            Object object2;
            Object object3;
            Resource resource = null;
            if (this._closed) {
                throw new IOException("Closed");
            }
            if (this._generator.getContentWritten() > 0L) {
                throw new IllegalStateException("!empty");
            }
            if (object instanceof HttpContent) {
                object3 = (HttpContent)object;
                Buffer buffer = object3.getContentType();
                if (buffer != null && !HttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                    object2 = HttpConnection.this._response.getSetCharacterEncoding();
                    if (object2 == null) {
                        HttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, buffer);
                    } else if (buffer instanceof BufferCache.CachedBuffer) {
                        BufferCache.CachedBuffer cachedBuffer = ((BufferCache.CachedBuffer)buffer).getAssociate(object2);
                        if (cachedBuffer != null) {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, cachedBuffer);
                        } else {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, buffer + ";charset=" + QuotedStringTokenizer.quote((String)object2, ";= "));
                        }
                    } else {
                        HttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, buffer + ";charset=" + QuotedStringTokenizer.quote((String)object2, ";= "));
                    }
                }
                if (object3.getContentLength() > 0L) {
                    HttpConnection.this._responseFields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, object3.getContentLength());
                }
                object2 = object3.getLastModified();
                long l = object3.getResource().lastModified();
                if (object2 != null) {
                    HttpConnection.this._responseFields.put(HttpHeaders.LAST_MODIFIED_BUFFER, (Buffer)object2, l);
                } else if (object3.getResource() != null && l != -1L) {
                    HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, l);
                }
                object = object3.getBuffer();
                if (object == null) {
                    object = object3.getInputStream();
                }
            } else if (object instanceof Resource) {
                resource = (Resource)object;
                HttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, resource.lastModified());
                object = resource.getInputStream();
            }
            if (object instanceof Buffer) {
                this._generator.addContent((Buffer)object, true);
                HttpConnection.this.commitResponse(true);
            } else if (object instanceof InputStream) {
                object3 = (InputStream)object;
                try {
                    int n = this._generator.prepareUncheckedAddContent();
                    object2 = this._generator.getUncheckedBuffer();
                    int n2 = object2.readFrom((InputStream)object3, n);
                    while (n2 >= 0) {
                        this._generator.completeUncheckedAddContent();
                        HttpConnection.this._out.flush();
                        n = this._generator.prepareUncheckedAddContent();
                        object2 = this._generator.getUncheckedBuffer();
                        n2 = object2.readFrom((InputStream)object3, n);
                    }
                    this._generator.completeUncheckedAddContent();
                    HttpConnection.this._out.flush();
                }
                finally {
                    if (resource != null) {
                        resource.release();
                    } else {
                        ((InputStream)object3).close();
                    }
                }
            } else {
                throw new IllegalArgumentException("unknown content type?");
            }
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        private String _charset;

        private RequestHandler() {
        }

        @Override
        public void startRequest(Buffer buffer, Buffer buffer2, Buffer buffer3) throws IOException {
            HttpConnection.this._host = false;
            HttpConnection.this._expect = UNKNOWN;
            HttpConnection.this._delayedHandling = false;
            this._charset = null;
            if (HttpConnection.this._request.getTimeStamp() == 0L) {
                HttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            }
            HttpConnection.this._request.setMethod(buffer.toString());
            try {
                HttpConnection.this._uri.parse(buffer2.array(), buffer2.getIndex(), buffer2.length());
                HttpConnection.this._request.setUri(HttpConnection.this._uri);
                if (buffer3 == null) {
                    HttpConnection.this._request.setProtocol("");
                    HttpConnection.this._version = 9;
                } else {
                    buffer3 = HttpVersions.CACHE.get(buffer3);
                    HttpConnection.this._version = HttpVersions.CACHE.getOrdinal(buffer3);
                    if (HttpConnection.this._version <= 0) {
                        HttpConnection.this._version = 10;
                    }
                    HttpConnection.this._request.setProtocol(buffer3.toString());
                }
                HttpConnection.this._head = buffer == HttpMethods.HEAD_BUFFER;
            }
            catch (Exception exception) {
                throw new HttpException(400, null, exception);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void parsedHeader(Buffer buffer, Buffer buffer2) {
            int n = HttpHeaders.CACHE.getOrdinal(buffer);
            switch (n) {
                case 27: {
                    HttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    buffer2 = HttpHeaderValues.CACHE.lookup(buffer2);
                    HttpConnection.this._expect = HttpHeaderValues.CACHE.getOrdinal(buffer2);
                    break;
                }
                case 21: 
                case 40: {
                    buffer2 = HttpHeaderValues.CACHE.lookup(buffer2);
                    break;
                }
                case 16: {
                    buffer2 = MimeTypes.CACHE.lookup(buffer2);
                    this._charset = MimeTypes.getCharsetFromContentType(buffer2);
                    break;
                }
                case 1: {
                    int n2 = HttpHeaderValues.CACHE.getOrdinal(buffer2);
                    switch (n2) {
                        case -1: {
                            String[] stringArray = buffer2.toString().split(",");
                            block16: for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                                BufferCache.CachedBuffer cachedBuffer = HttpHeaderValues.CACHE.get(stringArray[i].trim());
                                if (cachedBuffer == null) continue;
                                switch (cachedBuffer.getOrdinal()) {
                                    case 1: {
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                                        HttpConnection.this._generator.setPersistent(false);
                                        continue block16;
                                    }
                                    case 5: {
                                        if (HttpConnection.this._version != 10) continue block16;
                                        HttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                                        continue block16;
                                    }
                                }
                            }
                            break;
                        }
                        case 1: {
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                            HttpConnection.this._generator.setPersistent(false);
                            break;
                        }
                        case 5: {
                            if (HttpConnection.this._version != 10) break;
                            HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                        }
                    }
                    break;
                }
            }
            HttpConnection.this._requestFields.add(buffer, buffer2);
        }

        @Override
        public void headerComplete() throws IOException {
            HttpConnection.this._requests++;
            HttpConnection.this._generator.setVersion(HttpConnection.this._version);
            switch (HttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    break;
                }
                case 11: {
                    HttpConnection.this._generator.setHead(HttpConnection.this._head);
                    if (HttpConnection.this._server.getSendDateHeader()) {
                        HttpConnection.this._responseFields.put(HttpHeaders.DATE_BUFFER, HttpConnection.this._request.getTimeStampBuffer(), HttpConnection.this._request.getTimeStamp());
                    }
                    if (!HttpConnection.this._host) {
                        HttpConnection.this._generator.setResponse(400, null);
                        HttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        HttpConnection.this._generator.completeHeader(HttpConnection.this._responseFields, true);
                        HttpConnection.this._generator.complete();
                        return;
                    }
                    if (HttpConnection.this._expect == UNKNOWN) break;
                    if (HttpConnection.this._expect == 6) {
                        if (((HttpParser)HttpConnection.this._parser).getHeaderBuffer() != null && ((HttpParser)HttpConnection.this._parser).getHeaderBuffer().length() >= 2) break;
                        HttpConnection.this._generator.setResponse(100, null);
                        HttpConnection.this._generator.completeHeader(null, true);
                        HttpConnection.this._generator.complete();
                        HttpConnection.this._generator.reset(false);
                        break;
                    }
                    if (HttpConnection.this._expect == 7) break;
                    HttpConnection.this._generator.sendError(417, null, null, true);
                    return;
                }
            }
            if (this._charset != null) {
                HttpConnection.this._request.setCharacterEncodingUnchecked(this._charset);
            }
            if (((HttpParser)HttpConnection.this._parser).getContentLength() <= 0L && !((HttpParser)HttpConnection.this._parser).isChunking()) {
                HttpConnection.this.handleRequest();
            } else {
                HttpConnection.this._delayedHandling = true;
            }
        }

        @Override
        public void content(Buffer buffer) throws IOException {
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        @Override
        public void messageComplete(long l) throws IOException {
            if (HttpConnection.this._delayedHandling) {
                HttpConnection.this._delayedHandling = false;
                HttpConnection.this.handleRequest();
            }
        }

        @Override
        public void startResponse(Buffer buffer, int n, Buffer buffer2) {
            Log.debug("Bad request!: " + buffer + " " + n + " " + buffer2);
        }
    }
}

