/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.Cookie;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferDateCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpOnlyCookie;
import org.mortbay.util.LazyList;
import org.mortbay.util.QuotedStringTokenizer;
import org.mortbay.util.StringMap;
import org.mortbay.util.StringUtil;

public class HttpFields {
    public static final String __separators = ", \t";
    private static String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
    private static TimeZone __GMT = TimeZone.getTimeZone("GMT");
    public static final BufferDateCache __dateCache = new BufferDateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    private static final String[] __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
    private static int __dateReceiveInit = 3;
    private static SimpleDateFormat[] __dateReceive;
    public static final String __01Jan1970;
    public static final Buffer __01Jan1970_BUFFER;
    protected ArrayList _fields = new ArrayList(20);
    protected int _revision;
    protected HashMap _bufferMap = new HashMap(32);
    protected SimpleDateFormat[] _dateReceive = new SimpleDateFormat[__dateReceive.length];
    private StringBuffer _dateBuffer;
    private Calendar _calendar;
    private static Float __one;
    private static Float __zero;
    private static StringMap __qualities;

    public static String formatDate(long l, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(32);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(__GMT);
        gregorianCalendar.setTimeInMillis(l);
        HttpFields.formatDate(stringBuffer, gregorianCalendar, bl);
        return stringBuffer.toString();
    }

    public static String formatDate(Calendar calendar, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(32);
        HttpFields.formatDate(stringBuffer, calendar, bl);
        return stringBuffer.toString();
    }

    public static String formatDate(StringBuffer stringBuffer, long l, boolean bl) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(__GMT);
        gregorianCalendar.setTimeInMillis(l);
        HttpFields.formatDate(stringBuffer, gregorianCalendar, bl);
        return stringBuffer.toString();
    }

    public static void formatDate(StringBuffer stringBuffer, Calendar calendar, boolean bl) {
        int n = calendar.get(7);
        int n2 = calendar.get(5);
        int n3 = calendar.get(2);
        int n4 = calendar.get(1);
        int n5 = n4 / 100;
        n4 %= 100;
        int n6 = (int)(calendar.getTimeInMillis() / 1000L % 86400L);
        int n7 = n6 % 60;
        int n8 = (n6 /= 60) % 60;
        int n9 = n6 / 60;
        stringBuffer.append(DAYS[n]);
        stringBuffer.append(',');
        stringBuffer.append(' ');
        StringUtil.append2digits(stringBuffer, n2);
        if (bl) {
            stringBuffer.append('-');
            stringBuffer.append(MONTHS[n3]);
            stringBuffer.append('-');
            StringUtil.append2digits(stringBuffer, n4);
        } else {
            stringBuffer.append(' ');
            stringBuffer.append(MONTHS[n3]);
            stringBuffer.append(' ');
            StringUtil.append2digits(stringBuffer, n5);
            StringUtil.append2digits(stringBuffer, n4);
        }
        stringBuffer.append(' ');
        StringUtil.append2digits(stringBuffer, n9);
        stringBuffer.append(':');
        StringUtil.append2digits(stringBuffer, n8);
        stringBuffer.append(':');
        StringUtil.append2digits(stringBuffer, n7);
        stringBuffer.append(" GMT");
    }

    public Enumeration getFieldNames() {
        final int n = this._revision;
        return new Enumeration(){
            int i = 0;
            Field field = null;

            @Override
            public boolean hasMoreElements() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field field;
                    if ((field = (Field)HttpFields.this._fields.get(this.i++)) == null || field._prev != null || field._revision != n) continue;
                    this.field = field;
                    return true;
                }
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.field != null || this.hasMoreElements()) {
                    String string = BufferUtil.to8859_1_String(this.field._name);
                    this.field = null;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator getFields() {
        final int n = this._revision;
        return new Iterator(){
            int i = 0;
            Field field = null;

            @Override
            public boolean hasNext() {
                if (this.field != null) {
                    return true;
                }
                while (this.i < HttpFields.this._fields.size()) {
                    Field field;
                    if ((field = (Field)HttpFields.this._fields.get(this.i++)) == null || field._revision != n) continue;
                    this.field = field;
                    return true;
                }
                return false;
            }

            public Object next() {
                if (this.field != null || this.hasNext()) {
                    Field field = this.field;
                    this.field = null;
                    return field;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Field getField(String string) {
        return (Field)this._bufferMap.get(HttpHeaders.CACHE.lookup(string));
    }

    private Field getField(Buffer buffer) {
        return (Field)this._bufferMap.get(buffer);
    }

    public boolean containsKey(Buffer buffer) {
        Field field = this.getField(buffer);
        return field != null && field._revision == this._revision;
    }

    public boolean containsKey(String string) {
        Field field = this.getField(string);
        return field != null && field._revision == this._revision;
    }

    public String getStringField(String string) {
        Field field = this.getField(string);
        if (field != null && field._revision == this._revision) {
            return field.getValue();
        }
        return null;
    }

    public String getStringField(Buffer buffer) {
        Field field = this.getField(buffer);
        if (field != null && field._revision == this._revision) {
            return BufferUtil.to8859_1_String(field._value);
        }
        return null;
    }

    public Buffer get(Buffer buffer) {
        Field field = this.getField(buffer);
        if (field != null && field._revision == this._revision) {
            return field._value;
        }
        return null;
    }

    public Enumeration getValues(String string) {
        final Field field = this.getField(string);
        if (field == null) {
            return null;
        }
        final int n = this._revision;
        return new Enumeration(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.f != null && this.f._revision != n) {
                    this.f = this.f._next;
                }
                return this.f != null;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field field2 = this.f;
                do {
                    this.f = this.f._next;
                } while (this.f != null && this.f._revision != n);
                return field2.getValue();
            }
        };
    }

    public Enumeration getValues(Buffer buffer) {
        final Field field = this.getField(buffer);
        if (field == null) {
            return null;
        }
        final int n = this._revision;
        return new Enumeration(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                while (this.f != null && this.f._revision != n) {
                    this.f = this.f._next;
                }
                return this.f != null;
            }

            public Object nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field field2 = this.f;
                this.f = this.f._next;
                while (this.f != null && this.f._revision != n) {
                    this.f = this.f._next;
                }
                return field2.getValue();
            }
        };
    }

    public Enumeration getValues(String string, final String string2) {
        final Enumeration enumeration = this.getValues(string);
        if (enumeration == null) {
            return null;
        }
        return new Enumeration(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.tok = new QuotedStringTokenizer(string, string2, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            public Object nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String string = (String)this.tok.nextElement();
                if (string != null) {
                    string = string.trim();
                }
                return string;
            }
        };
    }

    public void put(String string, String string2) {
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        Buffer buffer2 = null;
        if (string2 != null) {
            buffer2 = HttpHeaderValues.CACHE.lookup(string2);
        }
        this.put(buffer, buffer2, -1L);
    }

    public void put(Buffer buffer, String string) {
        Buffer buffer2 = HttpHeaderValues.CACHE.lookup(string);
        this.put(buffer, buffer2, -1L);
    }

    public void put(Buffer buffer, Buffer buffer2) {
        this.put(buffer, buffer2, -1L);
    }

    public void put(Buffer buffer, Buffer buffer2, long l) {
        Field field;
        if (buffer2 == null) {
            this.remove(buffer);
            return;
        }
        if (!(buffer instanceof BufferCache.CachedBuffer)) {
            buffer = HttpHeaders.CACHE.lookup(buffer);
        }
        if ((field = (Field)this._bufferMap.get(buffer)) != null) {
            field.reset(buffer2, l, this._revision);
            field = field._next;
            while (field != null) {
                field.clear();
                field = field._next;
            }
            return;
        }
        field = new Field(buffer, buffer2, l, this._revision);
        this._fields.add(field);
        this._bufferMap.put(field.getNameBuffer(), field);
    }

    public void put(String string, List list) {
        if (list == null || list.size() == 0) {
            this.remove(string);
            return;
        }
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        Object e = list.get(0);
        if (e != null) {
            this.put(buffer, HttpHeaderValues.CACHE.lookup(e.toString()));
        } else {
            this.remove(buffer);
        }
        if (list.size() > 1) {
            Iterator iterator = list.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                e = iterator.next();
                if (e == null) continue;
                this.put(buffer, HttpHeaderValues.CACHE.lookup(e.toString()));
            }
        }
    }

    public void add(String string, String string2) throws IllegalArgumentException {
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        Buffer buffer2 = HttpHeaderValues.CACHE.lookup(string2);
        this.add(buffer, buffer2, -1L);
    }

    public void add(Buffer buffer, Buffer buffer2) throws IllegalArgumentException {
        this.add(buffer, buffer2, -1L);
    }

    private void add(Buffer buffer, Buffer buffer2, long l) throws IllegalArgumentException {
        if (buffer2 == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!(buffer instanceof BufferCache.CachedBuffer)) {
            buffer = HttpHeaders.CACHE.lookup(buffer);
        }
        Field field = (Field)this._bufferMap.get(buffer);
        Field field2 = null;
        if (field != null) {
            while (field != null && field._revision == this._revision) {
                field2 = field;
                field = field._next;
            }
        }
        if (field != null) {
            field.reset(buffer2, l, this._revision);
        } else {
            field = new Field(buffer, buffer2, l, this._revision);
            if (field2 != null) {
                field._prev = field2;
                field2._next = field;
            } else {
                this._bufferMap.put(field.getNameBuffer(), field);
            }
            this._fields.add(field);
        }
    }

    public void remove(String string) {
        this.remove(HttpHeaders.CACHE.lookup(string));
    }

    public void remove(Buffer buffer) {
        Field field = (Field)this._bufferMap.get(buffer);
        if (field != null) {
            while (field != null) {
                field.clear();
                field = field._next;
            }
        }
    }

    public long getLongField(String string) throws NumberFormatException {
        Field field = this.getField(string);
        if (field != null && field._revision == this._revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    public long getLongField(Buffer buffer) throws NumberFormatException {
        Field field = this.getField(buffer);
        if (field != null && field._revision == this._revision) {
            return field.getLongValue();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDateField(String string) {
        int n;
        Field field = this.getField(string);
        if (field == null || field._revision != this._revision) {
            return -1L;
        }
        if (field._numValue != -1L) {
            return field._numValue;
        }
        String string2 = HttpFields.valueParameters(BufferUtil.to8859_1_String(field._value), null);
        if (string2 == null) {
            return -1L;
        }
        for (n = 0; n < __dateReceiveInit; ++n) {
            if (this._dateReceive[n] == null) {
                this._dateReceive[n] = (SimpleDateFormat)__dateReceive[n].clone();
            }
            try {
                Date date = (Date)this._dateReceive[n].parseObject(string2);
                return field._numValue = date.getTime();
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (string2.endsWith(" GMT")) {
            string2 = string2.substring(0, string2.length() - 4);
            for (n = 0; n < __dateReceiveInit; ++n) {
                try {
                    Date date = (Date)this._dateReceive[n].parseObject(string2);
                    return field._numValue = date.getTime();
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        SimpleDateFormat[] simpleDateFormatArray = __dateReceive;
        synchronized (__dateReceive) {
            int n2;
            for (n2 = __dateReceiveInit; n2 < this._dateReceive.length; ++n2) {
                if (this._dateReceive[n2] == null) {
                    if (__dateReceive[n2] == null) {
                        HttpFields.__dateReceive[n2] = new SimpleDateFormat(__dateReceiveFmt[n2], Locale.US);
                        __dateReceive[n2].setTimeZone(__GMT);
                    }
                    this._dateReceive[n2] = (SimpleDateFormat)__dateReceive[n2].clone();
                }
                try {
                    Date date = (Date)this._dateReceive[n2].parseObject(string2);
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return field._numValue = date.getTime();
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (string2.endsWith(" GMT")) {
                string2 = string2.substring(0, string2.length() - 4);
                for (n2 = 0; n2 < this._dateReceive.length; ++n2) {
                    try {
                        Date date = (Date)this._dateReceive[n2].parseObject(string2);
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        return field._numValue = date.getTime();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            throw new IllegalArgumentException("Cannot convert date: " + string2);
        }
    }

    public void putLongField(Buffer buffer, long l) {
        Buffer buffer2 = BufferUtil.toBuffer(l);
        this.put(buffer, buffer2, l);
    }

    public void putLongField(String string, long l) {
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        Buffer buffer2 = BufferUtil.toBuffer(l);
        this.put(buffer, buffer2, l);
    }

    public void addLongField(String string, long l) {
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        Buffer buffer2 = BufferUtil.toBuffer(l);
        this.add(buffer, buffer2, l);
    }

    public void addLongField(Buffer buffer, long l) {
        Buffer buffer2 = BufferUtil.toBuffer(l);
        this.add(buffer, buffer2, l);
    }

    public void putDateField(Buffer buffer, long l) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new GregorianCalendar(__GMT);
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(l);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(this._dateBuffer.toString());
        this.put(buffer, byteArrayBuffer, l);
    }

    public void putDateField(String string, long l) {
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        this.putDateField(buffer, l);
    }

    public void addDateField(String string, long l) {
        if (this._dateBuffer == null) {
            this._dateBuffer = new StringBuffer(32);
            this._calendar = new GregorianCalendar(__GMT);
        }
        this._dateBuffer.setLength(0);
        this._calendar.setTimeInMillis(l);
        HttpFields.formatDate(this._dateBuffer, this._calendar, false);
        Buffer buffer = HttpHeaders.CACHE.lookup(string);
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(this._dateBuffer.toString());
        this.add(buffer, byteArrayBuffer, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSetCookie(Cookie cookie) {
        String string = cookie.getName();
        String string2 = cookie.getValue();
        int n = cookie.getVersion();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        String string3 = null;
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            long l;
            String string4;
            String string5;
            QuotedStringTokenizer.quoteIfNeeded(stringBuffer, string);
            stringBuffer.append('=');
            if (string2 != null && string2.length() > 0) {
                QuotedStringTokenizer.quoteIfNeeded(stringBuffer, string2);
            }
            if (n > 0) {
                stringBuffer.append(";Version=");
                stringBuffer.append(n);
                string5 = cookie.getComment();
                if (string5 != null && string5.length() > 0) {
                    stringBuffer.append(";Comment=");
                    QuotedStringTokenizer.quoteIfNeeded(stringBuffer, string5);
                }
            }
            if ((string5 = cookie.getPath()) != null && string5.length() > 0) {
                stringBuffer.append(";Path=");
                if (string5.startsWith("\"")) {
                    stringBuffer.append(string5);
                } else {
                    QuotedStringTokenizer.quoteIfNeeded(stringBuffer, string5);
                }
            }
            if ((string4 = cookie.getDomain()) != null && string4.length() > 0) {
                stringBuffer.append(";Domain=");
                QuotedStringTokenizer.quoteIfNeeded(stringBuffer, string4.toLowerCase());
            }
            if ((l = (long)cookie.getMaxAge()) >= 0L) {
                if (n == 0) {
                    stringBuffer.append(";Expires=");
                    if (l == 0L) {
                        stringBuffer.append(__01Jan1970);
                    } else {
                        HttpFields.formatDate(stringBuffer, System.currentTimeMillis() + 1000L * l, true);
                    }
                } else {
                    stringBuffer.append(";Max-Age=");
                    stringBuffer.append(l);
                }
            } else if (n > 0) {
                stringBuffer.append(";Discard");
            }
            if (cookie.getSecure()) {
                stringBuffer.append(";Secure");
            }
            if (cookie instanceof HttpOnlyCookie) {
                stringBuffer.append(";HttpOnly");
            }
            string3 = stringBuffer.toString();
        }
        this.put(HttpHeaders.EXPIRES_BUFFER, __01Jan1970_BUFFER);
        this.add(HttpHeaders.SET_COOKIE_BUFFER, new ByteArrayBuffer(string3));
    }

    public void put(Buffer buffer) throws IOException {
        for (int i = 0; i < this._fields.size(); ++i) {
            Field field = (Field)this._fields.get(i);
            if (field == null || field._revision != this._revision) continue;
            field.put(buffer);
        }
        BufferUtil.putCRLF(buffer);
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = (Field)this._fields.get(i);
                if (field == null || field._revision != this._revision) continue;
                String string = field.getName();
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(": ");
                string = field.getValue();
                if (string != null) {
                    stringBuffer.append(string);
                }
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("\r\n");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void clear() {
        ++this._revision;
        if (this._revision > 1000000) {
            this._revision = 0;
            int n = this._fields.size();
            while (n-- > 0) {
                Field field = (Field)this._fields.get(n);
                if (field == null) continue;
                field.clear();
            }
        }
    }

    public void destroy() {
        if (this._fields != null) {
            int n = this._fields.size();
            while (n-- > 0) {
                Field field = (Field)this._fields.get(n);
                if (field == null) continue;
                this._bufferMap.remove(field.getNameBuffer());
                field.destroy();
            }
        }
        this._fields = null;
        this._dateBuffer = null;
        this._calendar = null;
        this._dateReceive = null;
    }

    public void add(HttpFields httpFields) {
        if (httpFields == null) {
            return;
        }
        Enumeration enumeration = httpFields.getFieldNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = httpFields.getValues(string);
            while (enumeration2.hasMoreElements()) {
                this.add(string, (String)enumeration2.nextElement());
            }
        }
    }

    public static String valueParameters(String string, Map map) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(59);
        if (n < 0) {
            return string;
        }
        if (map == null) {
            return string.substring(0, n).trim();
        }
        QuotedStringTokenizer quotedStringTokenizer = new QuotedStringTokenizer(string.substring(n), ";", false, true);
        while (((StringTokenizer)quotedStringTokenizer).hasMoreTokens()) {
            String string2 = ((StringTokenizer)quotedStringTokenizer).nextToken();
            QuotedStringTokenizer quotedStringTokenizer2 = new QuotedStringTokenizer(string2, "= ");
            if (!((StringTokenizer)quotedStringTokenizer2).hasMoreTokens()) continue;
            String string3 = ((StringTokenizer)quotedStringTokenizer2).nextToken();
            String string4 = null;
            if (((StringTokenizer)quotedStringTokenizer2).hasMoreTokens()) {
                string4 = ((StringTokenizer)quotedStringTokenizer2).nextToken();
            }
            map.put(string3, string4);
        }
        return string.substring(0, n).trim();
    }

    public static Float getQuality(String string) {
        Object object;
        if (string == null) {
            return __zero;
        }
        int n = string.indexOf(";");
        if (n++ < 0 || n == string.length()) {
            return __one;
        }
        if (string.charAt(n++) == 'q' && (object = __qualities.getEntry(string, ++n, string.length() - n)) != null) {
            return (Float)object.getValue();
        }
        object = new HashMap(3);
        HttpFields.valueParameters(string, object);
        String string2 = (String)((HashMap)object).get("q");
        Float f = (Float)__qualities.get(string2);
        if (f == null) {
            try {
                f = new Float(string2);
            }
            catch (Exception exception) {
                f = __one;
            }
        }
        return f;
    }

    public static List qualityList(Enumeration enumeration) {
        Object object;
        Object object2;
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object object3 = null;
        Object object4 = null;
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement().toString();
            object = HttpFields.getQuality((String)object2);
            if (!((double)((Float)object).floatValue() >= 0.001)) continue;
            object3 = LazyList.add(object3, object2);
            object4 = LazyList.add(object4, object);
        }
        object2 = LazyList.getList(object3, false);
        if (object2.size() < 2) {
            return object2;
        }
        object = LazyList.getList(object4, false);
        Float f = __zero;
        int n = object2.size();
        while (n-- > 0) {
            Float f2 = (Float)object.get(n);
            if (f.compareTo(f2) > 0) {
                Object e = object2.get(n);
                object2.set(n, object2.get(n + 1));
                object2.set(n + 1, e);
                object.set(n, object.get(n + 1));
                object.set(n + 1, f2);
                f = __zero;
                n = object2.size();
                continue;
            }
            f = f2;
        }
        object.clear();
        return object2;
    }

    static {
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        __dateReceive = new SimpleDateFormat[__dateReceiveFmt.length];
        for (int i = 0; i < __dateReceiveInit; ++i) {
            HttpFields.__dateReceive[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
            __dateReceive[i].setTimeZone(__GMT);
        }
        __01Jan1970 = HttpFields.formatDate(0L, false).trim();
        __01Jan1970_BUFFER = new ByteArrayBuffer(__01Jan1970);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    public static final class Field {
        private Buffer _name;
        private Buffer _value;
        private String _stringValue;
        private long _numValue;
        private Field _next;
        private Field _prev;
        private int _revision;

        private Field(Buffer buffer, Buffer buffer2, long l, int n) {
            this._name = buffer.asImmutableBuffer();
            this._value = buffer2.isImmutable() ? buffer2 : new View(buffer2);
            this._next = null;
            this._prev = null;
            this._revision = n;
            this._numValue = l;
            this._stringValue = null;
        }

        private void clear() {
            this._revision = -1;
        }

        private void destroy() {
            this._name = null;
            this._value = null;
            this._next = null;
            this._prev = null;
            this._stringValue = null;
        }

        private void reset(Buffer buffer, long l, int n) {
            this._revision = n;
            if (this._value == null) {
                this._value = buffer.isImmutable() ? buffer : new View(buffer);
                this._numValue = l;
                this._stringValue = null;
            } else if (buffer.isImmutable()) {
                this._value = buffer;
                this._numValue = l;
                this._stringValue = null;
            } else {
                if (this._value instanceof View) {
                    ((View)this._value).update(buffer);
                } else {
                    this._value = new View(buffer);
                }
                this._numValue = l;
                if (this._stringValue != null) {
                    if (this._stringValue.length() != buffer.length()) {
                        this._stringValue = null;
                    } else {
                        int n2 = buffer.length();
                        while (n2-- > 0) {
                            if (buffer.peek(buffer.getIndex() + n2) == this._stringValue.charAt(n2)) continue;
                            this._stringValue = null;
                            break;
                        }
                    }
                }
            }
        }

        public void put(Buffer buffer) throws IOException {
            byte by;
            int n;
            int n2;
            int n3;
            int n4 = n3 = this._name instanceof BufferCache.CachedBuffer ? ((BufferCache.CachedBuffer)this._name).getOrdinal() : -1;
            if (n3 >= 0) {
                buffer.put(this._name);
            } else {
                n2 = this._name.getIndex();
                n = this._name.putIndex();
                block6: while (n2 < n) {
                    by = this._name.peek(n2++);
                    switch (by) {
                        case 10: 
                        case 13: 
                        case 58: {
                            continue block6;
                        }
                    }
                    buffer.put(by);
                }
            }
            buffer.put((byte)58);
            buffer.put((byte)32);
            int n5 = n3 = this._value instanceof BufferCache.CachedBuffer ? ((BufferCache.CachedBuffer)this._value).getOrdinal() : -1;
            if (n3 >= 0 || this._numValue >= 0L) {
                buffer.put(this._value);
            } else {
                n2 = this._value.getIndex();
                n = this._value.putIndex();
                block7: while (n2 < n) {
                    by = this._value.peek(n2++);
                    switch (by) {
                        case 10: 
                        case 13: {
                            continue block7;
                        }
                    }
                    buffer.put(by);
                }
            }
            BufferUtil.putCRLF(buffer);
        }

        public String getName() {
            return BufferUtil.to8859_1_String(this._name);
        }

        Buffer getNameBuffer() {
            return this._name;
        }

        public int getNameOrdinal() {
            return HttpHeaders.CACHE.getOrdinal(this._name);
        }

        public String getValue() {
            if (this._stringValue == null) {
                this._stringValue = BufferUtil.to8859_1_String(this._value);
            }
            return this._stringValue;
        }

        public Buffer getValueBuffer() {
            return this._value;
        }

        public int getValueOrdinal() {
            return HttpHeaderValues.CACHE.getOrdinal(this._value);
        }

        public int getIntValue() {
            return (int)this.getLongValue();
        }

        public long getLongValue() {
            if (this._numValue == -1L) {
                this._numValue = BufferUtil.toLong(this._value);
            }
            return this._numValue;
        }

        public String toString() {
            return "[" + (this._prev == null ? "" : "<-") + this.getName() + "=" + this._revision + "=" + this._value + (this._next == null ? "" : "->") + "]";
        }
    }
}

