/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.EndPoint;
import org.mortbay.io.Portable;
import org.mortbay.jetty.AbstractGenerator;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpStatus;
import org.mortbay.jetty.HttpTokens;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.log.Log;

public class HttpGenerator
extends AbstractGenerator {
    private static byte[] LAST_CHUNK = new byte[]{48, 13, 10, 13, 10};
    private static byte[] CONTENT_LENGTH_0 = Portable.getBytes("Content-Length: 0\r\n");
    private static byte[] CONNECTION_KEEP_ALIVE = Portable.getBytes("Connection: keep-alive\r\n");
    private static byte[] CONNECTION_CLOSE = Portable.getBytes("Connection: close\r\n");
    private static byte[] CONNECTION_ = Portable.getBytes("Connection: ");
    private static byte[] CRLF = Portable.getBytes("\r\n");
    private static byte[] TRANSFER_ENCODING_CHUNKED = Portable.getBytes("Transfer-Encoding: chunked\r\n");
    private static byte[] SERVER = Portable.getBytes("Server: Jetty(6.0.x)\r\n");
    private static int CHUNK_SPACE = 12;
    private boolean _bypass = false;
    private boolean _needCRLF = false;
    private boolean _needEOC = false;
    private boolean _bufferChunked = false;

    public static void setServerVersion(String string) {
        SERVER = Portable.getBytes("Server: Jetty(" + string + ")\r\n");
    }

    public HttpGenerator(Buffers buffers, EndPoint endPoint, int n, int n2) {
        super(buffers, endPoint, n, n2);
    }

    @Override
    public void reset(boolean bl) {
        super.reset(bl);
        this._bypass = false;
        this._needCRLF = false;
        this._needEOC = false;
        this._bufferChunked = false;
        this._method = null;
        this._uri = null;
        this._noContent = false;
    }

    @Override
    public void addContent(Buffer buffer, boolean bl) throws IOException {
        if (this._noContent) {
            throw new IllegalStateException("NO CONTENT");
        }
        if (this._last || this._state == 4) {
            Log.debug("Ignoring extra content {}", buffer);
            buffer.clear();
            return;
        }
        this._last = bl;
        if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
            if (!this._endp.isOpen()) {
                throw new EofException();
            }
            this.flush();
            if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        this._content = buffer;
        this._contentWritten += (long)buffer.length();
        if (this._head) {
            buffer.clear();
            this._content = null;
        } else if (this._endp != null && this._buffer == null && buffer.length() > 0 && this._last) {
            this._bypass = true;
        } else {
            if (this._buffer == null) {
                this._buffer = this._buffers.getBuffer(this._contentBufferSize);
            }
            int n = this._buffer.put(this._content);
            this._content.skip(n);
            if (this._content.length() == 0) {
                this._content = null;
            }
        }
    }

    public void sendResponse(Buffer buffer) throws IOException {
        if (this._noContent || this._state != 0 || this._content != null && this._content.length() > 0 || this._bufferChunked || this._head) {
            throw new IllegalStateException();
        }
        this._last = true;
        this._content = buffer;
        this._bypass = true;
        this._state = 3;
        this._contentLength = this._contentWritten = (long)buffer.length();
    }

    @Override
    public boolean addContent(byte by) throws IOException {
        if (this._noContent) {
            throw new IllegalStateException("NO CONTENT");
        }
        if (this._last || this._state == 4) {
            Log.debug("Ignoring extra content {}", new Byte(by));
            return false;
        }
        if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
            this.flush();
            if (this._content != null && this._content.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        ++this._contentWritten;
        if (this._head) {
            return false;
        }
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer(this._contentBufferSize);
        }
        this._buffer.put(by);
        return this._buffer.space() <= (this._contentLength == -2L ? CHUNK_SPACE : 0);
    }

    @Override
    protected int prepareUncheckedAddContent() throws IOException {
        if (this._noContent) {
            return -1;
        }
        if (this._last || this._state == 4) {
            return -1;
        }
        Buffer buffer = this._content;
        if (buffer != null && buffer.length() > 0 || this._bufferChunked) {
            this.flush();
            if (buffer != null && buffer.length() > 0 || this._bufferChunked) {
                throw new IllegalStateException("FULL");
            }
        }
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer(this._contentBufferSize);
        }
        this._contentWritten -= (long)this._buffer.length();
        if (this._head) {
            return Integer.MAX_VALUE;
        }
        return this._buffer.space() - (this._contentLength == -2L ? CHUNK_SPACE : 0);
    }

    @Override
    public boolean isBufferFull() {
        boolean bl = super.isBufferFull() || this._bufferChunked || this._bypass || this._contentLength == -2L && this._buffer != null && this._buffer.space() < CHUNK_SPACE;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void completeHeader(HttpFields httpFields, boolean bl) throws IOException {
        Object object;
        Object object2;
        if (this._state != 0) {
            return;
        }
        if (this._method == null && this._status == 0) {
            throw new EofException();
        }
        if (this._last && !bl) {
            throw new IllegalStateException("last?");
        }
        this._last |= bl;
        if (this._header == null) {
            this._header = this._buffers.getBuffer(this._headerBufferSize);
        }
        boolean bl2 = false;
        if (this._method != null) {
            this._close = false;
            if (this._version == 9) {
                this._contentLength = 0L;
                this._header.put(this._method);
                this._header.put((byte)32);
                this._header.put(this._uri.getBytes("utf-8"));
                this._header.put(HttpTokens.CRLF);
                this._state = 3;
                this._noContent = true;
                return;
            }
            this._header.put(this._method);
            this._header.put((byte)32);
            this._header.put(this._uri.getBytes("utf-8"));
            this._header.put((byte)32);
            this._header.put(this._version == 10 ? HttpVersions.HTTP_1_0_BUFFER : HttpVersions.HTTP_1_1_BUFFER);
            this._header.put(HttpTokens.CRLF);
        } else {
            if (this._version == 9) {
                this._close = true;
                this._contentLength = -1L;
                this._state = 2;
                return;
            }
            if (this._version == 10) {
                this._close = true;
            }
            if ((object2 = HttpStatus.getResponseLine(this._status)) == null) {
                if (this._reason == null) {
                    this._reason = HttpGenerator.getReasonBuffer(this._status);
                }
                this._header.put(HttpVersions.HTTP_1_1_BUFFER);
                this._header.put((byte)32);
                this._header.put((byte)(48 + this._status / 100));
                this._header.put((byte)(48 + this._status % 100 / 10));
                this._header.put((byte)(48 + this._status % 10));
                this._header.put((byte)32);
                if (this._reason == null) {
                    this._header.put((byte)(48 + this._status / 100));
                    this._header.put((byte)(48 + this._status % 100 / 10));
                    this._header.put((byte)(48 + this._status % 10));
                } else {
                    this._header.put(this._reason);
                }
                this._header.put(HttpTokens.CRLF);
            } else if (this._reason == null) {
                this._header.put((Buffer)object2);
            } else {
                this._header.put(object2.array(), 0, HttpVersions.HTTP_1_1_BUFFER.length() + 5);
                this._header.put(this._reason);
                this._header.put(HttpTokens.CRLF);
            }
            if (this._status < 200 && this._status >= 100) {
                this._noContent = true;
                this._content = null;
                if (this._buffer != null) {
                    this._buffer.clear();
                }
                this._header.put(HttpTokens.CRLF);
                this._state = 2;
                return;
            }
            if (this._status == 204 || this._status == 304) {
                this._noContent = true;
                this._content = null;
                if (this._buffer != null) {
                    this._buffer.clear();
                }
            }
        }
        object2 = null;
        HttpFields.Field field = null;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuffer stringBuffer = null;
        if (httpFields != null) {
            object = httpFields.getFields();
            block22: while (object.hasNext()) {
                HttpFields.Field field2 = (HttpFields.Field)object.next();
                switch (field2.getNameOrdinal()) {
                    case 12: {
                        object2 = field2;
                        this._contentLength = field2.getLongValue();
                        if (this._contentLength < this._contentWritten || this._last && this._contentLength != this._contentWritten) {
                            object2 = null;
                        }
                        field2.put(this._header);
                        break;
                    }
                    case 16: {
                        if (BufferUtil.isPrefix(MimeTypes.MULTIPART_BYTERANGES_BUFFER, field2.getValueBuffer())) {
                            this._contentLength = -4L;
                        }
                        field2.put(this._header);
                        break;
                    }
                    case 5: {
                        if (this._version != 11) continue block22;
                        field = field2;
                        break;
                    }
                    case 1: {
                        if (this._method != null) {
                            field2.put(this._header);
                        }
                        int n = field2.getValueOrdinal();
                        switch (n) {
                            case -1: {
                                String[] stringArray = field2.getValue().split(",");
                                block23: for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
                                    BufferCache.CachedBuffer cachedBuffer = HttpHeaderValues.CACHE.get(stringArray[i].trim());
                                    if (cachedBuffer != null) {
                                        switch (cachedBuffer.getOrdinal()) {
                                            case 1: {
                                                bl4 = true;
                                                if (this._method == null) {
                                                    this._close = true;
                                                }
                                                bl3 = false;
                                                if (!this._close || this._method != null || this._contentLength != -3L) continue block23;
                                                this._contentLength = -1L;
                                                break;
                                            }
                                            case 5: {
                                                if (this._version != 10) continue block23;
                                                bl3 = true;
                                                if (this._method != null) continue block23;
                                                this._close = false;
                                                break;
                                            }
                                            default: {
                                                if (stringBuffer == null) {
                                                    stringBuffer = new StringBuffer();
                                                } else {
                                                    stringBuffer.append(',');
                                                }
                                                stringBuffer.append(stringArray[i]);
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    if (stringBuffer == null) {
                                        stringBuffer = new StringBuffer();
                                    } else {
                                        stringBuffer.append(',');
                                    }
                                    stringBuffer.append(stringArray[i]);
                                }
                                continue block22;
                            }
                            case 1: {
                                bl4 = true;
                                if (this._method == null) {
                                    this._close = true;
                                }
                                if (!this._close || this._method != null || this._contentLength != -3L) continue block22;
                                this._contentLength = -1L;
                                break;
                            }
                            case 5: {
                                if (this._version != 10) continue block22;
                                bl3 = true;
                                if (this._method != null) continue block22;
                                this._close = false;
                                break;
                            }
                            default: {
                                if (stringBuffer == null) {
                                    stringBuffer = new StringBuffer();
                                } else {
                                    stringBuffer.append(',');
                                }
                                stringBuffer.append(field2.getValue());
                                break;
                            }
                        }
                        continue block22;
                    }
                    case 48: {
                        if (!this.getSendServerVersion()) continue block22;
                        bl2 = true;
                        field2.put(this._header);
                        break;
                    }
                    default: {
                        field2.put(this._header);
                    }
                }
            }
        }
        switch ((int)this._contentLength) {
            case -3: {
                if (this._contentWritten == 0L && this._method == null && (this._status < 200 || this._status == 204 || this._status == 304)) {
                    this._contentLength = 0L;
                    break;
                }
                if (this._last) {
                    this._contentLength = this._contentWritten;
                    if (object2 != null) break;
                    this._header.put(HttpHeaders.CONTENT_LENGTH_BUFFER);
                    this._header.put((byte)58);
                    this._header.put((byte)32);
                    BufferUtil.putDecLong(this._header, this._contentLength);
                    this._header.put(HttpTokens.CRLF);
                    break;
                }
                long l = this._contentLength = this._close || this._version < 11 ? -1L : -2L;
                if (this._method == null || this._contentLength != -1L) break;
                this._contentLength = 0L;
                this._noContent = true;
                break;
            }
            case 0: {
                if (object2 != null || this._method != null || this._status < 200 || this._status == 204 || this._status == 304) break;
                this._header.put(CONTENT_LENGTH_0);
                break;
            }
            case -1: {
                this._close = this._method == null;
                break;
            }
            case -2: {
                break;
            }
        }
        if (this._contentLength == -2L) {
            if (field != null && 2 != field.getValueOrdinal()) {
                object = field.getValue();
                if (!((String)object).endsWith("chunked")) throw new IllegalArgumentException("BAD TE");
                field.put(this._header);
            } else {
                this._header.put(TRANSFER_ENCODING_CHUNKED);
            }
        }
        if (this._contentLength == -1L) {
            bl3 = false;
            this._close = true;
        }
        if (this._method == null) {
            if (this._close && (bl4 || this._version > 10)) {
                this._header.put(CONNECTION_CLOSE);
                if (stringBuffer != null) {
                    this._header.setPutIndex(this._header.putIndex() - 2);
                    this._header.put((byte)44);
                    this._header.put(stringBuffer.toString().getBytes());
                    this._header.put(CRLF);
                }
            } else if (bl3) {
                this._header.put(CONNECTION_KEEP_ALIVE);
                if (stringBuffer != null) {
                    this._header.setPutIndex(this._header.putIndex() - 2);
                    this._header.put((byte)44);
                    this._header.put(stringBuffer.toString().getBytes());
                    this._header.put(CRLF);
                }
            } else if (stringBuffer != null) {
                this._header.put(CONNECTION_);
                this._header.put(stringBuffer.toString().getBytes());
                this._header.put(CRLF);
            }
        }
        if (!bl2 && this._status > 100 && this.getSendServerVersion()) {
            this._header.put(SERVER);
        }
        this._header.put(HttpTokens.CRLF);
        this._state = 2;
    }

    @Override
    public void complete() throws IOException {
        if (this._state == 4) {
            return;
        }
        super.complete();
        if (this._state < 3) {
            this._state = 3;
            if (this._contentLength == -2L) {
                this._needEOC = true;
            }
        }
        this.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long flush() throws IOException {
        try {
            if (this._state == 0) {
                throw new IllegalStateException("State==HEADER");
            }
            this.prepareBuffers();
            if (this._endp == null) {
                if (this._needCRLF && this._buffer != null) {
                    this._buffer.put(HttpTokens.CRLF);
                }
                if (this._needEOC && this._buffer != null && !this._head) {
                    this._buffer.put(LAST_CHUNK);
                }
                this._needCRLF = false;
                this._needEOC = false;
                return 0L;
            }
            int n = 0;
            long l = -1L;
            while (true) {
                int n2 = -1;
                int n3 = (this._header != null && this._header.length() > 0 ? 4 : 0) | (this._buffer != null && this._buffer.length() > 0 ? 2 : 0) | (this._bypass && this._content != null && this._content.length() > 0 ? 1 : 0);
                switch (n3) {
                    case 7: {
                        throw new IllegalStateException();
                    }
                    case 6: {
                        n2 = this._endp.flush(this._header, this._buffer, null);
                        break;
                    }
                    case 5: {
                        n2 = this._endp.flush(this._header, this._content, null);
                        break;
                    }
                    case 4: {
                        n2 = this._endp.flush(this._header);
                        break;
                    }
                    case 3: {
                        throw new IllegalStateException();
                    }
                    case 2: {
                        n2 = this._endp.flush(this._buffer);
                        break;
                    }
                    case 1: {
                        n2 = this._endp.flush(this._content);
                        break;
                    }
                    case 0: {
                        if (this._header != null) {
                            this._header.clear();
                        }
                        this._bypass = false;
                        this._bufferChunked = false;
                        if (this._buffer != null) {
                            this._buffer.clear();
                            if (this._contentLength == -2L) {
                                this._buffer.setPutIndex(CHUNK_SPACE);
                                this._buffer.setGetIndex(CHUNK_SPACE);
                                if (this._content != null && this._content.length() < this._buffer.space() && this._state != 3) {
                                    this._buffer.put(this._content);
                                    this._content.clear();
                                    this._content = null;
                                    return n;
                                }
                            }
                        }
                        if (!(this._needCRLF || this._needEOC || this._content != null && this._content.length() != 0)) {
                            if (this._state == 3) {
                                this._state = 4;
                            }
                            if (this._state != 4) return n;
                            if (!this._close) return n;
                            if (this._status == 100) return n;
                            this._endp.close();
                            return n;
                        }
                        this.prepareBuffers();
                    }
                }
                if (n2 <= 0) return n;
                n += n2;
                l = n2;
            }
        }
        catch (IOException iOException) {
            IOException iOException2;
            Log.ignore(iOException);
            if (iOException instanceof EofException) {
                iOException2 = iOException;
                throw iOException2;
            }
            iOException2 = new EofException(iOException);
            throw iOException2;
        }
    }

    private void prepareBuffers() {
        if (!this._bufferChunked) {
            int n;
            if (this._content != null && this._content.length() > 0 && this._buffer != null && this._buffer.space() > 0) {
                n = this._buffer.put(this._content);
                this._content.skip(n);
                if (this._content.length() == 0) {
                    this._content = null;
                }
            }
            if (this._contentLength == -2L) {
                int n2 = n = this._buffer == null ? 0 : this._buffer.length();
                if (n > 0) {
                    this._bufferChunked = true;
                    if (this._buffer.getIndex() == CHUNK_SPACE) {
                        this._buffer.poke(this._buffer.getIndex() - 2, HttpTokens.CRLF, 0, 2);
                        this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                        BufferUtil.prependHexInt(this._buffer, n);
                        if (this._needCRLF) {
                            this._buffer.poke(this._buffer.getIndex() - 2, HttpTokens.CRLF, 0, 2);
                            this._buffer.setGetIndex(this._buffer.getIndex() - 2);
                            this._needCRLF = false;
                        }
                    } else {
                        if (this._needCRLF) {
                            if (this._header.length() > 0) {
                                throw new IllegalStateException("EOC");
                            }
                            this._header.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        }
                        BufferUtil.putHexInt(this._header, n);
                        this._header.put(HttpTokens.CRLF);
                    }
                    if (this._buffer.space() >= 2) {
                        this._buffer.put(HttpTokens.CRLF);
                    } else {
                        this._needCRLF = true;
                    }
                }
                if (this._needEOC && (this._content == null || this._content.length() == 0)) {
                    if (this._needCRLF) {
                        if (this._buffer == null && this._header.space() >= 2) {
                            this._header.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        } else if (this._buffer != null && this._buffer.space() >= 2) {
                            this._buffer.put(HttpTokens.CRLF);
                            this._needCRLF = false;
                        }
                    }
                    if (!this._needCRLF && this._needEOC) {
                        if (this._buffer == null && this._header.space() >= LAST_CHUNK.length) {
                            if (!this._head) {
                                this._header.put(LAST_CHUNK);
                                this._bufferChunked = true;
                            }
                            this._needEOC = false;
                        } else if (this._buffer != null && this._buffer.space() >= LAST_CHUNK.length) {
                            if (!this._head) {
                                this._buffer.put(LAST_CHUNK);
                                this._bufferChunked = true;
                            }
                            this._needEOC = false;
                        }
                    }
                }
            }
        }
        if (this._content != null && this._content.length() == 0) {
            this._content = null;
        }
    }

    public int getBytesBuffered() {
        return (this._header == null ? 0 : this._header.length()) + (this._buffer == null ? 0 : this._buffer.length()) + (this._content == null ? 0 : this._content.length());
    }

    public boolean isEmpty() {
        return !(this._header != null && this._header.length() != 0 || this._buffer != null && this._buffer.length() != 0 || this._content != null && this._content.length() != 0);
    }

    public String toString() {
        return "HttpGenerator s=" + this._state + " h=" + (this._header == null ? "null" : "" + this._header.length()) + " b=" + (this._buffer == null ? "null" : "" + this._buffer.length()) + " c=" + (this._content == null ? "null" : "" + this._content.length());
    }
}

