/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.io.BufferUtil;
import org.mortbay.io.Buffers;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.View;
import org.mortbay.jetty.EofException;
import org.mortbay.jetty.HttpException;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.HttpMethods;
import org.mortbay.jetty.HttpVersions;
import org.mortbay.jetty.Parser;
import org.mortbay.log.Log;

public class HttpParser
implements Parser {
    public static final int STATE_START = -13;
    public static final int STATE_FIELD0 = -12;
    public static final int STATE_SPACE1 = -11;
    public static final int STATE_FIELD1 = -10;
    public static final int STATE_SPACE2 = -9;
    public static final int STATE_END0 = -8;
    public static final int STATE_END1 = -7;
    public static final int STATE_FIELD2 = -6;
    public static final int STATE_HEADER = -5;
    public static final int STATE_HEADER_NAME = -4;
    public static final int STATE_HEADER_IN_NAME = -3;
    public static final int STATE_HEADER_VALUE = -2;
    public static final int STATE_HEADER_IN_VALUE = -1;
    public static final int STATE_END = 0;
    public static final int STATE_EOF_CONTENT = 1;
    public static final int STATE_CONTENT = 2;
    public static final int STATE_CHUNKED_CONTENT = 3;
    public static final int STATE_CHUNK_SIZE = 4;
    public static final int STATE_CHUNK_PARAMS = 5;
    public static final int STATE_CHUNK = 6;
    private Buffers _buffers;
    private EndPoint _endp;
    private Buffer _header;
    private Buffer _body;
    private Buffer _buffer;
    private View _contentView = new View();
    private int _headerBufferSize;
    private int _contentBufferSize;
    private EventHandler _handler;
    private BufferCache.CachedBuffer _cached;
    private View.CaseInsensitive _tok0;
    private View.CaseInsensitive _tok1;
    private String _multiLineValue;
    private int _responseStatus;
    private boolean _forceContentBuffer;
    private Input _input;
    protected int _state = -13;
    protected byte _eol;
    protected int _length;
    protected long _contentLength;
    protected long _contentPosition;
    protected int _chunkLength;
    protected int _chunkPosition;

    public HttpParser(Buffer buffer, EventHandler eventHandler) {
        this._header = buffer;
        this._buffer = buffer;
        this._handler = eventHandler;
        if (buffer != null) {
            this._tok0 = new View.CaseInsensitive(buffer);
            this._tok1 = new View.CaseInsensitive(buffer);
            this._tok0.setPutIndex(this._tok0.getIndex());
            this._tok1.setPutIndex(this._tok1.getIndex());
        }
    }

    public HttpParser(Buffers buffers, EndPoint endPoint, EventHandler eventHandler, int n, int n2) {
        this._buffers = buffers;
        this._endp = endPoint;
        this._handler = eventHandler;
        this._headerBufferSize = n;
        this._contentBufferSize = n2;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public int getState() {
        return this._state;
    }

    public boolean inContentState() {
        return this._state > 0;
    }

    public boolean inHeaderState() {
        return this._state < 0;
    }

    public boolean isChunking() {
        return this._contentLength == -2L;
    }

    @Override
    public boolean isIdle() {
        return this.isState(-13);
    }

    @Override
    public boolean isComplete() {
        return this.isState(0);
    }

    @Override
    public boolean isMoreInBuffer() throws IOException {
        return this._header != null && this._header.hasContent() || this._body != null && this._body.hasContent();
    }

    public boolean isState(int n) {
        return this._state == n;
    }

    public void parse() throws IOException {
        if (this._state == 0) {
            this.reset(false);
        }
        if (this._state != -13) {
            throw new IllegalStateException("!START");
        }
        while (this._state != 0) {
            this.parseNext();
        }
    }

    @Override
    public long parseAvailable() throws IOException {
        long l;
        long l2 = this.parseNext();
        long l3 = l = l2 > 0L ? l2 : 0L;
        while (!this.isComplete() && this._buffer != null && this._buffer.length() > 0) {
            l2 = this.parseNext();
            if (l2 <= 0L) continue;
            l += l2;
        }
        return l;
    }

    public long parseNext() throws IOException {
        Buffer buffer;
        Object object;
        int n;
        long l = -1L;
        if (this._state == 0) {
            return -1L;
        }
        if (this._buffer == null) {
            if (this._header == null) {
                this._header = this._buffers.getBuffer(this._headerBufferSize);
            }
            this._buffer = this._header;
            this._tok0 = new View.CaseInsensitive(this._header);
            this._tok1 = new View.CaseInsensitive(this._header);
            this._tok0.setPutIndex(this._tok0.getIndex());
            this._tok1.setPutIndex(this._tok1.getIndex());
        }
        if (this._state == 2 && this._contentPosition == this._contentLength) {
            this._state = 0;
            this._handler.messageComplete(this._contentPosition);
            return l;
        }
        int n2 = this._buffer.length();
        if (n2 == 0) {
            n = -1;
            if (this._body != null && this._buffer != this._body) {
                this._buffer = this._body;
                n = this._buffer.length();
            }
            if (this._buffer.markIndex() == 0 && this._buffer.putIndex() == this._buffer.capacity()) {
                throw new HttpException(413, "FULL");
            }
            object = null;
            if (this._endp != null && n <= 0) {
                if (this._buffer == this._body) {
                    this._buffer.compact();
                }
                if (this._buffer.space() == 0) {
                    throw new HttpException(413, "FULL " + (this._buffer == this._body ? "body" : "head"));
                }
                try {
                    if (l < 0L) {
                        l = 0L;
                    }
                    if ((n = this._endp.fill(this._buffer)) > 0) {
                        l += (long)n;
                    }
                }
                catch (IOException iOException) {
                    Log.debug(iOException);
                    object = iOException;
                    n = -1;
                }
            }
            if (n < 0) {
                if (this._state == 1) {
                    if (this._buffer.length() > 0) {
                        Buffer buffer2 = this._buffer.get(this._buffer.length());
                        this._contentPosition += (long)buffer2.length();
                        this._contentView.update(buffer2);
                        this._handler.content(buffer2);
                    }
                    this._state = 0;
                    this._handler.messageComplete(this._contentPosition);
                    return l;
                }
                this.reset(true);
                throw new EofException((Throwable)object);
            }
            n2 = this._buffer.length();
        }
        object = this._buffer.array();
        while (this._state < 0 && n2-- > 0) {
            n = this._buffer.get();
            if (this._eol == 13 && n == 10) {
                this._eol = (byte)10;
                continue;
            }
            this._eol = 0;
            block2 : switch (this._state) {
                case -13: {
                    this._contentLength = -3L;
                    this._cached = null;
                    if (n <= 32 && n >= 0) break;
                    this._buffer.mark();
                    this._state = -12;
                    break;
                }
                case -12: {
                    if (n == 32) {
                        this._tok0.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                        this._state = -11;
                        break;
                    }
                    if (n >= 32 || n < 0) break;
                    throw new HttpException(400);
                }
                case -11: {
                    if (n > 32 || n < 0) {
                        this._buffer.mark();
                        this._state = -10;
                        break;
                    }
                    if (n >= 32) break;
                    throw new HttpException(400);
                }
                case -10: {
                    if (n == 32) {
                        this._tok1.update(this._buffer.markIndex(), this._buffer.getIndex() - 1);
                        this._state = -9;
                        break;
                    }
                    if (n >= 32 || n < 0) break;
                    this._handler.startRequest(HttpMethods.CACHE.lookup(this._tok0), this._buffer.sliceFromMark(), null);
                    this._state = 0;
                    this._handler.headerComplete();
                    this._handler.messageComplete(this._contentPosition);
                    return l;
                }
                case -9: {
                    if (n > 32 || n < 0) {
                        this._buffer.mark();
                        this._state = -6;
                        break;
                    }
                    if (n >= 32) break;
                    this._handler.startRequest(HttpMethods.CACHE.lookup(this._tok0), this._tok1, null);
                    this._state = 0;
                    this._handler.headerComplete();
                    this._handler.messageComplete(this._contentPosition);
                    return l;
                }
                case -6: {
                    if (n != 13 && n != 10) break;
                    buffer = HttpMethods.CACHE.lookup(this._tok0);
                    if (buffer == this._tok0 && this._tok1.length() == 3 && Character.isDigit((char)this._tok1.peek())) {
                        this._responseStatus = BufferUtil.toInt(this._tok1);
                        this._handler.startResponse(HttpVersions.CACHE.lookup(this._tok0), this._responseStatus, this._buffer.sliceFromMark());
                    } else {
                        this._handler.startRequest(buffer, this._tok1, HttpVersions.CACHE.lookup(this._buffer.sliceFromMark()));
                    }
                    this._eol = (byte)n;
                    this._state = -5;
                    this._tok0.setPutIndex(this._tok0.getIndex());
                    this._tok1.setPutIndex(this._tok1.getIndex());
                    this._multiLineValue = null;
                    break;
                }
                case -5: {
                    switch (n) {
                        case 9: 
                        case 32: 
                        case 58: {
                            this._length = -1;
                            this._state = -2;
                            break block2;
                        }
                    }
                    if (this._cached != null || this._tok0.length() > 0 || this._tok1.length() > 0 || this._multiLineValue != null) {
                        buffer = this._cached != null ? this._cached : HttpHeaders.CACHE.lookup(this._tok0);
                        this._cached = null;
                        Buffer buffer3 = this._multiLineValue == null ? this._tok1 : new ByteArrayBuffer(this._multiLineValue);
                        int n3 = HttpHeaders.CACHE.getOrdinal(buffer);
                        if (n3 >= 0) {
                            int n4 = -1;
                            switch (n3) {
                                case 12: {
                                    if (this._contentLength == -2L) break;
                                    try {
                                        this._contentLength = BufferUtil.toLong(buffer3);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        Log.ignore(numberFormatException);
                                        throw new HttpException(400);
                                    }
                                    if (this._contentLength > 0L) break;
                                    this._contentLength = 0L;
                                    break;
                                }
                                case 5: {
                                    buffer3 = HttpHeaderValues.CACHE.lookup(buffer3);
                                    n4 = HttpHeaderValues.CACHE.getOrdinal(buffer3);
                                    if (2 == n4) {
                                        this._contentLength = -2L;
                                        break;
                                    }
                                    String string = buffer3.toString();
                                    if (string.endsWith("chunked")) {
                                        this._contentLength = -2L;
                                        break;
                                    }
                                    if (string.indexOf("chunked") < 0) break;
                                    throw new HttpException(400, null);
                                }
                            }
                        }
                        this._handler.parsedHeader(buffer, buffer3);
                        this._tok0.setPutIndex(this._tok0.getIndex());
                        this._tok1.setPutIndex(this._tok1.getIndex());
                        this._multiLineValue = null;
                    }
                    if (n == 13 || n == 10) {
                        if (this._contentLength == -3L) {
                            this._contentLength = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? 0L : -1L;
                        }
                        this._contentPosition = 0L;
                        this._eol = (byte)n;
                        switch (this._contentLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._contentLength) {
                            case -1: {
                                this._state = 1;
                                if (this._body == null && this._buffers != null) {
                                    this._body = this._buffers.getBuffer(this._contentBufferSize);
                                }
                                this._handler.headerComplete();
                                break;
                            }
                            case -2: {
                                this._state = 3;
                                if (this._body == null && this._buffers != null) {
                                    this._body = this._buffers.getBuffer(this._contentBufferSize);
                                }
                                this._handler.headerComplete();
                                break;
                            }
                            case 0: {
                                this._state = 0;
                                this._handler.headerComplete();
                                this._handler.messageComplete(this._contentPosition);
                                break;
                            }
                            default: {
                                this._state = 2;
                                if (this._forceContentBuffer || this._buffers != null && this._body == null && this._buffer == this._header && this._contentLength >= (long)(this._header.capacity() - this._header.getIndex())) {
                                    this._body = this._buffers.getBuffer(this._contentBufferSize);
                                }
                                this._handler.headerComplete();
                            }
                        }
                        return l;
                    }
                    this._length = 1;
                    this._buffer.mark();
                    this._state = -4;
                    if (object == null) break;
                    this._cached = HttpHeaders.CACHE.getBest((byte[])object, this._buffer.markIndex(), n2 + 1);
                    if (this._cached == null) break;
                    this._length = this._cached.length();
                    this._buffer.setGetIndex(this._buffer.markIndex() + this._length);
                    n2 = this._buffer.length();
                    break;
                }
                case -4: {
                    switch (n) {
                        case 10: 
                        case 13: {
                            if (this._length > 0) {
                                this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                            }
                            this._eol = (byte)n;
                            this._state = -5;
                            break block2;
                        }
                        case 58: {
                            if (this._length > 0 && this._cached == null) {
                                this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                            }
                            this._length = -1;
                            this._state = -2;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            break block2;
                        }
                    }
                    this._cached = null;
                    if (this._length == -1) {
                        this._buffer.mark();
                    }
                    this._length = this._buffer.getIndex() - this._buffer.markIndex();
                    this._state = -3;
                    break;
                }
                case -3: {
                    switch (n) {
                        case 10: 
                        case 13: {
                            if (this._length > 0) {
                                this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                            }
                            this._eol = (byte)n;
                            this._state = -5;
                            break block2;
                        }
                        case 58: {
                            if (this._length > 0 && this._cached == null) {
                                this._tok0.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                            }
                            this._length = -1;
                            this._state = -2;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            this._state = -4;
                            break block2;
                        }
                    }
                    this._cached = null;
                    ++this._length;
                    break;
                }
                case -2: {
                    switch (n) {
                        case 10: 
                        case 13: {
                            if (this._length > 0) {
                                if (this._tok1.length() == 0) {
                                    this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                } else {
                                    if (this._multiLineValue == null) {
                                        this._multiLineValue = this._tok1.toString();
                                    }
                                    this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                    this._multiLineValue = this._multiLineValue + " " + this._tok1.toString();
                                }
                            }
                            this._eol = (byte)n;
                            this._state = -5;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            break block2;
                        }
                    }
                    if (this._length == -1) {
                        this._buffer.mark();
                    }
                    this._length = this._buffer.getIndex() - this._buffer.markIndex();
                    this._state = -1;
                    break;
                }
                case -1: {
                    switch (n) {
                        case 10: 
                        case 13: {
                            if (this._length > 0) {
                                if (this._tok1.length() == 0) {
                                    this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                } else {
                                    if (this._multiLineValue == null) {
                                        this._multiLineValue = this._tok1.toString();
                                    }
                                    this._tok1.update(this._buffer.markIndex(), this._buffer.markIndex() + this._length);
                                    this._multiLineValue = this._multiLineValue + " " + this._tok1.toString();
                                }
                            }
                            this._eol = (byte)n;
                            this._state = -5;
                            break block2;
                        }
                        case 9: 
                        case 32: {
                            this._state = -2;
                            break block2;
                        }
                    }
                    ++this._length;
                }
            }
        }
        n2 = this._buffer.length();
        if (this._input != null) {
            this._input._contentView = this._contentView;
        }
        while (this._state > 0 && n2 > 0) {
            if (this._eol == 13 && this._buffer.peek() == 10) {
                this._eol = this._buffer.get();
                n2 = this._buffer.length();
                continue;
            }
            this._eol = 0;
            switch (this._state) {
                case 1: {
                    buffer = this._buffer.get(this._buffer.length());
                    this._contentPosition += (long)buffer.length();
                    this._contentView.update(buffer);
                    this._handler.content(buffer);
                    return l;
                }
                case 2: {
                    long l2 = this._contentLength - this._contentPosition;
                    if (l2 == 0L) {
                        this._state = 0;
                        this._handler.messageComplete(this._contentPosition);
                        return l;
                    }
                    if ((long)n2 > l2) {
                        n2 = (int)l2;
                    }
                    buffer = this._buffer.get(n2);
                    this._contentPosition += (long)buffer.length();
                    this._contentView.update(buffer);
                    this._handler.content(buffer);
                    if (this._contentPosition == this._contentLength) {
                        this._state = 0;
                        this._handler.messageComplete(this._contentPosition);
                    }
                    return l;
                }
                case 3: {
                    n = this._buffer.peek();
                    if (n == 13 || n == 10) {
                        this._eol = this._buffer.get();
                        break;
                    }
                    if (n <= 32) {
                        this._buffer.get();
                        break;
                    }
                    this._chunkLength = 0;
                    this._chunkPosition = 0;
                    this._state = 4;
                    break;
                }
                case 4: {
                    n = this._buffer.get();
                    if (n == 13 || n == 10) {
                        this._eol = (byte)n;
                        if (this._chunkLength == 0) {
                            this._state = 0;
                            this._handler.messageComplete(this._contentPosition);
                            return l;
                        }
                        this._state = 6;
                        break;
                    }
                    if (n <= 32 || n == 59) {
                        this._state = 5;
                        break;
                    }
                    if (n >= 48 && n <= 57) {
                        this._chunkLength = this._chunkLength * 16 + (n - 48);
                        break;
                    }
                    if (n >= 97 && n <= 102) {
                        this._chunkLength = this._chunkLength * 16 + (10 + n - 97);
                        break;
                    }
                    if (n >= 65 && n <= 70) {
                        this._chunkLength = this._chunkLength * 16 + (10 + n - 65);
                        break;
                    }
                    throw new IOException("bad chunk char: " + n);
                }
                case 5: {
                    n = this._buffer.get();
                    if (n != 13 && n != 10) break;
                    this._eol = (byte)n;
                    if (this._chunkLength == 0) {
                        this._state = 0;
                        this._handler.messageComplete(this._contentPosition);
                        return l;
                    }
                    this._state = 6;
                    break;
                }
                case 6: {
                    int n5 = this._chunkLength - this._chunkPosition;
                    if (n5 == 0) {
                        this._state = 3;
                        break;
                    }
                    if (n2 > n5) {
                        n2 = n5;
                    }
                    buffer = this._buffer.get(n2);
                    this._contentPosition += (long)buffer.length();
                    this._chunkPosition += buffer.length();
                    this._contentView.update(buffer);
                    this._handler.content(buffer);
                    return l;
                }
            }
            n2 = this._buffer.length();
        }
        return l;
    }

    public long fill() throws IOException {
        int n;
        if (this._buffer == null) {
            this._buffer = this._header = this.getHeaderBuffer();
            this._tok0 = new View.CaseInsensitive(this._buffer);
            this._tok1 = new View.CaseInsensitive(this._buffer);
        }
        if (this._body != null && this._buffer != this._body) {
            this._buffer = this._body;
        }
        if (this._buffer == this._body) {
            this._buffer.compact();
        }
        if ((n = this._buffer.space()) == 0) {
            throw new HttpException(413, "FULL " + (this._buffer == this._body ? "body" : "head"));
        }
        int n2 = -1;
        if (this._endp != null) {
            try {
                n2 = this._endp.fill(this._buffer);
            }
            catch (IOException iOException) {
                Log.debug(iOException);
                this.reset(true);
                throw iOException instanceof EofException ? iOException : new EofException(iOException);
            }
        }
        return n2;
    }

    public void skipCRLF() {
        byte by;
        while (this._header != null && this._header.length() > 0 && ((by = this._header.peek()) == 13 || by == 10)) {
            this._eol = by;
            this._header.skip(1);
        }
        while (this._body != null && this._body.length() > 0 && ((by = this._body.peek()) == 13 || by == 10)) {
            this._eol = by;
            this._body.skip(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(boolean bl) {
        HttpParser httpParser = this;
        synchronized (httpParser) {
            if (this._input != null && this._contentView.length() > 0) {
                this._input._contentView = this._contentView.duplicate(2);
            }
            this._state = -13;
            this._contentLength = -3L;
            this._contentPosition = 0L;
            this._length = 0;
            this._responseStatus = 0;
            if (this._buffer != null && this._buffer.length() > 0 && this._eol == 13 && this._buffer.peek() == 10) {
                this._buffer.skip(1);
                this._eol = (byte)10;
            }
            if (this._body != null) {
                if (this._body.hasContent()) {
                    this._header.setMarkIndex(-1);
                    this._header.compact();
                    int n = this._header.space();
                    if (n > this._body.length()) {
                        n = this._body.length();
                    }
                    this._body.peek(this._body.getIndex(), n);
                    this._body.skip(this._header.put(this._body.peek(this._body.getIndex(), n)));
                }
                if (this._body.length() == 0) {
                    if (this._buffers != null && bl) {
                        this._buffers.returnBuffer(this._body);
                    }
                    this._body = null;
                } else {
                    this._body.setMarkIndex(-1);
                    this._body.compact();
                }
            }
            if (this._header != null) {
                this._header.setMarkIndex(-1);
                if (!this._header.hasContent() && this._buffers != null && bl) {
                    this._buffers.returnBuffer(this._header);
                    this._header = null;
                    this._buffer = null;
                } else {
                    this._header.compact();
                    this._tok0.update(this._header);
                    this._tok0.update(0, 0);
                    this._tok1.update(this._header);
                    this._tok1.update(0, 0);
                }
            }
            this._buffer = this._header;
        }
    }

    public void setState(int n) {
        this._state = n;
        this._contentLength = -3L;
    }

    public String toString(Buffer buffer) {
        return "state=" + this._state + " length=" + this._length + " buf=" + buffer.hashCode();
    }

    public String toString() {
        return "state=" + this._state + " length=" + this._length + " len=" + this._contentLength;
    }

    public Buffer getHeaderBuffer() {
        if (this._header == null) {
            this._header = this._buffers.getBuffer(this._headerBufferSize);
        }
        return this._header;
    }

    public Buffer getBodyBuffer() {
        return this._body;
    }

    public void setForceContentBuffer(boolean bl) {
        this._forceContentBuffer = bl;
    }

    public static class Input
    extends ServletInputStream {
        protected HttpParser _parser;
        protected EndPoint _endp;
        protected long _maxIdleTime;
        protected Buffer _contentView;

        public Input(HttpParser httpParser, long l) {
            this._parser = httpParser;
            this._endp = httpParser._endp;
            this._maxIdleTime = l;
            this._contentView = this._parser._contentView;
            this._parser._input = this;
        }

        public int read() throws IOException {
            int n = -1;
            if (this.blockForContent()) {
                n = 0xFF & this._contentView.get();
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = -1;
            if (this.blockForContent()) {
                n3 = this._contentView.get(byArray, n, n2);
            }
            return n3;
        }

        private boolean blockForContent() throws IOException {
            if (this._contentView.length() > 0) {
                return true;
            }
            if (this._parser.getState() <= 0) {
                return false;
            }
            if (this._endp == null) {
                this._parser.parseNext();
            } else if (this._endp.isBlocking()) {
                try {
                    this._parser.parseNext();
                    while (this._contentView.length() == 0 && !this._parser.isState(0) && this._endp.isOpen()) {
                        this._parser.parseNext();
                    }
                }
                catch (IOException iOException) {
                    this._endp.close();
                    throw iOException;
                }
            } else {
                this._parser.parseNext();
                while (this._contentView.length() == 0 && !this._parser.isState(0) && this._endp.isOpen()) {
                    if (this._endp.isBufferingInput() && this._parser.parseNext() > 0L) continue;
                    if (!this._endp.blockReadable(this._maxIdleTime)) {
                        this._endp.close();
                        throw new EofException("timeout");
                    }
                    this._parser.parseNext();
                }
            }
            return this._contentView.length() > 0;
        }

        public int available() throws IOException {
            if (this._contentView != null && this._contentView.length() > 0) {
                return this._contentView.length();
            }
            if (!this._endp.isBlocking()) {
                this._parser.parseNext();
            }
            return this._contentView == null ? 0 : this._contentView.length();
        }
    }

    public static abstract class EventHandler {
        public abstract void content(Buffer var1) throws IOException;

        public void headerComplete() throws IOException {
        }

        public void messageComplete(long l) throws IOException {
        }

        public void parsedHeader(Buffer buffer, Buffer buffer2) throws IOException {
        }

        public abstract void startRequest(Buffer var1, Buffer var2, Buffer var3) throws IOException;

        public abstract void startResponse(Buffer var1, int var2, Buffer var3) throws IOException;
    }
}

