/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.io.UnsupportedEncodingException;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;
import org.mortbay.util.UrlEncoded;
import org.mortbay.util.Utf8StringBuffer;

public class HttpURI {
    private static byte[] __empty = new byte[0];
    private static final int START = 0;
    private static final int AUTH_OR_PATH = 1;
    private static final int SCHEME_OR_PATH = 2;
    private static final int AUTH = 4;
    private static final int IPV6 = 5;
    private static final int PORT = 6;
    private static final int PATH = 7;
    private static final int PARAM = 8;
    private static final int QUERY = 9;
    private static final int ASTERISK = 10;
    boolean _partial = false;
    byte[] _raw = __empty;
    String _rawString;
    int _scheme;
    int _authority;
    int _host;
    int _port;
    int _path;
    int _param;
    int _query;
    int _fragment;
    int _end;
    Utf8StringBuffer _utf8b = new Utf8StringBuffer(64);

    public HttpURI() {
    }

    public HttpURI(boolean bl) {
        this._partial = bl;
    }

    public HttpURI(String string) {
        this._rawString = string;
        byte[] byArray = string.getBytes();
        this.parse(byArray, 0, byArray.length);
    }

    public HttpURI(byte[] byArray, int n, int n2) {
        this.parse2(byArray, n, n2);
    }

    public void parse(String string) {
        byte[] byArray = string.getBytes();
        this.parse2(byArray, 0, byArray.length);
        this._rawString = string;
    }

    public void parse(byte[] byArray, int n, int n2) {
        this._rawString = null;
        this.parse2(byArray, n, n2);
    }

    private void parse2(byte[] byArray, int n, int n2) {
        this._raw = byArray;
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        int n6 = n;
        this._end = n + n2;
        this._scheme = n;
        this._authority = n;
        this._host = n;
        this._port = n;
        this._path = n;
        this._param = this._end;
        this._query = this._end;
        this._fragment = this._end;
        while (n3 < n4) {
            int n7 = 0xFF & this._raw[n3];
            int n8 = n3++;
            block0 : switch (n5) {
                case 0: {
                    n6 = n8;
                    switch (n7) {
                        case 47: {
                            n5 = 1;
                            break block0;
                        }
                        case 59: {
                            this._param = n8;
                            n5 = 8;
                            break block0;
                        }
                        case 63: {
                            this._param = n8;
                            this._query = n8;
                            n5 = 9;
                            break block0;
                        }
                        case 35: {
                            this._param = n8;
                            this._query = n8;
                            this._fragment = n8;
                            break block0;
                        }
                        case 42: {
                            this._path = n8;
                            n5 = 10;
                            break block0;
                        }
                        default: {
                            if (Character.isLetterOrDigit((char)n7)) {
                                n5 = 2;
                                break block0;
                            }
                            throw new IllegalArgumentException(StringUtil.toString(this._raw, n, n2, URIUtil.__CHARSET));
                        }
                    }
                }
                case 1: {
                    if ((this._partial || this._scheme != this._authority) && n7 == 47) {
                        this._host = n3;
                        this._port = this._end;
                        this._path = this._end;
                        n5 = 4;
                        break;
                    }
                    if (n7 == 59 || n7 == 63 || n7 == 35) {
                        --n3;
                        n5 = 7;
                        break;
                    }
                    this._host = n6;
                    this._port = n6;
                    n5 = 7;
                    break;
                }
                case 2: {
                    if (n2 > 6 && n7 == 116) {
                        if (this._raw[n + 3] == 58) {
                            n8 = n + 3;
                            n3 = n + 4;
                            n7 = 58;
                        } else if (this._raw[n + 4] == 58) {
                            n8 = n + 4;
                            n3 = n + 5;
                            n7 = 58;
                        } else if (this._raw[n + 5] == 58) {
                            n8 = n + 5;
                            n3 = n + 6;
                            n7 = 58;
                        }
                    }
                    switch (n7) {
                        case 58: {
                            this._authority = n6 = n3++;
                            this._path = n6;
                            n7 = (char)(0xFF & this._raw[n3]);
                            if (n7 == 47) {
                                n5 = 1;
                                break;
                            }
                            this._host = n6;
                            this._port = n6;
                            n5 = 7;
                            break;
                        }
                        case 47: {
                            n5 = 7;
                            break;
                        }
                        case 59: {
                            this._param = n8;
                            n5 = 8;
                            break;
                        }
                        case 63: {
                            this._param = n8;
                            this._query = n8;
                            n5 = 9;
                            break;
                        }
                        case 35: {
                            this._param = n8;
                            this._query = n8;
                            this._fragment = n8;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (n7) {
                        case 47: {
                            this._port = this._path = (n6 = n8);
                            n5 = 7;
                            break;
                        }
                        case 64: {
                            this._host = n3;
                            break;
                        }
                        case 58: {
                            this._port = n8;
                            n5 = 6;
                            break;
                        }
                        case 91: {
                            n5 = 5;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (n7) {
                        case 47: {
                            throw new IllegalArgumentException("No closing ']' for " + StringUtil.toString(this._raw, n, n2, URIUtil.__CHARSET));
                        }
                        case 93: {
                            n5 = 4;
                        }
                    }
                    break;
                }
                case 6: {
                    if (n7 != 47) break;
                    this._path = n6 = n8;
                    if (this._port <= this._authority) {
                        this._port = this._path;
                    }
                    n5 = 7;
                    break;
                }
                case 7: {
                    switch (n7) {
                        case 59: {
                            this._param = n8;
                            n5 = 8;
                            break;
                        }
                        case 63: {
                            this._param = n8;
                            this._query = n8;
                            n5 = 9;
                            break;
                        }
                        case 35: {
                            this._param = n8;
                            this._query = n8;
                            this._fragment = n8;
                            break;
                        }
                    }
                    break;
                }
                case 8: {
                    switch (n7) {
                        case 63: {
                            this._query = n8;
                            n5 = 9;
                            break;
                        }
                        case 35: {
                            this._query = n8;
                            this._fragment = n8;
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    if (n7 != 35) break;
                    this._fragment = n8;
                    break;
                }
                case 10: {
                    throw new IllegalArgumentException("only '*'");
                }
            }
        }
    }

    private String toUtf8String(int n, int n2) {
        this._utf8b.reset();
        this._utf8b.append(this._raw, n, n2);
        return this._utf8b.toString();
    }

    public String getScheme() {
        if (this._scheme == this._authority) {
            return null;
        }
        int n = this._authority - this._scheme;
        if (n == 5 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112) {
            return "http";
        }
        if (n == 6 && this._raw[this._scheme] == 104 && this._raw[this._scheme + 1] == 116 && this._raw[this._scheme + 2] == 116 && this._raw[this._scheme + 3] == 112 && this._raw[this._scheme + 4] == 115) {
            return "https";
        }
        return this.toUtf8String(this._scheme, this._authority - this._scheme - 1);
    }

    public String getAuthority() {
        if (this._authority == this._path) {
            return null;
        }
        return this.toUtf8String(this._authority, this._path - this._authority);
    }

    public String getHost() {
        if (this._host == this._port) {
            return null;
        }
        return this.toUtf8String(this._host, this._port - this._host);
    }

    public int getPort() {
        if (this._port == this._path) {
            return -1;
        }
        return TypeUtil.parseInt(this._raw, this._port + 1, this._path - this._port - 1, 10);
    }

    public String getPath() {
        if (this._path == this._param) {
            return null;
        }
        return this.toUtf8String(this._path, this._param - this._path);
    }

    public String getDecodedPath() {
        if (this._path == this._param) {
            return null;
        }
        int n = this._param - this._path;
        byte[] byArray = null;
        int n2 = 0;
        for (int i = this._path; i < this._param; ++i) {
            byte by = this._raw[i];
            if (by == 37 && i + 2 < this._param) {
                by = (byte)(0xFF & TypeUtil.parseInt(this._raw, i + 1, 2, 16));
                i += 2;
            } else if (byArray == null) {
                ++n2;
                continue;
            }
            if (byArray == null) {
                byArray = new byte[n];
                for (int j = 0; j < n2; ++j) {
                    byArray[j] = this._raw[this._path + j];
                }
            }
            byArray[n2++] = by;
        }
        if (byArray == null) {
            return this.toUtf8String(this._path, n);
        }
        this._utf8b.reset();
        this._utf8b.append(byArray, 0, n2);
        return this._utf8b.toString();
    }

    public String getPathAndParam() {
        if (this._path == this._query) {
            return null;
        }
        return this.toUtf8String(this._path, this._query - this._path);
    }

    public String getCompletePath() {
        if (this._path == this._end) {
            return null;
        }
        return this.toUtf8String(this._path, this._end - this._path);
    }

    public String getParam() {
        if (this._param == this._query) {
            return null;
        }
        return this.toUtf8String(this._param + 1, this._query - this._param - 1);
    }

    public String getQuery() {
        if (this._query == this._fragment) {
            return null;
        }
        return this.toUtf8String(this._query + 1, this._fragment - this._query - 1);
    }

    public String getQuery(String string) {
        if (this._query == this._fragment) {
            return null;
        }
        return StringUtil.toString(this._raw, this._query + 1, this._fragment - this._query - 1, string);
    }

    public boolean hasQuery() {
        return this._fragment > this._query;
    }

    public String getFragment() {
        if (this._fragment == this._end) {
            return null;
        }
        return this.toUtf8String(this._fragment + 1, this._end - this._fragment - 1);
    }

    public void decodeQueryTo(MultiMap multiMap) {
        if (this._query == this._fragment) {
            return;
        }
        this._utf8b.reset();
        UrlEncoded.decodeUtf8To(this._raw, this._query + 1, this._fragment - this._query - 1, multiMap, this._utf8b);
    }

    public void decodeQueryTo(MultiMap multiMap, String string) throws UnsupportedEncodingException {
        if (this._query == this._fragment) {
            return;
        }
        if (string == null || StringUtil.isUTF8(string)) {
            UrlEncoded.decodeUtf8To(this._raw, this._query + 1, this._fragment - this._query - 1, multiMap);
        } else {
            UrlEncoded.decodeTo(this.toUtf8String(this._query + 1, this._fragment - this._query - 1), multiMap, string);
        }
    }

    public void clear() {
        this._end = 0;
        this._fragment = 0;
        this._query = 0;
        this._param = 0;
        this._path = 0;
        this._port = 0;
        this._host = 0;
        this._authority = 0;
        this._scheme = 0;
        this._raw = __empty;
        this._rawString = "";
    }

    public String toString() {
        if (this._rawString == null) {
            this._rawString = this.toUtf8String(this._scheme, this._end - this._scheme);
        }
        return this._rawString;
    }

    public void writeTo(Utf8StringBuffer utf8StringBuffer) {
        utf8StringBuffer.append(this._raw, this._scheme, this._end - this._scheme);
    }
}

